package com.tin.etbaf.annexure1;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.Chk_LengthOnly;
import com.tin.etbaf.rpu.GRPU;
import com.tin.etbaf.rpu.GrpuUtil;
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorTotTaxDep extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;
    String valueOfTypeOfStmt;
    public GRPUTableCellEditorTotTaxDep(String valueOfTypeOfStmt)
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
        this.valueOfTypeOfStmt=valueOfTypeOfStmt;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"Total Tax Deposited should be valid.For e.g. 1000");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText((String)value);
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    public Object getCellEditorValue()
    {

	       String tds=((JTextField)component).getText().toString();
	       int dotcount=0;
	       int dotpos=0;
	       DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
			df.setMaximumFractionDigits(2);
	    //  System.out.println("the type of statement is in total taxdeposted " + this.valueOfTypeOfStmt );
		
	       if(!((JTextField)component).getText().toString().equals(""))
	       {
	       if(((JTextField)component).getText().toString().length() <= 15)
	        {  
	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
	        	{
	            	GRPU.grpu.getMessage(" Total Tax Deposited should be valid.For e.g. 1000");
	            	GRPU.grpu.setErrorAt(rowTable, colTable);
	            	return "0.00";
	        	}
	    	   
	    	   
	    	   
	    	   if(!tds.contains("."))
	           { 
	    		  if(tds.equals("0"))
    		     {
    		    	 String tdamount=tds.toString()+".000.00";
    	    		 ((JTextField)component).setText(tdamount); 
    		    	 
    		     }
    		     else
    		     { 
    		    	 String tdamount=tds.toString()+".00";
    		         ((JTextField)component).setText(tdamount);
    		     }
	              if(((JTextField)component).getText().toString().length()>15)
	              { GRPU.grpu.getMessage(" Length of  Total Tax Deposited  should not exceed 15 digits");
		            GRPU.grpu.setErrorAt(rowTable, colTable);
		            return "0.00";
	              }
	              else
	              {
	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
	            	//GRPU.grpu.setTotalTaxDedcuted(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	            	
	            	//To set the value in  lastTotalTaxDepstd for correction Type
//	            	if(this.valueOfTypeOfStmt.equals("Correction"))
//	            	GRPU.grpu.lastTotalTaxDepstd(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	            	//Modified by Akansha
	            	return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
	              }
	           
	           }
	           else
	        	   {
	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
	        		 //To set the value in  lastTotalTaxDepstd for correction Type
//	        		   if(this.valueOfTypeOfStmt.equals("Correction"))
//	        		   GRPU.grpu.lastTotalTaxDepstd(((JTextField)component).getText().trim().toString(),rowTable,colTable);
	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
	        	   }
	        }
	    	 //Newly added
	        else
  	    	{  GRPU.grpu.getMessage(" Length of  Total Tax Deposited  should not exceed 15 digits");
		       GRPU.grpu.setErrorAt(rowTable, colTable);
		       return "0.00";
  	    		
  	    	}
	        }
	
	       else
	       {
	    	 //  GRPU.grpu.getMessage(" Total Tax Deposited  should be valid.For e.g. 1000");
	           GRPU.grpu.setErrorAt(rowTable, colTable);
	         //To set the value in  lastTotalTaxDepstd for correction Type
	          // if(this.valueOfTypeOfStmt.equals("Correction"))
	           //GRPU.grpu.lastTotalTaxDepstd(((JTextField)component).getText().trim().toString(),rowTable,colTable); 
	           return "0.00";
	    	   
	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }
}

