package com.tin.etbaf.annexure3;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.rpu.*;
import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class GRPUTableCellEditorDedInRespOfHealthInsurance80DDeductibleAmount extends AbstractCellEditor
implements TableCellEditor{
	
	JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorDedInRespOfHealthInsurance80DDeductibleAmount()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(15));
        //Added newly on 09/07/2015 ---- R&D by Akansha
        new SecondaryValidations().numericValidation(component,"<html>Deduction in respect of health insurance premia u/s 80D (Deductible Amount)<br> should be valid.For e.g. 1000.00</html>");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
       
    	DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
    	       Object tds=((JTextField)component).getText().toString();
    	        if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   
    	    	if(((JTextField)component).getText().toString().trim().length() <= 15)
		        {  
    	    	   if(GrpuUtil.isDecimalNonZero(((JTextField)component).getText().toString().trim(),2))
   		            {
   		            
    	    		   	GRPU.grpu.getMessage("<html>Deduction in respect of health insurance premia u/s 80D (Deductible Amount)<br> should be valid.For e.g. 1000.00</html>");
   		            	GRPU.grpu.setErrorAt(rowTable, colTable);
   		            	
   		            	return "0.00";
   		            }
    	    	       
    	    	   
    	    	   
    	    	   if(!tds.toString().contains("."))
    	           {
    	    		 
    	    		   if(tds.equals("0"))
    	    		     {
    	    		    	 String tdamount=tds.toString()+".000.00";
    	    	    		 ((JTextField)component).setText(tdamount); 
    	    		    	 
    	    		     }
    	    		     else
    	    		     { 
    	    		    	 String tdamount=tds.toString()+".00";
    	    		         ((JTextField)component).setText(tdamount);
    	    		     }
    	    		 
    	              if(((JTextField)component).getText().toString().length()> 15)
    	              { GRPU.grpu.getMessage("<html> Length of Deduction in respect of health insurance premia u/s 80D (Deductible Amount) should not exceed 15 digits</html>");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
       		            return "0.00";
    	              }
    	              else
    	              {
    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
   	                    
    	            	GRPU.grpu.setAggregateDedAmntChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	            	GRPU.grpu.setTotalTaxableIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
   	                    return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
    	              }
    	           
    	           }
    	           else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   
    	        		   GRPU.grpu.setAggregateDedAmntChapVIA(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   GRPU.grpu.setTotalTaxableIncome(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
    	        	   }
    	           
    	        }
    	      
    	    	else
    	    	{  GRPU.grpu.getMessage("<html> Deduction in respect of health insurance premia u/s 80D (Deductible Amount) should not exceed 15 digits</html>");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           return "0.00";
    	    		
    	    	}
    	       
    	       
    	       }
    	
    	       else
    	       {
    	    	  // GRPU.grpu.getMessage("<html>Income tax relief under section 89 when salary etc. is paid in arrear or in advance <br> can not be blank for record number "+(rowTable -1)+" in Annexure II details.</html>");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           GRPU.grpu.setAggregateDedAmntChapVIA("0.00",rowTable,colTable);
		           GRPU.grpu.setTotalTaxableIncome("0.00",rowTable,colTable);
		           return "0.00";
    	    	   
    	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }

}
