package com.tin.etbaf.rpu;

import javax.swing.text.*;

public class Chk_Length_SplChar extends PlainDocument
{
	int maxSize;

    public Chk_Length_SplChar(int limit)
    {
        maxSize = limit;
    }

    public void insertString(int offs, String str, AttributeSet a)
        throws BadLocationException
    {
        if(getLength() + str.length() <= maxSize)
            super.insertString(offs, str, a);
        else
            throw new BadLocationException("Insertion exceeds max size of document", offs);
    }

    public void insertUpdate(javax.swing.text.AbstractDocument.DefaultDocumentEvent evt, AttributeSet a)
    {
        int off = evt.getOffset();
        int len = evt.getLength();
        boolean gLenChk = true;
        try
        {
            String str = evt.getDocument().getText(off, len);
           boolean speclCharCheck = checkOneAlpahNum(str);
           if(!speclCharCheck)
           {
        	   evt.getDocument().remove(off, len);
        	   GRPU.grpu.getMessage("Special Characters not Allowed");
        	   
           }
            
           if(str.trim().equals("^"))
           {
               evt.getDocument().remove(off, len);
                GRPU.grpu.getMessage("Special Character : '^' Not Allowed");
           }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
    private boolean checkOneAlpahNum(String str)
	{
		if(str!=null)
		{
			int lenghtOfString =str.length();
			if(str.trim().length()!=lenghtOfString)
			{
				return false;
			}	
				for (int i=0;i<lenghtOfString;i++)
				{
					if( (str.charAt(i)> 47 && str.charAt(i)< 58) || ((str.charAt(i)> 64 && str.charAt(i)< 91) || (str.charAt(i)> 96 && str.charAt(i)< 123)))
					{
						return true;
					}
				}
		}
		return false;
	}
	
	
}
