
package com.tin.etbaf.rpu;

import java.awt.*;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class GRPUHelp extends JFrame
{

    JEditorPane html;
    Image GRPULogo;
   

    public GRPUHelp(String formnum)
    {
    	
        GRPULogo = Toolkit.getDefaultToolkit().getImage("icon/iconNSDL.png");
        layoutComponents(formnum);
    }

    private void layoutComponents(String form)
    {
    	//Form number
    	String formnum = form;
//    	System.out.println("Form Name: "+form);
    	//****************************
    	
        try
        {
        	java.net.URL url = null;
            String path = null;
            try
            {
            	if("24Q".equals(form))
            		path = "24QHelp.html";
            	else if("26Q".equals(form))
            		path = "26QHelp.html";
            	else if("27Q".equals(form))
            		path = "27QHelp.html";
            	else if("27EQ".equals(form))
            		path = "27EQHelp.html";
            	else
                path = "CommonHelp.html";
            	
            	url = getClass().getResource(path);
             
            }
            catch(Exception e)
            {
                System.err.println("Failed to open " + path);
                url = null;
            }
            if(url != null)
            {
                html = new JEditorPane(url);
                html.setEditable(false);
                html.addHyperlinkListener(createHyperLinkListener());
                JScrollPane scroller = new JScrollPane();
                javax.swing.JViewport vp = scroller.getViewport();
                vp.add(html);
                getContentPane().add(scroller, "Center");
            }
        }
        catch(MalformedURLException e)
        {
            e.printStackTrace();
        }
        catch(IOException e)
        {
            e.printStackTrace();
        }
//        java.awt.Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
//        setLocation(0, 0);
        setIconImage(GRPULogo);
        setTitle("RPU Help");
//        setSize(dim);
//        setIconImage(GRPULogo);
//        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//        setResizable(false);
//        setVisible(true);
        
        setExtendedState(JFrame.MAXIMIZED_BOTH);
		setVisible(true);
    }

    public HyperlinkListener createHyperLinkListener()
    {
        return new HyperlinkListener() {

            public void hyperlinkUpdate(HyperlinkEvent e)
            {
                if(e.getEventType() == javax.swing.event.HyperlinkEvent.EventType.ACTIVATED)
                    if(e instanceof HTMLFrameHyperlinkEvent)
                        ((HTMLDocument)html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    else
                        try
                        {
                            html.setPage(e.getURL());
                        }
                        catch(IOException ioe)
                        {
                            ioe.printStackTrace();
                        }
            }

        };
    }

//    public static void main(String args[])
//    {
//        new GRPUHelp();
//    }
}
