package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class GRPUTableCellEditorEmail extends AbstractCellEditor implements TableCellEditor{

	JComponent component;
	int rowTable;
	int colTable;


	public GRPUTableCellEditorEmail()
	{
		//System.out.println("Constructor");
		component = new JTextField();
		 component.addFocusListener(new FocusListener() {
				
				@Override
				public void focusLost(FocusEvent arg0) {
					JButton eventOwner;
					if(arg0.getOppositeComponent() instanceof JButton)
					{
						eventOwner =  (JButton) arg0.getOppositeComponent();
						if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
							GRPU.grpu.isCreateFileFocusOut = true;
						}					
					}
					else{
						GRPU.grpu.isCreateFileFocusOut = false;
					}
				}
				
				@Override
				public void focusGained(FocusEvent arg0) {
					// TODO Auto-generated method stub
					
				}
			});
		rowTable = 0;
		colTable = 0;
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int row, int column) {
		
		//System.out.println(value);
		((JTextField)component).setDocument(new Chk_LengthOnly(75));
		 if(value == null)
	            ((JTextField)component).setText("");
	        else
	            ((JTextField)component).setText((String)value);
	        rowTable = row;
	        colTable = column;
	        return component;
	}

	public Object getCellEditorValue() {
		
		String email=((JTextField)component).getText();
		
		if(email.equals(""))
		{
			GRPU.grpu.setNoErrorAt(rowTable, colTable);
			return "";
		}
		
		
		if(!GrpuUtil.isValidEmail(email))
		{
			GRPU.grpu.getMessage("Invalid Email ID");
            GRPU.grpu.setErrorAt(rowTable, colTable);
            return "";
		}
			
		GRPU.grpu.setNoErrorAt(rowTable, colTable);
		return ((JTextField)component).getText();
	}


	 public boolean isCellEditable(EventObject evt)
	    {
		 
		 //System.out.println("ing getCellEditable");
		
	        if(evt instanceof MouseEvent)
	        {
	            int clickCount = 2;
	            return ((MouseEvent)evt).getClickCount() >= clickCount;
	        } else
	        {
	            return true;
	        }
	    }
}
