package com.tin.etbaf.rpu;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventObject;

import javax.swing.*;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

import com.tin.etbaf.validations.SecondaryValidations;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU, GrpuUtil

public class GRPUTableCellEditorFeeChallan extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
  
    int rowTable;
    int colTable;

    public GRPUTableCellEditorFeeChallan()
    {
        component = new JTextField();
        component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(20));
        //Added newly on 09/07/2015 ---- R&D by Akansha
       
        new SecondaryValidations().numericValidation(component,"Fee amount should be valid.For e.g. 1000.00");
        if(value == null)
            ((JTextField)component).setText("0.00");
        else
            ((JTextField)component).setText(String.valueOf(value));
        
        ((JTextField)component).setHorizontalAlignment(SwingConstants.RIGHT);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    
    
    
    public Object getCellEditorValue()
    {
    	DecimalFormatSymbols sf = new DecimalFormatSymbols(Locale.ENGLISH);DecimalFormat df = new DecimalFormat("0.00",sf);
		df.setMaximumFractionDigits(2);
    	       String fee=((JTextField)component).getText().toString();
    	       
    	       if(!((JTextField)component).getText().toString().equals(""))
    	       {
    	    	   if(((JTextField)component).getText().toString().length() <= 15)
		        {  
    	    	   if(GrpuUtil.isDecimal(((JTextField)component).getText().toString().trim(),2))
   		        	{
   		            		GRPU.grpu.getMessage("Fee amount should be valid.For e.g. 1000.00");
   		            		GRPU.grpu.setErrorAt(rowTable, colTable);
   		            		return "0.00";
   		        	}
    	    	   
    	    	   if(!fee.contains("."))
    	           { 
    	    		 if(fee.equals("0"))
	    		     {
	    		    	 String tdamount=fee.toString()+".000.00";
	    	    		 ((JTextField)component).setText(tdamount); 
	    		    	 
	    		     }
	    		     else
	    		     { 
	    		    	 String tdamount=fee.toString()+".00";
	    		         ((JTextField)component).setText(tdamount);
	    		     }
    	              if(((JTextField)component).getText().toString().length()>15)
    	              { GRPU.grpu.getMessage(" Length of Fee should not exceed 15 digits");
     		            GRPU.grpu.setErrorAt(rowTable, colTable);
     		           return "0.00";
    	              }
    	              else
    	              {
    	            	GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	            	GRPU.grpu.setTotalTaxDepvalue(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	            	return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));  
    	              }
    	           
    	           }
    	           else
    	        	   {
    	        		   GRPU.grpu.setNoErrorAt(rowTable, colTable);
    	        		   GRPU.grpu.setTotalTaxDepvalue(((JTextField)component).getText().trim().toString(),rowTable,colTable);
    	        		   return df.format(Double.parseDouble(((JTextField)component).getText().trim()+"0" ));
    	        	   }
    	           
    	    	 //Newly added
	        	} 
	    	   else
        	    	{  GRPU.grpu.getMessage(" Length of Fee should not exceed 15 digits");
    		           GRPU.grpu.setErrorAt(rowTable, colTable);
    		           return "0.00";
        	    		
        	    	} 
		        
		        }
    	
    	       else
    	       {
    	    	  // GRPU.grpu.getMessage("Fee amount should be valid.For e.g. 1000.00");
		           GRPU.grpu.setErrorAt(rowTable, colTable);
		           GRPU.grpu.setTotalTaxDepvalue("0.00",rowTable,colTable); 
		           return "0.00";
    	    	   
    	       }
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    
    }  
}
