
package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorName extends AbstractCellEditor
    implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;

    public GRPUTableCellEditorName()
    {
        component = new JTextField();
 component.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				JButton eventOwner;
				if(arg0.getOppositeComponent() instanceof JButton)
				{
					eventOwner =  (JButton) arg0.getOppositeComponent();
					if("Create File".equalsIgnoreCase(eventOwner.getText().trim()) ){
						GRPU.grpu.isCreateFileFocusOut = true;
					}					
				}
				else{
					GRPU.grpu.isCreateFileFocusOut = false;
				}
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
        rowTable = 0;
        colTable = 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
        ((JTextField)component).setDocument(new Chk_LengthOnly(75));
        ((JTextField)component).setDocument(new Chk_LengthOnly(75));
        if(value == null)
            ((JTextField)component).setText("");
        else
            ((JTextField)component).setText((String)value);
        rowTable = rowIndex;
        colTable = vColIndex;
        return component;
    }

    public Object getCellEditorValue()
    {
        Object value = ((JTextField)component).getText();
      //  System.out.println(((JTextField)component).getText().toString().trim().length()+"  lENGTH oF sADSA");
        if(((JTextField)component).getText().toString().trim().length() > 75)
        {
            GRPU.grpu.getMessage("Name of the DDO cannot be greater than 75 characters");
            GRPU.grpu.setErrorAt(rowTable, colTable);
            return "";
        }
        if(((JTextField)component).getText().toString().trim().length() == 0)
        {
            GRPU.grpu.getMessage("Valid Name of the DDO must be provided");
            GRPU.grpu.setErrorAt(rowTable, colTable);
            return "";
        }
        if(value != null)
        {
        	if(!GrpuUtil.checkOneAlpahNum(value.toString()))
            {
            	String message = "Special Characters / Numbers not Allowed in DDO Name";
            	GRPU.grpu.getMessage(message);
            	 GRPU.grpu.setErrorAt(rowTable, colTable);
                 return "";
            	
            }
            int posCaret = value.toString().trim().indexOf("^");
            if(posCaret != -1)
            {
                GRPU.grpu.getMessage("Special Character : '^' Not Allowed for Name of the DDO");
                String strRmCaret = value.toString().trim().substring(0, posCaret);
                ((JTextField)component).setText(strRmCaret);
            }
        }
        GRPU.grpu.setNoErrorAt(rowTable, colTable);
        return ((JTextField)component).getText();
    }

    public boolean isCellEditable(EventObject evt)
    {
        if(evt instanceof MouseEvent)
        {
            int clickCount = 2;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        } else
        {
            return true;
        }
    }
}
