
package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import com.tin.etbaf.rpu.GRPU;
// Referenced classes of package com.tin.etbaf.rpu:
//            Chk_LengthOnly, GRPU

public class GRPUTableCellEditorRevisionMode extends JComboBox implements TableCellEditor
{

    JComponent component;
    int rowTable;
    int colTable;
    GRPU grpuObjectReference = null;
    private String correctionType = "";
    protected EventListenerList listenerList = new EventListenerList();

    protected ChangeEvent changeEvent = new ChangeEvent(this);
    
    public GRPUTableCellEditorRevisionMode(GRPU grpuObject)
    {
    	 super();
    	 addItem("--Select--");
    	 addItem("Delete");
    	 grpuObjectReference = grpuObject;
       //   component = new JComboBox(new String[] {"--Select--","Delete"});
        rowTable = 0;
        colTable = 0;
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
            	
            	
            	// User cannot select Delete in case of Cancel
            	correctionType = grpuObjectReference.getTypeOfCorrection();
            	if(correctionType.equalsIgnoreCase("Cancel"))
            	{
            		GRPU.grpu.getMessage("You cannot select delete in cancel mode.");
            		cancelCellEditing();
            	}
            		//  fireEditingStopped();
            }
          });
      }
    
  

	public void addCellEditorListener(CellEditorListener listener) {
        listenerList.add(CellEditorListener.class, listener);
      }

      public void removeCellEditorListener(CellEditorListener listener) {
        listenerList.remove(CellEditorListener.class, listener);
      }

      protected void fireEditingStopped() {
        CellEditorListener listener;
        Object[] listeners = listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i++) {
          if (listeners[i] == CellEditorListener.class) {
            listener = (CellEditorListener) listeners[i + 1];
            listener.editingStopped(changeEvent);
          }
        }
      }

      protected void fireEditingCanceled() {
        CellEditorListener listener;
        Object[] listeners = listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i++) {
          if (listeners[i] == CellEditorListener.class) {
            listener = (CellEditorListener) listeners[i + 1];
            listener.editingCanceled(changeEvent);
          }
        }
      }

      public void cancelCellEditing() {
        fireEditingCanceled();
      }

      public boolean stopCellEditing() {
        fireEditingStopped();
        return true;
      }

      public boolean isCellEditable(EventObject event) {
        return true;
      }

      public boolean shouldSelectCell(EventObject event) {
        return false;
      }
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex)
    {
    	
        
        return this;
    }
    public Object getCellEditorValue()
    {
    	// System.out.println(((JComboBox)this).getSelectedItem().toString());
        return ((JComboBox)this).getSelectedItem();
    }
  
    
   
}
