/*
 * Created by Akansha Rajesh
 * Purpose: This class is being used for adding tooltips to the combo boxes used for section codes of
 * Challan and AnnexureI
 * Created Date: 05/08/2015
 * New development for ver1.3 of Java RPU exe
 */


package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.Array;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class MyComboBoxRenderer extends BasicComboBoxRenderer  {
	public String[] sectionArry;
	public List<String> tooltipsArry = new ArrayList<String>();
	JList comboList;
	JComboBox combo;
	String formNumber;
	
	MyComboBoxRenderer(){
		super();
	}
	
	 public MyComboBoxRenderer(String[] sectioncd,JComboBox combo, String formNumber) {
		 this.sectionArry = sectioncd;
		 this.combo = combo;
		this.formNumber = formNumber;
		System.out.println("Form Number" + formNumber);
		 toolTips();
	}
	 //Added for forming the required tooltip array depending on the section codes
	 public void toolTips(){
		 String []sections = this.sectionArry;
		String formNumber = this.formNumber;
		 tooltipsArry.add("--Select--");
		 
		 if(sections!=null)
		 for(int i=0;i<sections.length;i++){
			 if(sections[i]!=null){
			// System.out.println("Sections: "+sections[i] );
			 if("92A".equals(sections[i].toString())){
				this.tooltipsArry.add("192 - 92A - Payment to Govt. Employees other than Union Government Employees");
			 }else if("92B".equals(sections[i].toString())){
				 this.tooltipsArry.add("192 - 92B - Payment of Employees other than Govt. Employee");
			 }else if("92C".equals(sections[i].toString())){
				 this.tooltipsArry.add("<html>192 - 92C - Payments made to Union Govt. employees.<br>(Applicable from statement pertaining to FY 2013-14 onwards)</html>");
			 }else if("94P".equals(sections[i].toString())){
				 this.tooltipsArry.add("194P - Deduction of tax in case of specified senior citizens"); //CR 80278 new section code 194P
			 }
			 else if("193".equals(sections[i].toString())){
				 this.tooltipsArry.add("193 - Interest on Securities");
				 }
				 else if("194".equals(sections[i].toString())){
				 this.tooltipsArry.add("194 - Dividend");
				 }
				 else if("194IC".equals(sections[i].toString())){
					 this.tooltipsArry.add("194IC - Payment under specified agreement");
				 }
			//Section Code changes for RPU 2.9
				 else if("94N".equals(sections[i].toString())){
					 this.tooltipsArry.add("94N - Payment of certain amounts in cash other than cases covered by first proviso or third proviso ");//Renuka for CR84532

			//		 this.tooltipsArry.add("94N - Payment of certain amounts in cash other than cases covered by first provison or third provison ");//Renuka CR84532

				 }
				 else if("94A".equals(sections[i].toString())){
				 this.tooltipsArry.add("194A - Interest other than interest on securities");
				 }
				 else if("94B".equals(sections[i].toString())){
				 this.tooltipsArry.add("194B - Winnings from lottery or crossword puzzle, etc");//Renuka for CR84532 //used as tooltip for 27Q new section code
				 }
				 else if("4BB".equals(sections[i].toString())){
				 this.tooltipsArry.add("194BB - Winnings from horse race");
				 }
				 else if("94C".equals(sections[i].toString())){
				 this.tooltipsArry.add("194C - Payment of contractors and sub-contractors");
				 }
				 else if("94D".equals(sections[i].toString())){
				 this.tooltipsArry.add("194D - Insurance Commission");
				 }
				 else if("4EE".equals(sections[i].toString())){
				 this.tooltipsArry.add("194EE - Payments in respect of Deposits under National Savings Schemes");
				 }
				 else if("94F".equals(sections[i].toString())){
				 this.tooltipsArry.add("194F - Payments on account of Re-purchase of Units by Mutual Funds or UTI");
				 }
				 else if("94G".equals(sections[i].toString())){
				 this.tooltipsArry.add("194G - Commission, prize etc., on sale of Lottery tickets");
				 }
				 else if("94H".equals(sections[i].toString())){
				 this.tooltipsArry.add("194H - Commission or Brokerage");
				 }
				 else if("94I".equals(sections[i].toString())){
				 this.tooltipsArry.add("194I - Rent (Applicable upto FY 2012-13)");
				 }
				 else if("4IA".equals(sections[i].toString())){
				 this.tooltipsArry.add("194I (a) - Rent on Machinery, Plant or Equipment (Applicable from FY 2013-14 onwards)");
				 }
				 else if("4IB".equals(sections[i].toString())){
				 this.tooltipsArry.add("194I (b) - Rent on Land or Building (Applicable from FY 2013-14 onwards)");
				 }
				 else if("94J".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("194J - Fees for Professional or Technical Services");
				 }
				 else if("4JA".equals(sections[i].toString())){ //RPU 3.3 start 
					 this.tooltipsArry.add("<html>194J(a) - Fees for Technical Services (not being professional services),<br> royalty for sale, distribution or exhibition of cinematographic films <br>and call centre (@2%)</html>");
				 }
				 else if("4JB".equals(sections[i].toString())){ 
					 this.tooltipsArry.add("194J(b) - Fee for professional service or royalty etc. (@10%)");
				 }
				 else if("94K".equals(sections[i].toString())){ //RPU 3.2 start addition of new section 94K for form 26Q
					 this.tooltipsArry.add("194K - TDS on income from Mutual Fund units");
				 }
				 else if("94L".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("194LA - Payment of Compensation on acquisition of certain immovable property");
				 }
			 else if ("94O".equals(sections[i].toString())) {
				 this.tooltipsArry.add("194O - TDS on E-commerce transactions"); //RPU 3.5 start Addition of new section codes 
			 }
			 else if ("94Q".equals(sections[i].toString())) {
				 this.tooltipsArry.add("194Q- Payment of certain sums for purchase of goods"); //RPU 3.7 CR 81169
			 }
				 else if("4BA".equals(sections[i].toString())) // new development for FRD1.3 by Akansha
				 {
				 this.tooltipsArry.add("<html>194LBA  - Certain income from units of business trust<br> (Applicable from FY 2014-15 Q3 onwards.)</html>");
				 }
				 else if("4DA".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194DA  - Payment in respect of life insurance policy<br> (Applicable from FY 2014-15 Q3 onwards)</html>");
				 }
				 else if("2AA".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>192A  - Payment of accumulated balance due to an employee made by the trustees of the Employees<br> Provident Fund Scheme, 1952. (Applicable for statements pertaining to FY 2015-16 onwards)</html>");
				 }
				 else if("LBB".equals(sections[i].toString()))//newly developed for FRD1.6 by akansha
				 {
				 this.tooltipsArry.add("<html>194LBB - Income in respect of units of investment fund <br>(Applicable for statements pertaining to FY 2015-16 onwards)</html>");
				 }
				 else if("94E".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("194E - Payments to non-resident Sportsmen/Sport Associations");
				 }
				 else if("195".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("195 - Other sums payable to a non-resident");
				 }
				 else if("96A".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("196A - Income in respect of units of Non-Residents");
				 }
				 else if("96B".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("196B - Payments in respect of Units to an Offshore Fund");
				 }
				 else if("96C".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>196C - Income from foreign Currency Bonds or <br>shares of Indian Company payable to Non-Resident</html>");
				 }
				 else if("96D".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("196D - Income of foreign institutional investors from securities");
				 }
				 else if("6DA".equals(sections[i].toString())) //CR 80278 new section code 196DP
				 {
				 this.tooltipsArry.add("<html>196D(1A)- Income of specified fund from securities <br>referred to in clause (a) of sub-section (1) <br>of section 115AD (other than interest income referred to in section 194LD)</html>");
				}
				 else if("4LB".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LB  - Income by way of Interest from <br>Infrastructure Debt fund (Applicable from FY 2011-12 onwards)</html>");
				 }
				 else if("4LC".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LC  - Income by way of interest from Indian company engaged <br>in certain business. (Applicable from FY 2012-13 onwards).</html>");
				 }
			//rahul CR84532 27Q for section codes LC1 LC2 and LC3 start
				 else if("LC1".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LC (2)(i) and (ia) - Income under clause (i) and (ia) of sub-section (2) of section 194LC.</html>");
				 }
				 else if("LC2".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LC (2)(ib) - Income under clause (ib) of sub-section (2) of section 194LC.</html>");
				 }
				 else if("LC3".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LC (2)(ic) - Income under clause (ic) of sub-section (2) of section 194LC.</html>");
				 }
			//rahul CR84532 27Q for section codes LC1 LC2 and LC3 end
				 else if("4LD".equals(sections[i].toString()))//newly developed for FRD1.6 by Akansha
				 {
				 this.tooltipsArry.add("194LD  - Income by way of interest on certain bonds and Government securities");
				 }
				 else if("4BA".equals(sections[i].toString()))// new development for FRD1.3 by Akansha
				 {
				 this.tooltipsArry.add("<html>194LBA  - Certain income from units of business trust <br>(Applicable from FY 2014-15 Q3 onwards.)</html>");
				 }
				 else if("LBB".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>194LBB - Income in respect of units of investment fund - <br>(Applicable for statements pertaining to FY 2015-16 onwards) </html>");
				 }
			 	//RPU 3.4 start Addition of new section codes 
				 else if ("BA1".equals(sections[i].toString()) && formNumber.equals("26Q") )
				{
					   this.tooltipsArry.add("<html>194LBA(a)  - Certain income in the form of interest from units <br>of a business trust to a residential unit holder</html>");
				}
				 else if ("BA2".equals(sections[i].toString())  && formNumber.equals("26Q"))// new development
				{
					 this.tooltipsArry.add("<html>194LBA(b)  - Certain income in the form of dividend from units <br>of a business trust to a residential unit holder.)</html>");
				}
				 else if ("BA1".equals(sections[i].toString())  )
					{
						   this.tooltipsArry.add("<html>194LBA (a) - Income referred to in section 10(23FC)(a)<br> from units of a business trust</html>");
					}
					 else if ("BA2".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194LBA (b) - Income referred to in section 10(23FC)(b)<br> from units of a business trust</html>");
					}
				 else if ("BA3".equals(sections[i].toString()) )// new development
					{
						 this.tooltipsArry.add("<html>194LBA (c) - Income referred to in section 10(23FCA)<br> from units of a business trust</html>");
					}
				 else if ("4NF".equals(sections[i].toString()))// new development
				{
					 this.tooltipsArry.add("<html>194NF - Payment of certain amounts in cash to non-filers except in case of co-operative societies.</html>");//Renuka CR84532
				} 
			// Rahul CR83190
				 else if ("94S".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194S - Payment of consideration for transfer of virtual digital <br>asset by persons other than specified persons</html>");
					} 
				 else if ("94R".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194R - Benefits or perquisites of business or profession</html>");
					} 
				 else if ("4BP".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194B-P - Winnings from lottery or crossword puzzle, etc where consideration <br>is made in kind or cash is not sufficient to meet the tax liability and <br>tax has been paid before such winnings are released</html>");//Renuka for CR84532 //used as a tooltip for 27Q new section
					} 
				 else if ("4RP".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194R-P - Benefits or perquisites of business or profession where such benefit <br>is provided in kind or where part in cash is not sufficient to meet tax liability <br>and tax required to be deducted is paid before such benefit is released</html>");
					} 
				 else if ("4SP".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194S-P - Payment for transfer of virtual digital asset where payment is in <br>kind or in exchange of another virtual digital asset and <br>tax required to be deducted is paid before such payment is released</html>");
					}
			//rahul CR84532 26Q Section Code Addition 194BA start
				 else if ("9BA".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194BA - Winnings from online games</html>");
					}
			//rahul CR84532 26Q Section Code Addition 194BA end
			 
			//rahul CR84532 26Q Section Code Addition 194BA-P  4AP start
				 else if ("4AP".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html>194BA-P - Net Winnings from online games where the net winnings are made in kind or<br> cash is not sufficient to meet the tax liability and tax has been paid before such net winnings are released.</html>");
					}
			//rahul CR84532 26Q Section Code Addition 194BA-P  4AP end
				//added by renuka for 9FT starts
				 else if ("9FT".equals(sections[i].toString()))// new development
					{
						 this.tooltipsArry.add("<html> 194N-FT - Payment of certain amount in cash to non-filers being co-operative societies</html>");
					}
				//added by renuka for 9FT ends
			//CR 84532 26Q Section Code Addition 194NC start by Khalid
				 else if ("4NC".equals(sections[i].toString()))// new development
                 {
                      this.tooltipsArry.add("<html>Payment of certain amounts in cash to co-operative societies not covered by first provison.</html>");
                 }
			//CR 84532 26Q Section Code Addition 194NC end by Khalid
			//rahul CR 88442 26Q Section Code 94T start
				 else if ("94T".equals(sections[i].toString()))// new development
                 {
                      this.tooltipsArry.add("<html>194T - Payment of salary, remuneration, commission, bonus or interest to a partner of the firm</html>");
                 }
			//rahul CR 88442 26Q Section Code 94T end
				 else if("A".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - A - Collection at source from Alcoholic Liquor for Human Consumption");
				 }
				 else if("B".equals(sections[i].toString()))
				 {
				// this.tooltipsArry.add("206C - B - Collection at source from timber obtained under Forest Lease");
				   this.tooltipsArry.add("206C - B - Collection at source from timber or any other forest produce"); //CR 88815 rahul 27Q 206CB description change
				 }
				 else if("C".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>206C - C - Collection at source from Timber <br>obtained by any Mode other than a Forest Lease</html>");
				 }
				 else if("D".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>206C - D - Collection at source from any other <br>Forest Produce (not being Tendu Leaves)</html>");
				 }
				 else if("E".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - E - Collection at source from Scrap");
				 }
				 else if("F".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - F - Collection at source from contractors or licensee or lease relating to Parking lots");
				 }
				 else if("G".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - G - Collection at source from contractors or licensee or lease relating to toll plaza");
				 }
				 else if("H".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - H - Collection at source from contractors or licensee or lease relating to mine or quarry");
				 }
				 else if("I".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("206C - I - Collection at source from tendu leaves");
				 }
				 else if("J".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>206C - J - Collection at source from on sale of certain <br>Minerals (Applicable from 2nd Quarter of FY 2012-13 onwards)</html>");
				 }
				 else if("K".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("<html>206C - K - Collection at source on cash case of Bullion and <br>Jewellery (Applicable from 2nd Quarter of FY 2012-13 onwards)</html>");
				 }
			 	//newly added for FRD1.5 by akansha
				 else if("9IA".equals(sections[i].toString()))
				 {
				 this.tooltipsArry.add("194IA  TDS on Sale of Property");
				 }
			 
			 	//newly added for FRD1.6 by akansha
				 else if("LBC".equals(sections[i].toString())){
					 this.tooltipsArry.add("<html>194LBC - Income in respect of investment <br>in securitization trust</html>");
				 }
				 else if("L".equals(sections[i].toString())){
					 this.tooltipsArry.add("<html>206C - L - TCS on sale of Motor vehicle</html>");
				 }
				 else if("M".equals(sections[i].toString())){
					 this.tooltipsArry.add("<html>206C - M - TCS on sale in cash of any goods<br> (other than bullion/jewellery)</html>");
				 }
				 else if("N".equals(sections[i].toString())){
					 this.tooltipsArry.add("<html>206C - N - TCS on providing of any services<br> (other than Chapter-XVII-B)</html>");
				 }
				 else if ("O".equals(sections[i].toString())) {			//RPU 3.5 start Addition of new section codes 
					 this.tooltipsArry.add("<html>206C-O - Collection at source for purchase <br>of overseas tour program package</html>"); //Changed description by Payal for RPU 4.7
					} else if ("P".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C-P - Collection at source on remittance under LRS from <br>educational loan taken from financial institution<br> mentioned in section 80E</html>"); //Changed description by Payal for RPU 4.7
					} else if ("Q".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C-Q - Collection at source on remittance under LRS except for <br>the purposes of education or medical treatment</html>"); //Changed description by Payal for RPU 4.7
					} else if ("R".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C-R - Collection at source on sale of goods</html>");
					}
			 
			        //else if added by Payal for RPU 4.7 start
					else if ("T".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C-T - Collection at source on remittance under LRS is for <br>the purposes of education or medical treatment<br> and not covered under Code P</html>");
					}
			 
			//CR 88815 rahul 27EQ addition of section code change start
					else if ("MA".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MA - Collection at source on sale of wrist watch</html>"); 
					}
					else if ("MB".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MB - Collection at source on sale of art piece such as antiques, painting, sculpture</html>"); 
					}
					else if ("MC".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MC - Collection at source on sale of collectibles such as coin, stamp</html>"); 
					}
					else if ("MD".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MD - Collection at source on sale of yacht, rowing boat, canoe, helicopter</html>"); 
					}
					else if ("ME".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- ME - Collection at source on sale of pair of sunglasses</html>"); 
					}
					else if ("MF".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MF - Collection at source on sale of bag such as handbag, purse</html>"); 
					}
					else if ("MG".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MG - Collection at source on sale of pair of shoes</html>"); 
					}
					else if ("MH".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MH - Collection at source on sale of sportswear and equipment such as golf kit, ski-wear</html>"); 
					}
					else if ("MI".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MI - Collection at source on sale of home theatre system</html>"); 
					}
					else if ("MJ".equals(sections[i].toString())) {
						this.tooltipsArry.add("<html>206C- MJ - Collection at source on sale of horse for horse racing in race clubs and horse for polo</html>"); 
					}
					//CR 88815 rahul 27EQ addition of section code change end
				
			//************************************
			 }

		 }
		 
	 }
	 
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus) {
    	
      if (isSelected) {
    	  
    	  //Added for tooltips on mouse movement
    	  super.getListCellRendererComponent(list, value, index,
					isSelected, cellHasFocus);
			if (comboList == null) {
				comboList = list;
				combo.addKeyListener(new KeyAdapter() {
					public void keyReleased(KeyEvent e) {
						if (e.getKeyCode() == KeyEvent.VK_DOWN
								|| e.getKeyCode() == KeyEvent.VK_UP) {
							int x = 5;
							int y = comboList.indexToLocation(comboList
									.getSelectedIndex()).y;
							ToolTipManager.sharedInstance().mouseEntered(
									new MouseEvent(comboList,
											MouseEvent.MOUSE_ENTERED, 0, 0,
											x, y, 0, false));
							ToolTipManager.sharedInstance().mouseMoved(
									new MouseEvent(comboList,
											MouseEvent.MOUSE_MOVED, 0, 0,
											x, y, 0, false));
						}
					}
				});
			}
    	  
    	  
    	 //End of tooltips on mouse movement
        setBackground(list.getSelectionBackground());
        setForeground(list.getSelectionForeground());
        if (-1 < index) {
        	if(this.tooltipsArry !=null){
        		list.setToolTipText(this.tooltipsArry.get(index));
        	}
        }
      } else {
        setBackground(list.getBackground());
        setForeground(list.getForeground());
      }
      setFont(list.getFont());
      setText((value == null) ? "" : value.toString());
      return this;
    }
  }
