/*
 * Created by Akansha Rajesh
 * Purpose: This class is being used for adding tooltips to the combo boxes used for remarks of
 * AnnexureI
 * Created Date: 06/08/2015
 * New development for ver1.3 of Java RPU exe
 */
package com.tin.etbaf.rpu;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class MyComboBoxRendererRemarks extends BasicComboBoxRenderer {

	public String[] remarksArry;
	public List<String> tooltipsArry = new ArrayList<String>();
	public String formNumber;
	JComboBox combo;
	JList comboList;
	String section;

	MyComboBoxRendererRemarks() {
		super();
	}

	public MyComboBoxRendererRemarks(String[] remarkscd, String formNumber,JComboBox combo, String section) {
		this.remarksArry = remarkscd;
		this.formNumber = formNumber;
		this.combo = combo;
		this.section = section;
		toolTips();
	}

	// Added for forming the required tooltip array depending on the section
	// codes
	public void toolTips() {
		String[] remarks = this.remarksArry;
		tooltipsArry.add("--Select--");
		String form = this.formNumber;
		for (int i = 0; i < remarks.length; i++) {
			//Form wise distribution of the remark's tooltips
			if("24Q".equals(form)){
				if("A".equals(remarks[i])){
					tooltipsArry.add("A - Lower deduction on account of certificate under section 197");
				}else if("B".equals(remarks[i])){
					tooltipsArry.add("B - No deduction on account of certificate under section 197");
				}else if("C".equals(remarks[i])){
					tooltipsArry.add("<html>C - Deduction of tax at higher rate due to non-availability <br>of PAN (Applicable from FY 2010-11 onwards)</html>");
				}
			}else if("26Q".equals(form)){
				//System.out.println("My remarks are: "+ remarks[i]);
				if("A".equals(remarks[i])){
					tooltipsArry.add("A - Lower deduction / No deduction on account of certificate under section 197");
				}
				/*************************************************************/
				//Added by Sadhana, FRD2.1
				//Change in section code 194J Fees for Professional or Technical Services for Form 26Q
				/*else if("B".equals(remarks[i])){
					tooltipsArry.add("B - No deduction on account of declaration under section 197A");
				}*/
				else if("B".equals(remarks[i])){
					if(section.equals("94J")){
						tooltipsArry.add("B - Lower/No deduction on account of  business of operation of call center");
					}else{
						tooltipsArry.add("B - No deduction on account of declaration under section 197A");
					}
					
				}
				/*************************************************************/
				else if("B - In case of 15G/15H".equals(remarks[i].toString())){
				//	System.out.println("Inside B - Incase");
					tooltipsArry.add("B - No deduction on account of declaration under section 197A");
				}else if("C".equals(remarks[i])){
					tooltipsArry.add("<html>C - Deduction of tax at higher rate due to non-availability<br> of PAN (Applicable from FY 2010-11 onwards)</html>");
				}else if("T".equals(remarks[i])){
					tooltipsArry.add("T - Transporter transaction and if valid PAN is provided");
				}else if("Y".equals(remarks[i])){
					tooltipsArry.add("<html>Y - Transaction where tax not been deducted as amount paid/credited<br> to the vendor/party has not exceeded the threshold limit</html>");
				}else if("S".equals(remarks[i])){//RPU 3.7 Multiple Description
					 if(section.equals("94Q"))
						tooltipsArry.add("S- if no deduction is in view of the provisions of sub-section (5) of section 194Q");
					 else
						 tooltipsArry.add("S - Software acquired under section 194J (Applicable from FY 2012-13 onwards)");
				}else if("Z".equals(remarks[i])){
					tooltipsArry.add("<html>Z - No deduction on account of payment under section <br>197A (1F) (Applicable from FY 2013-14 onwards)</html>");
				}/*********************************************************/
					//FRD 2.3 change for adding new remark for 94A by, Sadhana
				else if("R".equals(remarks[i])){
					tooltipsArry.add("<html>R - In case of deduction on interest income from Senior Citizens</html>");
				}/*********************************************************/
				//RPU 3.1 start
				else if("N".equals(remarks[i])){
					tooltipsArry.add("<html>N - No deduction on account of payment made to a person<br> referred to in clause (iii) or clause (iv) of the provision to<br> section 194N or on account of notification issued under <br>clause (v) of the provision to section 194N</html>");
				}
				//RPU 3.4 start Addition of new remark 
				else if ("O".equals(remarks[i])) {
					tooltipsArry.add("<html>O - No deduction is as per the provisions <br>of sub-section (2A) of section 194LBA</html>");
				}
				else if ("M".equals(remarks[i])) {
					tooltipsArry.add("<html>M - No deduction or lower deduction is on account of notification issued under second provision to section 194N</html>");
				}
				else if ("E".equals(remarks[i])) {
					tooltipsArry.add("<html>E - No deduction is on account of payment being made <br>to a person referred to in Board Circular no. 3<br> of 2002 dated 28th June, 2002 or Board Circular no. 11 <br>of 2002 dated 22nd November, 2002 or Board Circular no. 18 <br>of 2017 dated 28th May, 2017</html>");
				}
				else if ("D".equals(remarks[i])) {
					tooltipsArry.add("<html>D - No deduction or lower deduction is on account of payment<br> made to a person or class of person on account of notification<br> issued under sub-section (5) of section of 194A</html>");
				}
				 //CR 80278 new remark P,Q
				else if ("P".equals(remarks[i])) {
					tooltipsArry.add("<html>P - no deduction is on account of payment of dividend <br>made to a business trust referred to in clause (d)<br> of second proviso to section 194 or in view of any notification issued under clause (e) of the second proviso to section 194</html>");
					}
				else if ("Q".equals(remarks[i])) {
					tooltipsArry.add("<html>Q - no deduction in view of payment made to an entity <br>referred to in clause (x) of sub-section (3)<br> of section 194A</html>");
					}//RPU 3.7 CR 81169
				else if ("U".equals(remarks[i])) {
					tooltipsArry.add("<html>U- if the deduction is on higher rate in view of <br>section 206AB for non-filing of return of income</html>");
					}
			}else if("27Q".equals(form)){
				if("A".equals(remarks[i])){
					tooltipsArry.add("A - Lower deduction or no deduction on account of certificate under section 197");
				}else if("B".equals(remarks[i])){
					tooltipsArry.add("B - No deduction on account of declaration under section 197A");
				}else if("C".equals(remarks[i])){
					tooltipsArry.add("<html>C - Deduction of tax at higher rate due to non-availability<br> of PAN (Applicable from FY 2010-11 onwards)</html>");
				}else if("S".equals(remarks[i])){
					tooltipsArry.add("S - Software acquired under section 195 (Applicable from FY 2012-13 onwards)");
					}//RPU 3.1 start
				else if("N".equals(remarks[i])){
					tooltipsArry.add("<html>N - No deduction on account of payment made to a person<br> referred to in clause (iii) or clause (iv) of the provision to<br> section 194N or on account of notification issued under <br>clause (v) of the provision to section 194N</html>");
				}//RPU 3.4 start Addition of new remark
				else if ("O".equals(remarks[i])) {
					tooltipsArry.add("<html>O - No deduction is as per the provisions <br>of sub-section (2A) of section 194LBA</html>");
				}
				else if("G".equals(remarks[i])){//RPU 3.4 start Addition of new remark 
					tooltipsArry.add("<html>G - No deduction is in view of clause (a) or<br> clause (b) of sub-section (1D) of section 197A</html>");
				}
				else if ("M".equals(remarks[i])) {
					tooltipsArry.add("<html>M - No deduction or lower deduction is on account of notification issued under second provision to section 194N</html>");
				}
				else if("D".equals(remarks[i])){//RPU 3.4 start Addition of new remark 
					tooltipsArry.add("<html>D - No deduction or lower deduction is on account of payment<br> made to a person or class of person on account of notification issued <br>under sub-section (5) of section of 194A</html>");
				}
				else if ("H".equals(remarks[i])) {//CR 80278 new remark H
					tooltipsArry.add("<html>H - In case of  no deduction is in view of proviso to <br>sub-section (1A) of section 196D in respect of<br> an income paid to a specified fund which is exempt under clause (4D) of section 10.</html>");
				}
				else if("I".equals(remarks[i])){//RPU 3.4 start Addition of new remark 
					tooltipsArry.add("<html>I - if no deduction is in view of sub-section (2) of section 196D<br> in respect of income of the nature of capital gains on transfer of securities<br> referred to in section 115AD paid or payable to a Foreign Institutional Investor</html>");
				} //CR 80278 new remark I
				//rahul CR84532 27Q remark tooltip bug fix start for "Y" and "U"
				else if("Y".equals(remarks[i])){
					tooltipsArry.add("<html>Y - Transaction where tax not been deducted as amount paid/credited<br> to the vendor/party has not exceeded the threshold limit</html>");
				}
				else if ("U".equals(remarks[i])) {
					tooltipsArry.add("<html>U- if the deduction is on higher rate in view of <br>section 206AB for non-filing of return of income</html>");
					}
				//rahul CR84532 27Q remark tooltip bug fix end for "Y" and "U"
				else if("J".equals(remarks[i])){
					tooltipsArry.add("<html>J-  if deduction is at higher rate in view of section 206AB<br> for non-filing of return of income by the non-resident having a permanent establishment in India</html>");
				}
				//rahul CR86827 remark P for section cd 195 start
				else if ("P".equals(remarks[i])) {
					tooltipsArry.add("<html>P - If lower deduction or no deduction is in view of notification issued under sub-section (1F) of section 197A.</html>");
					}
				//rahul CR86827 remark P for section cd 195 end
							
			}else if("27EQ".equals(form)){
				if("A".equals(remarks[i])){
					tooltipsArry.add("A - In case of lower collection as per section 206C (9)");
				}else if("B".equals(remarks[i])){
					tooltipsArry.add("B - Non collection as per section 206C (1A)");
				}else if("C".equals(remarks[i])){
					//tooltipsArry.add("<html>C - Deduction of tax at higher rate due to non-availability<br> of PAN (Applicable from FY 2017-18 onwards)</html>"); //Added by Sadhana For RFD2.0
					tooltipsArry.add("<html>C - if collection is at higher rate under section 206CC on account<br> of non-furnishing of PAN by the collectee</html>");   //Added by Payal for CR85567 RPU 4.9
				}	 //RPU 3.5 start Addition of new remark 
				else if ("D".equals(remarks[i])) {
					tooltipsArry.add("<html>D - if no collection is on account of the first provison to sub-section (1G) of section 206C</html>"); 
				}
				else if ("E".equals(remarks[i])) {
					tooltipsArry.add("<html>E - if no collection is on account of the fourth provison to sub-section (1G) of section 206C</html>"); 
				}
				else if ("F".equals(remarks[i])) {
					tooltipsArry.add("<html>F - if no collection is on account clause (i) or clause (ii) of the fifth provison to sub-section (1G) or in view of notification issued under the clause (ii).</html>"); 
				}
				else if ("G".equals(remarks[i])) {
					tooltipsArry.add("<html>G - if no collection is on account of the second provison to sub-section (IH) of section 206C.</html>"); 
				}
				else if ("H".equals(remarks[i])) {
					tooltipsArry.add("<html>H - if no collection is on account of sub-clause (A) or sub-clause (B) or sub-clause (C), or in view of notification issued under sub-clause (c), of clause (a) of the Explanation.</html>"); 
				}
				else if ("I".equals(remarks[i])) {
					tooltipsArry.add("<html>I- if collection is at a higher rate in view of section 206CCA</html>"); 
				}
				// rahul CR 88008 27EQ start
				else if ("J".equals(remarks[i])) {
					tooltipsArry.add("<html>J- if no collection or lower collection is in view of notification issued under sub-section (12) of section 206C</html>"); 
				}
				// rahul CR 88008 27EQ end
			}
			
		}

	}

	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {

		if (isSelected) {
			//Added for tooltips on mouse movement
	    	  super.getListCellRendererComponent(list, value, index,
						isSelected, cellHasFocus);
				if (comboList == null) {
					comboList = list;
					combo.addKeyListener(new KeyAdapter() {
						public void keyReleased(KeyEvent e) {
							if (e.getKeyCode() == KeyEvent.VK_DOWN
									|| e.getKeyCode() == KeyEvent.VK_UP) {
								int x = 5;
								int y = comboList.indexToLocation(comboList
										.getSelectedIndex()).y;
								ToolTipManager.sharedInstance().mouseEntered(
										new MouseEvent(comboList,
												MouseEvent.MOUSE_ENTERED, 0, 0,
												x, y, 0, false));
								ToolTipManager.sharedInstance().mouseMoved(
										new MouseEvent(comboList,
												MouseEvent.MOUSE_MOVED, 0, 0,
												x, y, 0, false));
							}
						}
					});
				}
	    	  
	    	  
	    	 //End of tooltips on mouse movement

			setBackground(list.getSelectionBackground());
			setForeground(list.getSelectionForeground());
			if (-1 < index) {
				if (this.tooltipsArry != null) {
					list.setToolTipText(this.tooltipsArry.get(index));
				}
			}
		} else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}
		setFont(list.getFont());
	//	System.out.println("Value of Combobox: "+ value.toString());
		setText((value == null) ? "" : value.toString());
		return this;
	}

}
