/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.exporter.impl;

import in.gov.tds.beans.FormRequest;
import in.gov.tds.beans.FormResponse;
import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.parser.Form16Parser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.JRLoader;

public class Form16Exporter {
    public static FormResponse exportForm(FormRequest formRequest, FormResponse formResponse, boolean withDigitalSignature) throws PDFCreationException {
        String generatedFileName = "";
        String footer = null;
        String body = null;
        String outputFileLocation = null;
        String assessmentYear = null;
        String deducteePAN = null;
        StringBuffer sb = null;
        StringBuffer finalOutputfile = null;
        JRPdfExporter pdfExporter = null;
        File currentDir = null;
        FileOutputStream outputStream = null;
        JasperPrint jasperPrint = null;
        String currentPath = null;
        String compiledPath = null;
        InputStream is = null;
        JRBeanArrayDataSource dataSource = null;
        URL compiledPathURL = null;
        Object[] form16Bean = null;
        try {
            footer = formRequest.getFooter();
            body = formRequest.getBody();
            outputFileLocation = formRequest.getOutputFolderPath();
            form16Bean = Form16Parser.parse(body, footer, withDigitalSignature);
            assessmentYear = form16Bean[0].getAssessmentYear();
            deducteePAN = form16Bean[0].getDeducteePAN();
            sb = new StringBuffer();
            sb.append(deducteePAN).append("_").append(assessmentYear).append(".pdf");
            generatedFileName = sb.toString();
            if (deducteePAN == null || deducteePAN.equalsIgnoreCase("") || deducteePAN.length() == 0) {
                formResponse.setOutputFileName("");
            } else {
                dataSource = new JRBeanArrayDataSource(form16Bean);
                jasperPrint = null;
                int assessYr = 0;
                String[] year = assessmentYear.split("-");
                String one = year[0];
                assessYr = Integer.valueOf(one);
                compiledPathURL = assessYr != 0 && assessYr <= 2021 ? ClassLoader.class.getResource("/resources/Form-16.jasper") : ClassLoader.class.getResource("/resources/Form-16_FY2021.jasper");
                if (compiledPathURL.getPath().lastIndexOf("!") > 0) {
                    JarURLConnection jarurl = (JarURLConnection)compiledPathURL.openConnection();
                    is = jarurl.getInputStream();
                    File file = new File("");
                    file = assessYr != 0 && assessYr <= 2021 ? new File(String.valueOf(outputFileLocation) + "/resources/Form-16.jrprint") : new File(String.valueOf(outputFileLocation) + "/resources/Form-16_FY2021.jrprint");
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    outputStream = new FileOutputStream(file);
                    JasperFillManager.fillReportToStream(is, (OutputStream)outputStream, new HashMap<String, Object>(), (JRDataSource)dataSource);
                    if (outputStream != null) {
                        ((OutputStream)outputStream).close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                } else {
                    currentDir = new File("");
                    currentPath = currentDir.getAbsolutePath();
                    File file = new File("");
                    if (assessYr != 0 && assessYr <= 2021) {
                        compiledPath = String.valueOf(currentPath) + "/resources/Form-16.jasper";
                        file = new File(String.valueOf(outputFileLocation) + "/resources/Form-16.jrprint");
                    } else {
                        compiledPath = String.valueOf(currentPath) + "/resources/Form-16_FY2021.jasper";
                        file = new File(String.valueOf(outputFileLocation) + "/resources/Form-16_FY2021.jrprint");
                    }
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    JasperFillManager.fillReportToFile(compiledPath, file.getPath(), new HashMap<String, Object>(), (JRDataSource)dataSource);
                    jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                }
                finalOutputfile = new StringBuffer();
                finalOutputfile.append(outputFileLocation);
                finalOutputfile.append("\\");
                finalOutputfile.append(deducteePAN);
                finalOutputfile.append("_");
                finalOutputfile.append(assessmentYear);
                finalOutputfile.append(".pdf");
                pdfExporter = new JRPdfExporter();
                pdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                pdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, finalOutputfile.toString());
                pdfExporter.exportReport();
                formResponse.setOutputFileName(generatedFileName);
            }
            FormResponse formResponse2 = formResponse;
            return formResponse2;
        }
        catch (JRException e2) {
            throw new PDFCreationException("JRPrint Creation - Error in creating setting data of PDF");
        }
        catch (IOException ex) {
            throw new PDFCreationException("Error while creating/deleting files");
        }
        catch (Exception ex) {
            throw new PDFCreationException("Error occured due to" + ex.getLocalizedMessage());
        }
        finally {
            footer = null;
            generatedFileName = null;
            sb = null;
            body = null;
            if (form16Bean != null && form16Bean.length > 0) {
                form16Bean[0].initializeProperties();
            }
            form16Bean = null;
            outputFileLocation = null;
            assessmentYear = null;
            deducteePAN = null;
            pdfExporter = null;
            finalOutputfile = null;
            currentDir = null;
            jasperPrint = null;
            currentPath = null;
            outputStream = null;
            compiledPath = null;
            dataSource = null;
            is = null;
            compiledPathURL = null;
        }
    }
}

