/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.pdfgenerator;

import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.pdfcreator.impl.Form16SPdfGenerator;
import in.gov.tds.pdfgenerator.PDFSigner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import sun.security.x509.X500Name;
import util.DialogBox;
import util.KeyStoreEntry;
import util.KeyStoreUtils;

public class CreatePDFTask
extends SwingWorker<List<String>, Integer> {
    private String destinationFilePath = "";
    private boolean withDigitalSignature = false;
    private File outputTargetDirectory = null;
    private PrivateKey privateKey;
    private Certificate[] certificateChain;
    private PDFSigner frame;

    CreatePDFTask(String destinationFilePath, boolean withDigitalSignature, File outputTargetDirectory, PrivateKey privateKey, Certificate[] certificateChain, PDFSigner frame) {
        this.destinationFilePath = destinationFilePath;
        this.withDigitalSignature = withDigitalSignature;
        this.outputTargetDirectory = outputTargetDirectory;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.frame = frame;
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        Form16SPdfGenerator pdfcreator = new Form16SPdfGenerator();
        ArrayList<String> filesCreated = new ArrayList<String>();
        String previousPAN = null;
        String currentPAN = null;
        String contentRow = null;
        BufferedReader br = null;
        String FHRow = null;
        String FTRow = null;
        String[] FHRowSplitArray = null;
        String formType = null;
        String headerFooter = null;
        String body = null;
        String outputTargetPath = null;
        String[] contentSplit = null;
        String outputFileName = null;
        try {
            br = new BufferedReader(new FileReader(this.destinationFilePath));
            FHRow = br.readLine().trim();
            FTRow = br.readLine().trim();
            FHRowSplitArray = FHRow.split("\\^");
            formType = FHRowSplitArray[2];
            headerFooter = String.valueOf(FHRow) + "\n" + FTRow;
            body = "";
            outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
            if (this.withDigitalSignature) {
                this.getCertificateForSignature();
                outputTargetPath = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
                File f1 = new File(outputTargetPath);
                if (!f1.exists()) {
                    f1.mkdirs();
                }
            }
            while ((contentRow = br.readLine()) != null) {
                contentSplit = contentRow.split("\\^");
                if (contentSplit.length <= 1) continue;
                currentPAN = contentSplit[1];
                if (previousPAN == null) {
                    previousPAN = contentSplit[1];
                }
                if (previousPAN != null && previousPAN.equals(currentPAN)) {
                    if (body.equals("")) {
                        body = contentRow;
                        continue;
                    }
                    body = String.valueOf(body) + "\\\\" + contentRow;
                    continue;
                }
                if (previousPAN.equals(currentPAN)) continue;
                if (formType.equalsIgnoreCase("16")) {
                    outputFileName = pdfcreator.createForm16PDF(body, headerFooter, outputTargetPath, this.withDigitalSignature);
                    this.signPDF(outputFileName);
                    if (outputFileName != null && !outputFileName.equalsIgnoreCase("") && outputFileName.length() != 0) {
                        filesCreated.add(outputFileName);
                    }
                } else if (formType.equalsIgnoreCase("16A")) {
                    outputFileName = pdfcreator.createForm16APDF(body, headerFooter, outputTargetPath, this.withDigitalSignature);
                    this.signPDF(outputFileName);
                    if (outputFileName != null && !outputFileName.equalsIgnoreCase("") && outputFileName.length() != 0) {
                        filesCreated.add(outputFileName);
                    }
                }
                body = contentRow;
                previousPAN = currentPAN;
            }
            br.close();
            if (formType.equalsIgnoreCase("16")) {
                outputFileName = pdfcreator.createForm16PDF(body, headerFooter, outputTargetPath, this.withDigitalSignature);
                this.signPDF(outputFileName);
                if (outputFileName != null && !outputFileName.equalsIgnoreCase("") && outputFileName.length() != 0) {
                    filesCreated.add(outputFileName);
                }
            } else if (formType.equalsIgnoreCase("16A")) {
                outputFileName = pdfcreator.createForm16APDF(body, headerFooter, outputTargetPath, this.withDigitalSignature);
                this.signPDF(outputFileName);
                if (outputFileName != null && !outputFileName.equalsIgnoreCase("") && outputFileName.length() != 0) {
                    filesCreated.add(outputFileName);
                }
            } else {
                return null;
            }
            ArrayList<String> arrayList = filesCreated;
            return arrayList;
        }
        catch (FileNotFoundException e2) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (IOException e2) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (PDFCreationException ex) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (Exception e3) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        finally {
            pdfcreator = new Form16SPdfGenerator();
            filesCreated = new ArrayList();
            previousPAN = null;
            currentPAN = null;
            contentRow = null;
            br = null;
            FHRow = null;
            FTRow = null;
            FHRowSplitArray = null;
            formType = null;
            headerFooter = null;
            body = null;
            outputTargetPath = null;
            contentSplit = null;
            outputFileName = null;
        }
    }

    public File GetTempDirectory() {
        File tempDir = null;
        if (this.outputTargetDirectory != null && this.outputTargetDirectory.exists()) {
            String outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
            outputTargetPath = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
            tempDir = new File(outputTargetPath);
        }
        return tempDir;
    }

    public static boolean removeFiles(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        String[] list = directory.list();
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                File entry = new File(directory, list[i2]);
                if (entry.isDirectory()) {
                    if (!CreatePDFTask.removeFiles(entry)) {
                        return false;
                    }
                    if (!entry.delete()) {
                        return false;
                    }
                } else if (!entry.delete()) {
                    return false;
                }
                ++i2;
            }
        }
        list = null;
        return true;
    }

    private void getCertificateForSignature() {
        String selectedCertificate = "";
        KeyStoreEntry kse = null;
        String alias = null;
        KeyStore ks = null;
        String certSelected = null;
        if (this.frame.getSoftTokenstoreTable() != null && this.frame.getSoftTokenstoreTable().getRowCount() == 1) {
            kse = this.frame.getSoftTokenstoreTable().getSelectedEntry();
            selectedCertificate = "From Soft Token";
        } else {
            selectedCertificate = "Windows Store";
        }
        if (this.privateKey == null && this.certificateChain == null) {
            if (!selectedCertificate.equals("Windows Store")) {
                boolean firstAsk = true;
                char[] pass = DialogBox.askPassword(this.frame, "Enter the token Password.", firstAsk);
                File certFile = new File(selectedCertificate);
                if (pass == null) {
                    return;
                }
                firstAsk = false;
                try {
                    try {
                        ks = KeyStoreUtils.getPKCS12Store(certFile, pass);
                        while (ks == null) {
                            pass = DialogBox.askPassword(this.frame, "Enter the correct token password.", true);
                            ks = KeyStoreUtils.getPKCS12Store(certFile, pass);
                            if (ks != null) continue;
                        }
                        alias = ks.aliases().nextElement();
                        this.privateKey = (PrivateKey)ks.getKey(alias, pass);
                        this.certificateChain = ks.getCertificateChain(alias);
                    }
                    catch (UnrecoverableKeyException e2) {
                        certFile = null;
                        pass = null;
                        return;
                    }
                    catch (KeyStoreException keyStoreException) {
                        certFile = null;
                        pass = null;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        certFile = null;
                        pass = null;
                    }
                }
                finally {
                    certFile = null;
                    pass = null;
                }
            } else if (selectedCertificate != null && selectedCertificate.equals("Windows Store")) {
                try {
                    ks = KeyStore.getInstance("WINDOWS-MY", "SunMSCAPI");
                    ks.load(null, null);
                }
                catch (KeyStoreException keyStoreException) {
                }
                catch (NoSuchProviderException noSuchProviderException) {
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (CertificateException certificateException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.frame.getStoreTable() != null && this.frame.getStoreTable().getRowCount() != 0) {
                    if (this.frame.getStoreTable().getSelectedEntry() == null) {
                        return;
                    }
                    kse = this.frame.getStoreTable().getSelectedEntry();
                    alias = kse.getAlias().trim();
                    try {
                        this.privateKey = (PrivateKey)ks.getKey(alias, null);
                        this.certificateChain = ks.getCertificateChain(alias);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                    }
                    catch (KeyStoreException keyStoreException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (ks == null) {
                    ks = kse.getLoadedKeyStore();
                }
                try {
                    certSelected = kse.getAlias();
                    this.frame.setCertificateName(kse.getSubjectCN().trim(), kse.getAlias().trim());
                    this.frame.setValidity(((X509Certificate)ks.getCertificate(certSelected)).getNotAfter().toString());
                    this.frame.setIssuerName(new X500Name(((X509Certificate)ks.getCertificate(certSelected)).getIssuerDN().getName()).getCommonName());
                }
                catch (IOException iOException) {
                }
                catch (KeyStoreException keyStoreException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void signPDF(String fileCreated) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK], 17[CATCHBLOCK], 16[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

