/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.engine;

public class ZipCryptoEngine {
    private final int[] keys = new int[3];
    private static final int[] CRC_TABLE = new int[256];

    static {
        int i2 = 0;
        while (i2 < 256) {
            int r2 = i2;
            int j2 = 0;
            while (j2 < 8) {
                r2 = (r2 & 1) == 1 ? r2 >>> 1 ^ 0xEDB88320 : (r2 >>>= 1);
                ++j2;
            }
            ZipCryptoEngine.CRC_TABLE[i2] = r2;
            ++i2;
        }
    }

    public void initKeys(char[] password) {
        this.keys[0] = 305419896;
        this.keys[1] = 591751049;
        this.keys[2] = 878082192;
        int i2 = 0;
        while (i2 < password.length) {
            this.updateKeys((byte)(password[i2] & 0xFF));
            ++i2;
        }
    }

    public void updateKeys(byte charAt) {
        this.keys[0] = this.crc32(this.keys[0], charAt);
        this.keys[1] = this.keys[1] + (this.keys[0] & 0xFF);
        this.keys[1] = this.keys[1] * 134775813 + 1;
        this.keys[2] = this.crc32(this.keys[2], (byte)(this.keys[1] >> 24));
    }

    private int crc32(int oldCrc, byte charAt) {
        return oldCrc >>> 8 ^ CRC_TABLE[(oldCrc ^ charAt) & 0xFF];
    }

    public byte decryptByte() {
        int temp = this.keys[2] | 2;
        return (byte)(temp * (temp ^ 1) >>> 8);
    }
}

