/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.scriptlets;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.util.JRClassLoader;

public final class DefaultScriptletFactory
implements ScriptletFactory {
    private static final DefaultScriptletFactory INSTANCE = new DefaultScriptletFactory();

    private DefaultScriptletFactory() {
    }

    public static DefaultScriptletFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<JRAbstractScriptlet> getScriplets(ScriptletFactoryContext context) throws JRException {
        JRScriptlet[] scriptletsArray;
        String scriptletClassName;
        ArrayList<JRAbstractScriptlet> scriptlets = new ArrayList<JRAbstractScriptlet>();
        JRAbstractScriptlet scriptlet = (JRAbstractScriptlet)context.getParameterValues().get("REPORT_SCRIPTLET");
        if (scriptlet == null && (scriptletClassName = context.getDataset().getScriptletClass()) != null) {
            scriptlet = this.getScriptlet(scriptletClassName);
            context.getParameterValues().put("REPORT_SCRIPTLET", scriptlet);
        }
        if (scriptlet != null) {
            scriptlets.add(scriptlet);
        }
        if ((scriptletsArray = context.getDataset().getScriptlets()) != null) {
            for (int i2 = 0; i2 < scriptletsArray.length; ++i2) {
                String paramName = scriptletsArray[i2].getName() + "_SCRIPTLET";
                scriptlet = (JRAbstractScriptlet)context.getParameterValues().get(paramName);
                if (scriptlet == null) {
                    scriptlet = this.getScriptlet(scriptletsArray[i2].getValueClassName());
                    context.getParameterValues().put(paramName, scriptlet);
                }
                scriptlets.add(scriptlet);
            }
        }
        return scriptlets;
    }

    protected JRAbstractScriptlet getScriptlet(String scriptletClassName) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class<?> scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
            scriptlet = (JRAbstractScriptlet)scriptletClass.newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new JRException("Error loading scriptlet class : " + scriptletClassName, e2);
        }
        catch (Exception e3) {
            throw new JRException("Error creating scriptlet class instance : " + scriptletClassName, e3);
        }
        return scriptlet;
    }
}

