/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.factories;

import com.itextpdf.text.error_messages.MessageLocalization;

public class RomanAlphabetFactory {
    public static final String getString(int index) {
        if (index < 1) {
            throw new NumberFormatException(MessageLocalization.getComposedMessage("you.can.t.translate.a.negative.number.into.an.alphabetical.value"));
        }
        --index;
        int bytes = 1;
        int start = 0;
        int symbols = 26;
        while (index >= symbols + start) {
            ++bytes;
            start += symbols;
            symbols *= 26;
        }
        int c2 = index - start;
        char[] value = new char[bytes];
        while (bytes > 0) {
            value[--bytes] = (char)(97 + c2 % 26);
            c2 /= 26;
        }
        return new String(value);
    }

    public static final String getLowerCaseString(int index) {
        return RomanAlphabetFactory.getString(index);
    }

    public static final String getUpperCaseString(int index) {
        return RomanAlphabetFactory.getString(index).toUpperCase();
    }

    public static final String getString(int index, boolean lowercase) {
        if (lowercase) {
            return RomanAlphabetFactory.getLowerCaseString(index);
        }
        return RomanAlphabetFactory.getUpperCaseString(index);
    }

    public static void main(String[] args) {
        int i2 = 1;
        while (i2 < 32000) {
            System.out.println(RomanAlphabetFactory.getString(i2));
            ++i2;
        }
    }
}

