/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.html.Markup;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.pdf.HyphenationAuto;
import com.itextpdf.text.pdf.HyphenationEvent;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontProvider fontImp = FontFactory.getFontImp();
    public static HashMap<String, String> followTags = new HashMap();

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        followTags.put("s", "s");
        followTags.put("strike", "s");
    }

    public Chunk createChunk(String text, ChainedProperties props) {
        Font font = this.getFont(props);
        float size = font.getSize();
        size /= 2.0f;
        Chunk ck = new Chunk(text, font);
        if (props.hasProperty("sub")) {
            ck.setTextRise(-size);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(size);
        }
        ck.setHyphenation(FactoryProperties.getHyphenation(props));
        return ck;
    }

    private static void setParagraphLeading(Paragraph p2, String leading) {
        if (leading == null) {
            p2.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v2 = tk.nextToken();
            float v1 = Float.parseFloat(v2);
            if (!tk.hasMoreTokens()) {
                p2.setLeading(v1, 0.0f);
                return;
            }
            v2 = tk.nextToken();
            float v22 = Float.parseFloat(v2);
            p2.setLeading(v1, v22);
        }
        catch (Exception e2) {
            p2.setLeading(0.0f, 1.5f);
        }
    }

    public static void createParagraph(Paragraph p2, ChainedProperties props) {
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p2.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p2.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p2.setAlignment(3);
            }
        }
        p2.setHyphenation(FactoryProperties.getHyphenation(props));
        FactoryProperties.setParagraphLeading(p2, props.getProperty("leading"));
        value = props.getProperty("before");
        if (value != null) {
            try {
                p2.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("after")) != null) {
            try {
                p2.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("extraparaspace")) != null) {
            try {
                p2.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p2 = new Paragraph();
        FactoryProperties.createParagraph(p2, props);
        return p2;
    }

    public static ListItem createListItem(ChainedProperties props) {
        ListItem p2 = new ListItem();
        FactoryProperties.createParagraph(p2, props);
        return p2;
    }

    public Font getFont(ChainedProperties props) {
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (this.fontImp.isRegistered(face)) break;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        if (props.hasProperty("s")) {
            style |= 8;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        BaseColor color = Markup.decodeColor(props.getProperty("color"));
        String encoding = props.getProperty("encoding");
        if (encoding == null) {
            encoding = "Cp1252";
        }
        return this.fontImp.getFont(face, encoding, true, size, style, color);
    }

    public static HyphenationEvent getHyphenation(ChainedProperties props) {
        return FactoryProperties.getHyphenation(props.getProperty("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(HashMap<String, String> props) {
        return FactoryProperties.getHyphenation(props.get("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(String s2) {
        if (s2 == null || s2.length() == 0) {
            return null;
        }
        String lang = s2;
        String country = null;
        int leftMin = 2;
        int rightMin = 2;
        int pos = s2.indexOf(95);
        if (pos == -1) {
            return new HyphenationAuto(lang, country, leftMin, rightMin);
        }
        lang = s2.substring(0, pos);
        country = s2.substring(pos + 1);
        if ((pos = country.indexOf(44)) == -1) {
            return new HyphenationAuto(lang, country, leftMin, rightMin);
        }
        s2 = country.substring(pos + 1);
        country = country.substring(0, pos);
        pos = s2.indexOf(44);
        if (pos == -1) {
            leftMin = Integer.parseInt(s2);
        } else {
            leftMin = Integer.parseInt(s2.substring(0, pos));
            rightMin = Integer.parseInt(s2.substring(pos + 1));
        }
        return new HyphenationAuto(lang, country, leftMin, rightMin);
    }

    public static void insertStyle(HashMap<String, String> h2) {
        String style = h2.get("style");
        if (style == null) {
            return;
        }
        Properties prop = Markup.parseAttributes(style);
        for (Object o2 : prop.keySet()) {
            String ss;
            String key = (String)o2;
            if (key.equals("font-family")) {
                h2.put("face", prop.getProperty(key));
                continue;
            }
            if (key.equals("font-size")) {
                h2.put("size", String.valueOf(Float.toString(Markup.parseLength(prop.getProperty(key)))) + "pt");
                continue;
            }
            if (key.equals("font-style")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h2.put("i", null);
                continue;
            }
            if (key.equals("font-weight")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h2.put("b", null);
                continue;
            }
            if (key.equals("text-decoration")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h2.put("u", null);
                continue;
            }
            if (key.equals("color")) {
                BaseColor c2 = Markup.decodeColor(prop.getProperty(key));
                if (c2 == null) continue;
                int hh = c2.getRGB();
                String hs = Integer.toHexString(hh);
                hs = "000000" + hs;
                hs = "#" + hs.substring(hs.length() - 6);
                h2.put("color", hs);
                continue;
            }
            if (key.equals("line-height")) {
                ss = prop.getProperty(key).trim();
                float v2 = Markup.parseLength(prop.getProperty(key));
                if (ss.endsWith("%")) {
                    h2.put("leading", "0," + v2 / 100.0f);
                    continue;
                }
                if ("normal".equalsIgnoreCase(ss)) {
                    h2.put("leading", "0,1.5");
                    continue;
                }
                h2.put("leading", String.valueOf(v2) + ",0");
                continue;
            }
            if (!key.equals("text-align")) continue;
            ss = prop.getProperty(key).trim().toLowerCase();
            h2.put("align", ss);
        }
    }

    public static void insertStyle(HashMap<String, String> h2, ChainedProperties cprops) {
        String style = h2.get("style");
        if (style == null) {
            return;
        }
        Properties prop = Markup.parseAttributes(style);
        for (Object element : prop.keySet()) {
            String key = (String)element;
            if (key.equals("font-family")) {
                h2.put("face", prop.getProperty(key));
                continue;
            }
            if (key.equals("font-size")) {
                float actualFontSize = Markup.parseLength(cprops.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                h2.put("size", String.valueOf(Float.toString(Markup.parseLength(prop.getProperty(key), actualFontSize))) + "pt");
                continue;
            }
            if (key.equals("font-style")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h2.put("i", null);
                continue;
            }
            if (key.equals("font-weight")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h2.put("b", null);
                continue;
            }
            if (key.equals("text-decoration")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h2.put("u", null);
                continue;
            }
            if (key.equals("color")) {
                BaseColor c2 = Markup.decodeColor(prop.getProperty(key));
                if (c2 == null) continue;
                int hh = c2.getRGB();
                String hs = Integer.toHexString(hh);
                hs = "000000" + hs;
                hs = "#" + hs.substring(hs.length() - 6);
                h2.put("color", hs);
                continue;
            }
            if (key.equals("line-height")) {
                String ss = prop.getProperty(key).trim();
                float actualFontSize = Markup.parseLength(cprops.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                float v2 = Markup.parseLength(prop.getProperty(key), actualFontSize);
                if (ss.endsWith("%")) {
                    h2.put("leading", "0," + v2 / 100.0f);
                    return;
                }
                if ("normal".equalsIgnoreCase(ss)) {
                    h2.put("leading", "0,1.5");
                    return;
                }
                h2.put("leading", String.valueOf(v2) + ",0");
                continue;
            }
            if (key.equals("text-align")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                h2.put("align", ss);
                continue;
            }
            if (!key.equals("padding-left")) continue;
            String ss = prop.getProperty(key).trim().toLowerCase();
            h2.put("indent", Float.toString(Markup.parseLength(ss)));
        }
    }

    public FontProvider getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontProvider fontImp) {
        this.fontImp = fontImp;
    }
}

