/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList<Font> fonts = new ArrayList();

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont bf = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(f2);
    }

    public Phrase process(String text) {
        int fsize = this.fonts.size();
        if (fsize == 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("no.font.is.defined"));
        }
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Font font = null;
        int lastidx = -1;
        Phrase ret = new Phrase();
        int k2 = 0;
        while (k2 < len) {
            char c2 = cc[k2];
            if (c2 == '\n' || c2 == '\r') {
                sb.append(c2);
            } else if (Utilities.isSurrogatePair(cc, k2)) {
                int u2 = Utilities.convertToUtf32(cc, k2);
                int f2 = 0;
                while (f2 < fsize) {
                    font = this.fonts.get(f2);
                    if (font.getBaseFont().charExists(u2)) {
                        if (lastidx != f2) {
                            if (sb.length() > 0 && lastidx != -1) {
                                Chunk ck = new Chunk(sb.toString(), this.fonts.get(lastidx));
                                ret.add(ck);
                                sb.setLength(0);
                            }
                            lastidx = f2;
                        }
                        sb.append(c2);
                        sb.append(cc[++k2]);
                        break;
                    }
                    ++f2;
                }
            } else {
                int f3 = 0;
                while (f3 < fsize) {
                    font = this.fonts.get(f3);
                    if (font.getBaseFont().charExists(c2)) {
                        if (lastidx != f3) {
                            if (sb.length() > 0 && lastidx != -1) {
                                Chunk ck = new Chunk(sb.toString(), this.fonts.get(lastidx));
                                ret.add(ck);
                                sb.setLength(0);
                            }
                            lastidx = f3;
                        }
                        sb.append(c2);
                        break;
                    }
                    ++f3;
                }
            }
            ++k2;
        }
        if (sb.length() > 0) {
            Chunk ck = new Chunk(sb.toString(), this.fonts.get(lastidx == -1 ? 0 : lastidx));
            ret.add(ck);
        }
        return ret;
    }
}

