/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfReaderInstance;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ListIterator;

public class PdfLister {
    PrintStream out;

    public PdfLister(PrintStream out) {
        this.out = out;
    }

    public void listAnyObject(PdfObject object) {
        switch (object.type()) {
            case 5: {
                this.listArray((PdfArray)object);
                break;
            }
            case 6: {
                this.listDict((PdfDictionary)object);
                break;
            }
            case 3: {
                this.out.println("(" + object.toString() + ")");
                break;
            }
            default: {
                this.out.println(object.toString());
            }
        }
    }

    public void listDict(PdfDictionary dictionary) {
        this.out.println("<<");
        for (PdfName key : dictionary.getKeys()) {
            PdfObject value = dictionary.get(key);
            this.out.print(key.toString());
            this.out.print(' ');
            this.listAnyObject(value);
        }
        this.out.println(">>");
    }

    public void listArray(PdfArray array) {
        this.out.println('[');
        ListIterator<PdfObject> i2 = array.listIterator();
        while (i2.hasNext()) {
            PdfObject item = (PdfObject)i2.next();
            this.listAnyObject(item);
        }
        this.out.println(']');
    }

    public void listStream(PRStream stream, PdfReaderInstance reader) {
        try {
            this.listDict(stream);
            this.out.println("startstream");
            byte[] b2 = PdfReader.getStreamBytes(stream);
            int len = b2.length - 1;
            int k2 = 0;
            while (k2 < len) {
                if (b2[k2] == 13 && b2[k2 + 1] != 10) {
                    b2[k2] = 10;
                }
                ++k2;
            }
            this.out.println(new String(b2));
            this.out.println("endstream");
        }
        catch (IOException e2) {
            System.err.println("I/O exception: " + e2);
        }
    }

    public void listPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance readerInst = iPage.getPdfReaderInstance();
        PdfReader reader = readerInst.getReader();
        PdfDictionary page = reader.getPageN(pageNum);
        this.listDict(page);
        PdfObject obj = PdfReader.getPdfObject(page.get(PdfName.CONTENTS));
        if (obj == null) {
            return;
        }
        switch (obj.type) {
            case 7: {
                this.listStream((PRStream)obj, readerInst);
                break;
            }
            case 5: {
                ListIterator<PdfObject> i2 = ((PdfArray)obj).listIterator();
                while (i2.hasNext()) {
                    PdfObject o2 = PdfReader.getPdfObject((PdfObject)i2.next());
                    this.listStream((PRStream)o2, readerInst);
                    this.out.println("-----------");
                }
                break;
            }
        }
    }
}

