/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

public class PdfPages {
    private ArrayList pages = new ArrayList();
    private ArrayList parents = new ArrayList();
    private int leafSize = 10;
    private PdfWriter writer;
    private PdfIndirectReference topParent;

    PdfPages(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    void addPage(PdfDictionary pdfDictionary) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
            pdfDictionary.put(PdfName.PARENT, pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = this.writer.getCurrentPage();
            this.writer.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            this.pages.add(pdfIndirectReference2);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfIndirectReference addPageRef(PdfIndirectReference pdfIndirectReference) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            this.pages.add(pdfIndirectReference);
            return (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfIndirectReference writePageTree() throws IOException {
        if (this.pages.isEmpty()) {
            throw new IOException("The document has no pages.");
        }
        int n2 = 1;
        ArrayList<PdfIndirectReference> arrayList = this.parents;
        ArrayList arrayList2 = this.pages;
        ArrayList<PdfIndirectReference> arrayList3 = new ArrayList<PdfIndirectReference>();
        while (true) {
            n2 *= this.leafSize;
            int n3 = this.leafSize;
            int n4 = arrayList2.size() % this.leafSize;
            if (n4 == 0) {
                n4 = this.leafSize;
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n5;
                int n6 = n2;
                if (i2 == arrayList.size() - 1) {
                    n5 = n4;
                    n6 = this.pages.size() % n2;
                    if (n6 == 0) {
                        n6 = n2;
                    }
                } else {
                    n5 = n3;
                }
                PdfDictionary pdfDictionary = new PdfDictionary(PdfName.PAGES);
                pdfDictionary.put(PdfName.COUNT, new PdfNumber(n6));
                PdfArray pdfArray = new PdfArray();
                ArrayList arrayList4 = pdfArray.getArrayList();
                arrayList4.addAll(arrayList2.subList(i2 * n3, i2 * n3 + n5));
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                if (arrayList.size() > 1) {
                    if (i2 % this.leafSize == 0) {
                        arrayList3.add(this.writer.getPdfIndirectReference());
                    }
                    pdfDictionary.put(PdfName.PARENT, (PdfIndirectReference)arrayList3.get(i2 / this.leafSize));
                } else {
                    pdfDictionary.put(PdfName.ITXT, new PdfString(Document.getRelease()));
                }
                this.writer.addToBody((PdfObject)pdfDictionary, (PdfIndirectReference)arrayList.get(i2));
            }
            if (arrayList.size() == 1) {
                this.topParent = (PdfIndirectReference)arrayList.get(0);
                return this.topParent;
            }
            arrayList2 = arrayList;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
    }

    PdfIndirectReference getTopParent() {
        return this.topParent;
    }

    void setLinearMode(PdfIndirectReference pdfIndirectReference) {
        if (this.parents.size() > 1) {
            throw new RuntimeException("Linear page mode can only be called with a single parent.");
        }
        if (pdfIndirectReference != null) {
            this.topParent = pdfIndirectReference;
            this.parents.clear();
            this.parents.add(pdfIndirectReference);
        }
        this.leafSize = 10000000;
    }

    void addPage(PdfIndirectReference pdfIndirectReference) {
        this.pages.add(pdfIndirectReference);
    }

    int reorderPages(int[] nArray) throws DocumentException {
        int n2;
        if (nArray == null) {
            return this.pages.size();
        }
        if (this.parents.size() > 1) {
            throw new DocumentException("Page reordering requires a single parent in the page tree. Call PdfWriter.setLinearMode() after open.");
        }
        if (nArray.length != this.pages.size()) {
            throw new DocumentException("Page reordering requires an array with the same size as the number of pages.");
        }
        int n3 = this.pages.size();
        boolean[] blArray = new boolean[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = nArray[i2];
            if (n2 < 1 || n2 > n3) {
                throw new DocumentException("Page reordering requires pages between 1 and " + n3 + ". Found " + n2 + ".");
            }
            if (blArray[n2 - 1]) {
                throw new DocumentException("Page reordering requires no page repetition. Page " + n2 + " is repeated.");
            }
            blArray[n2 - 1] = true;
        }
        Object[] objectArray = this.pages.toArray();
        for (n2 = 0; n2 < n3; ++n2) {
            this.pages.set(n2, objectArray[nArray[n2] - 1]);
        }
        return n3;
    }
}

