/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.StampContent;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import com.lowagie.text.xml.xmp.XmpReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.xml.sax.SAXException;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected boolean flatFreeText = false;
    protected int[] namePtr = new int[]{0};
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c2, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (!pdfReader.isOpenedWithFullPermissions()) {
            throw new BadPasswordException("PdfReader not opened with owner password");
        }
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n2;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                this.crypto = new PdfEncryption(pdfReader.getDecrypt());
            }
            this.pdf_version.setAppendmode(true);
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n2 = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n2);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c2 == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c2);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.getXrefSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws IOException {
        Object object;
        Object object2;
        Object object3;
        PdfObject pdfObject;
        Object object4;
        Object object5;
        PdfObject pdfObject2;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.viewerPreferences);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        this.addFieldResources();
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PAGES));
        pdfDictionary2.put(PdfName.ITXT, new PdfString(Document.getRelease()));
        this.markUsed(pdfDictionary2);
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(pdfDictionary3);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && pdfDictionary3 != null) {
            pdfDictionary3.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(pdfDictionary3);
            this.markUsed(pdfDictionary);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        if (this.openAction != null) {
            pdfDictionary.put(PdfName.OPENACTION, this.openAction);
        }
        if (this.pdf.pageLabels != null) {
            pdfDictionary.put(PdfName.PAGELABELS, this.pdf.pageLabels.getDictionary(this));
        }
        if (!this.documentOCG.isEmpty()) {
            this.fillOCProperties(false);
            PdfDictionary pdfDictionary4 = pdfDictionary.getAsDict(PdfName.OCPROPERTIES);
            if (pdfDictionary4 == null) {
                this.reader.getCatalog().put(PdfName.OCPROPERTIES, this.OCProperties);
            } else {
                pdfDictionary4.put(PdfName.OCGS, this.OCProperties.get(PdfName.OCGS));
                pdfObject2 = pdfDictionary4.getAsDict(PdfName.D);
                if (pdfObject2 == null) {
                    pdfObject2 = new PdfDictionary();
                    pdfDictionary4.put(PdfName.D, pdfObject2);
                }
                ((PdfDictionary)pdfObject2).put(PdfName.ORDER, this.OCProperties.getAsDict(PdfName.D).get(PdfName.ORDER));
                ((PdfDictionary)pdfObject2).put(PdfName.RBGROUPS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.RBGROUPS));
                ((PdfDictionary)pdfObject2).put(PdfName.OFF, this.OCProperties.getAsDict(PdfName.D).get(PdfName.OFF));
                ((PdfDictionary)pdfObject2).put(PdfName.AS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.AS));
            }
        }
        int n2 = -1;
        pdfObject2 = (PRIndirectReference)this.reader.getTrailer().get(PdfName.INFO);
        PdfDictionary pdfDictionary5 = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        String string = null;
        if (pdfObject2 != null) {
            n2 = ((PdfIndirectReference)pdfObject2).getNumber();
        }
        if (pdfDictionary5 != null && pdfDictionary5.get(PdfName.PRODUCER) != null) {
            string = pdfDictionary5.getAsString(PdfName.PRODUCER).toString();
        }
        if (string == null) {
            string = Document.getVersion();
        } else if (string.indexOf(Document.getProduct()) == -1) {
            object5 = new StringBuffer(string);
            ((StringBuffer)object5).append("; modified using ");
            ((StringBuffer)object5).append(Document.getVersion());
            string = ((StringBuffer)object5).toString();
        }
        object5 = null;
        PdfObject pdfObject3 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.METADATA));
        if (pdfObject3 != null && pdfObject3.isStream()) {
            object5 = PdfReader.getStreamBytesRaw((PRStream)pdfObject3);
            PdfReader.killIndirect(pdfDictionary.get(PdfName.METADATA));
        }
        if (this.xmpMetadata != null) {
            object5 = this.xmpMetadata;
        }
        PdfDate pdfDate = new PdfDate();
        if (object5 != null) {
            PdfStream pdfStream;
            try {
                object4 = new XmpReader((byte[])object5);
                if (!((XmpReader)object4).replace("http://ns.adobe.com/pdf/1.3/", "Producer", string)) {
                    ((XmpReader)object4).add("rdf:Description", "http://ns.adobe.com/pdf/1.3/", "pdf:Producer", string);
                }
                if (!((XmpReader)object4).replace("http://ns.adobe.com/xap/1.0/", "ModifyDate", pdfDate.getW3CDate())) {
                    ((XmpReader)object4).add("rdf:Description", "http://ns.adobe.com/xap/1.0/", "xmp:ModifyDate", pdfDate.getW3CDate());
                }
                ((XmpReader)object4).replace("http://ns.adobe.com/xap/1.0/", "MetadataDate", pdfDate.getW3CDate());
                pdfStream = new PdfStream(((XmpReader)object4).serializeDoc());
            }
            catch (SAXException sAXException) {
                pdfStream = new PdfStream((byte[])object5);
            }
            catch (IOException iOException) {
                pdfStream = new PdfStream((byte[])object5);
            }
            pdfStream.put(PdfName.TYPE, PdfName.METADATA);
            pdfStream.put(PdfName.SUBTYPE, PdfName.XML);
            if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                object4 = new PdfArray();
                ((PdfArray)object4).add(PdfName.CRYPT);
                pdfStream.put(PdfName.FILTER, (PdfObject)object4);
            }
            if (this.append && pdfObject3 != null) {
                this.body.add((PdfObject)pdfStream, pdfObject3.getIndRef());
            } else {
                pdfDictionary.put(PdfName.METADATA, this.body.add(pdfStream).getIndirectReference());
                this.markUsed(pdfDictionary);
            }
        }
        try {
            this.file.reOpen();
            this.alterContents();
            int n3 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            if (this.append) {
                int n4;
                object4 = this.marked.getKeys();
                for (n4 = 0; n4 < ((Object)object4).length; ++n4) {
                    Object object6 = object4[n4];
                    pdfObject = this.reader.getPdfObjectRelease((int)object6);
                    if (pdfObject == null || n2 == object6 || object6 >= this.initialXrefSize) continue;
                    this.addToBody(pdfObject, (int)object6, object6 != n3);
                }
                for (n4 = this.initialXrefSize; n4 < this.reader.getXrefSize(); ++n4) {
                    PdfObject pdfObject4 = this.reader.getPdfObject(n4);
                    if (pdfObject4 == null) continue;
                    this.addToBody(pdfObject4, this.getNewObjectNumber(this.reader, n4, 0));
                }
            } else {
                for (int i2 = 1; i2 < this.reader.getXrefSize(); ++i2) {
                    PdfObject pdfObject5 = this.reader.getPdfObjectRelease(i2);
                    if (pdfObject5 == null || n2 == i2) continue;
                    this.addToBody(pdfObject5, this.getNewObjectNumber(this.reader, i2, 0), i2 != n3);
                }
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject6 = null;
        if (this.crypto != null) {
            if (this.append) {
                pdfIndirectReference = this.reader.getCryptoRef();
            } else {
                PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                pdfIndirectReference = pdfIndirectObject.getIndirectReference();
            }
            pdfObject6 = this.crypto.getFileID();
        } else {
            pdfObject6 = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference2 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference.getNumber(), 0));
        pdfObject = null;
        PdfDictionary pdfDictionary6 = new PdfDictionary();
        if (pdfDictionary5 != null) {
            object3 = pdfDictionary5.getKeys().iterator();
            while (object3.hasNext()) {
                object2 = (PdfName)object3.next();
                object = PdfReader.getPdfObject(pdfDictionary5.get((PdfName)object2));
                pdfDictionary6.put((PdfName)object2, (PdfObject)object);
            }
        }
        if (hashMap != null) {
            object3 = hashMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (String)object2.getKey();
                PdfName pdfName = new PdfName((String)object);
                String string2 = (String)object2.getValue();
                if (string2 == null) {
                    pdfDictionary6.remove(pdfName);
                    continue;
                }
                pdfDictionary6.put(pdfName, new PdfString(string2, "UnicodeBig"));
            }
        }
        pdfDictionary6.put(PdfName.MODDATE, pdfDate);
        pdfDictionary6.put(PdfName.PRODUCER, new PdfString(string));
        pdfObject = this.append ? (pdfObject2 == null ? this.addToBody((PdfObject)pdfDictionary6, false).getIndirectReference() : this.addToBody((PdfObject)pdfDictionary6, ((PdfIndirectReference)pdfObject2).getNumber(), false).getIndirectReference()) : this.addToBody((PdfObject)pdfDictionary6, false).getIndirectReference();
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference2, (PdfIndirectReference)pdfObject, pdfIndirectReference, pdfObject6, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            object3 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference2, (PdfIndirectReference)pdfObject, pdfIndirectReference, pdfObject6, this.prevxref);
            ((PdfWriter.PdfTrailer)object3).toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.reader.close();
    }

    void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.values().iterator();
        while (iterator.hasNext()) {
            PageStamp pageStamp = (PageStamp)iterator.next();
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            pdfStream.flateCompress(this.compressionLevel);
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                ByteBuffer byteBuffer2 = pageStamp.over.getInternalBuffer();
                byteBuffer.append(byteBuffer2.getBuffer(), 0, pageStamp.replacePoint);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(byteBuffer2.getBuffer(), pageStamp.replacePoint, byteBuffer2.size() - pageStamp.replacePoint);
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                pdfStream.flateCompress(this.compressionLevel);
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n2, int n3) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n4 = intHashtable.get(n2);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                intHashtable.put(n2, n4);
            }
            return n4;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n2 < this.initialXrefSize) {
                return n2;
            }
            int n5 = this.myXref.get(n2);
            if (n5 == 0) {
                n5 = this.getIndirectReferenceNumber();
                this.myXref.put(n2, n5);
            }
            return n5;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n2, n3);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                PdfArray pdfArray = (PdfArray)pdfObject;
                for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
                    PdfStamperImp.findAllObjects(pdfReader, pdfArray.getPdfObject(i2), intHashtable);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        int n2;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = pdfDictionary.getAsDict(PdfName.FDF)) == null) {
            return;
        }
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.ANNOTS);
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
            PdfObject pdfObject5 = pdfArray.getPdfObject(i2);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject5);
            pdfObject4 = pdfDictionary2.getAsNumber(PdfName.PAGE);
            if (pdfObject4 == null || ((PdfNumber)pdfObject4).intValue() >= this.reader.getNumberOfPages()) continue;
            PdfStamperImp.findAllObjects(fdfReader, pdfObject5, intHashtable);
            arrayList.add(pdfObject5);
            if (pdfObject5.type() != 10 || (pdfObject3 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NM))) == null || pdfObject3.type() != 3) continue;
            hashMap.put(pdfObject3.toString(), pdfObject5);
        }
        int[] nArray = intHashtable.getKeys();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = nArray[n2];
            pdfObject4 = fdfReader.getPdfObject(n3);
            if (pdfObject4.type() == 6 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.IRT))) != null && pdfObject3.type() == 3 && (pdfObject2 = (PdfObject)hashMap.get(pdfObject3.toString())) != null) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).merge((PdfDictionary)pdfObject4);
                ((PdfDictionary)pdfObject).put(PdfName.IRT, pdfObject2);
                pdfObject4 = pdfObject;
            }
            this.addToBody(pdfObject4, this.getNewObjectNumber(fdfReader, n3, 0));
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            PdfObject pdfObject6 = (PdfObject)arrayList.get(n2);
            pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject6);
            pdfObject3 = ((PdfDictionary)pdfObject4).getAsNumber(PdfName.PAGE);
            pdfObject2 = this.reader.getPageN(((PdfNumber)pdfObject3).intValue() + 1);
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS), pdfObject2);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                ((PdfDictionary)pdfObject2).put(PdfName.ANNOTS, pdfObject);
                this.markUsed(pdfObject2);
            }
            this.markUsed(pdfObject);
            ((PdfArray)pdfObject).add(pdfObject6);
        }
    }

    PageStamp getPageStamp(int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n2) {
        if (n2 < 1 || n2 > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n2);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, pageStamp);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n2) {
        if (n2 < 1 || n2 > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n2);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    void correctAcroFieldPages(int n2) {
        if (this.acroFields == null) {
            return;
        }
        if (n2 > this.reader.getNumberOfPages()) {
            return;
        }
        HashMap hashMap = this.acroFields.getFields();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            AcroFields.Item item = (AcroFields.Item)iterator.next();
            for (int i2 = 0; i2 < item.size(); ++i2) {
                int n3 = item.getPage(i2);
                if (n3 < n2) continue;
                item.forcePage(i2, n3 + 1);
            }
        }
    }

    private static void moveRectangle(PdfDictionary pdfDictionary, PdfReader pdfReader, int n2, PdfName pdfName, String string) {
        Rectangle rectangle = pdfReader.getBoxSize(n2, string);
        if (rectangle == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, new PdfRectangle(rectangle));
        }
    }

    void replacePage(PdfReader pdfReader, int n2, int n3) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n3);
        if (this.pagesToContent.containsKey(pdfDictionary)) {
            throw new IllegalStateException("This page cannot be replaced: new content was already added");
        }
        PdfImportedPage pdfImportedPage = this.getImportedPage(pdfReader, n2);
        PdfDictionary pdfDictionary2 = this.reader.getPageNRelease(n3);
        pdfDictionary2.remove(PdfName.RESOURCES);
        pdfDictionary2.remove(PdfName.CONTENTS);
        PdfStamperImp.moveRectangle(pdfDictionary2, pdfReader, n2, PdfName.MEDIABOX, "media");
        PdfStamperImp.moveRectangle(pdfDictionary2, pdfReader, n2, PdfName.CROPBOX, "crop");
        PdfStamperImp.moveRectangle(pdfDictionary2, pdfReader, n2, PdfName.TRIMBOX, "trim");
        PdfStamperImp.moveRectangle(pdfDictionary2, pdfReader, n2, PdfName.ARTBOX, "art");
        PdfStamperImp.moveRectangle(pdfDictionary2, pdfReader, n2, PdfName.BLEEDBOX, "bleed");
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(pdfReader.getPageRotation(n2)));
        PdfContentByte pdfContentByte = this.getOverContent(n3);
        pdfContentByte.addTemplate(pdfImportedPage, 0.0f, 0.0f);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        pageStamp.replacePoint = pageStamp.over.getInternalBuffer().size();
    }

    void insertPage(int n2, Rectangle rectangle) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PRIndirectReference pRIndirectReference;
        PdfObject pdfObject2;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n3 = rectangle2.getRotation() % 360;
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.PAGE);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(PdfName.PDF);
        pdfArray.add(PdfName.TEXT);
        pdfArray.add(PdfName.IMAGEB);
        pdfArray.add(PdfName.IMAGEC);
        pdfArray.add(PdfName.IMAGEI);
        pdfDictionary3.put(PdfName.PROCSET, pdfArray);
        pdfDictionary2.put(PdfName.RESOURCES, pdfDictionary3);
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(n3));
        pdfDictionary2.put(PdfName.MEDIABOX, new PdfRectangle(rectangle2, n3));
        PRIndirectReference pRIndirectReference2 = this.reader.addPdfObject(pdfDictionary2);
        if (n2 > this.reader.getNumberOfPages()) {
            pdfObject2 = this.reader.getPageNRelease(this.reader.getNumberOfPages());
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ((PdfArray)pdfObject).add(pRIndirectReference2);
            this.markUsed(pdfObject);
            this.reader.pageRefs.insertPage(n2, pRIndirectReference2);
        } else {
            if (n2 < 1) {
                n2 = 1;
            }
            pdfObject2 = this.reader.getPageN(n2);
            pdfObject = this.reader.getPageOrigRef(n2);
            this.reader.releasePage(n2);
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            int n4 = pdfArray2.size();
            int n5 = ((PdfIndirectReference)pdfObject).getNumber();
            for (int i2 = 0; i2 < n4; ++i2) {
                PRIndirectReference pRIndirectReference3 = (PRIndirectReference)pdfArray2.getPdfObject(i2);
                if (n5 != pRIndirectReference3.getNumber()) continue;
                pdfArray2.add(i2, pRIndirectReference2);
                break;
            }
            if (n4 == pdfArray2.size()) {
                throw new RuntimeException("Internal inconsistence.");
            }
            this.markUsed(pdfArray2);
            this.reader.pageRefs.insertPage(n2, pRIndirectReference2);
            this.correctAcroFieldPages(n2);
        }
        pdfDictionary2.put(PdfName.PARENT, pRIndirectReference);
        while (pdfDictionary != null) {
            this.markUsed(pdfDictionary);
            pdfObject2 = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.COUNT));
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(((PdfNumber)pdfObject2).intValue() + 1));
            pdfDictionary = pdfDictionary.getAsDict(PdfName.PARENT);
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void setFreeTextFlattening(boolean bl) {
        this.flatFreeText = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (this.acroFields.getXfa().isXfaPresent()) {
            throw new UnsupportedOperationException("Partial form flattening is not supported with XFA forms.");
        }
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        Object object;
        Object object2;
        Object object3;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                this.partialFlattening.add(object3.next());
            }
        }
        object3 = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
        PdfArray pdfArray = null;
        if (object3 != null) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.FIELDS), (PdfObject)object3);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (String)object2.getKey();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object)) continue;
            AcroFields.Item item = (AcroFields.Item)object2.getValue();
            for (int i2 = 0; i2 < item.size(); ++i2) {
                PdfIndirectReference pdfIndirectReference;
                Object object4;
                Object object5;
                PdfObject pdfObject;
                PdfDictionary pdfDictionary = item.getMerged(i2);
                PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.F);
                int n2 = 0;
                if (pdfNumber != null) {
                    n2 = pdfNumber.intValue();
                }
                int n3 = item.getPage(i2);
                PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.AP);
                if (pdfDictionary2 != null && (n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object6;
                    pdfObject = pdfDictionary2.get(PdfName.N);
                    object5 = null;
                    if (pdfObject != null) {
                        object6 = PdfReader.getPdfObject(pdfObject);
                        if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect()) {
                            object5 = new PdfAppearance((PdfIndirectReference)pdfObject);
                        } else if (object6 instanceof PdfStream) {
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            object5 = new PdfAppearance((PdfIndirectReference)pdfObject);
                        } else if (object6 != null && ((PdfObject)object6).isDictionary() && (object4 = pdfDictionary.getAsName(PdfName.AS)) != null && (pdfIndirectReference = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object4)) != null) {
                            object5 = new PdfAppearance(pdfIndirectReference);
                            if (pdfIndirectReference.isIndirect()) {
                                object6 = PdfReader.getPdfObject(pdfIndirectReference);
                                ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (object5 != null) {
                        object6 = PdfReader.getNormalizedRectangle(pdfDictionary.getAsArray(PdfName.RECT));
                        object4 = this.getOverContent(n3);
                        ((PdfContentByte)object4).setLiteral("Q ");
                        ((PdfContentByte)object4).addTemplate((PdfTemplate)object5, ((Rectangle)object6).getLeft(), ((Rectangle)object6).getBottom());
                        ((PdfContentByte)object4).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object5 = ((PdfDictionary)(pdfObject = this.reader.getPageN(n3))).getAsArray(PdfName.ANNOTS)) == null) continue;
                block3: for (int i3 = 0; i3 < ((PdfArray)object5).size(); ++i3) {
                    object4 = ((PdfArray)object5).getPdfObject(i3);
                    if (!((PdfObject)object4).isIndirect() || !(pdfIndirectReference = item.getWidgetRef(i2)).isIndirect() || ((PRIndirectReference)object4).getNumber() != ((PRIndirectReference)pdfIndirectReference).getNumber()) continue;
                    ((PdfArray)object5).remove(i3--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfIndirectReference;
                    while (true) {
                        PdfObject pdfObject2;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int i4 = 0; i4 < pdfArray.size(); ++i4) {
                                pdfObject2 = pdfArray.getPdfObject(i4);
                                if (!pdfObject2.isIndirect() || ((PRIndirectReference)pdfObject2).getNumber() != pRIndirectReference.getNumber()) continue;
                                pdfArray.remove(i4);
                                --i4;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject2 = pdfDictionary4.getAsArray(PdfName.KIDS);
                        for (int i5 = 0; i5 < ((PdfArray)pdfObject2).size(); ++i5) {
                            PdfObject pdfObject3 = ((PdfArray)pdfObject2).getPdfObject(i5);
                            if (!pdfObject3.isIndirect() || ((PRIndirectReference)pdfObject3).getNumber() != pRIndirectReference.getNumber()) continue;
                            ((PdfArray)pdfObject2).remove(i5);
                            --i5;
                        }
                        if (!((PdfArray)pdfObject2).isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (!((PdfArray)object5).isEmpty()) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i6 = 1; i6 <= this.reader.getNumberOfPages(); ++i6) {
                object2 = this.reader.getPageN(i6);
                object = ((PdfDictionary)object2).getAsArray(PdfName.ANNOTS);
                if (object == null) continue;
                for (int i7 = 0; i7 < ((PdfArray)object).size(); ++i7) {
                    PdfObject pdfObject = ((PdfArray)object).getDirectObject(i7);
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || pdfObject.isDictionary() && !PdfName.WIDGET.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    ((PdfArray)object).remove(i7);
                    --i7;
                }
                if (!((PdfArray)object).isEmpty()) continue;
                PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                ((PdfDictionary)object2).remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        this.reader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfDictionary.remove(PdfName.XFA);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
            PdfReader.killIndirect(pdfObject2);
            pdfDictionary.put(PdfName.FIELDS, new PdfArray());
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (pdfObject2 == null || !pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
            this.sweepKids(pdfArray.getPdfObject(i2));
        }
    }

    private void flatFreeTextFields() {
        if (this.append) {
            throw new IllegalArgumentException("FreeText flattening is not supported in append mode.");
        }
        for (int i2 = 1; i2 <= this.reader.getNumberOfPages(); ++i2) {
            PdfObject pdfObject;
            int n2;
            PdfDictionary pdfDictionary = this.reader.getPageN(i2);
            PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.ANNOTS);
            if (pdfArray == null) continue;
            for (n2 = 0; n2 < pdfArray.size(); ++n2) {
                Object object;
                Object object2;
                PdfObject pdfObject2;
                int n3;
                PdfDictionary pdfDictionary2;
                pdfObject = pdfArray.getDirectObject(n2);
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !((PdfName)(pdfDictionary2 = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE)).equals(PdfName.FREETEXT)) continue;
                PdfNumber pdfNumber = pdfDictionary2.getAsNumber(PdfName.F);
                int n4 = n3 = pdfNumber != null ? pdfNumber.intValue() : 0;
                if ((n3 & 4) == 0 || (n3 & 2) != 0 || (pdfObject2 = pdfDictionary2.get(PdfName.AP)) == null) continue;
                PdfDictionary pdfDictionary3 = pdfObject2 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(pdfObject2) : (PdfDictionary)pdfObject2;
                PdfObject pdfObject3 = pdfDictionary3.get(PdfName.N);
                PdfAppearance pdfAppearance = null;
                PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4 instanceof PdfStream) {
                    ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4.isDictionary() && (object2 = pdfDictionary3.getAsName(PdfName.AS)) != null && (object = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)object);
                    if (((PdfObject)object).isIndirect()) {
                        pdfObject4 = PdfReader.getPdfObject((PdfObject)object);
                        ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (pdfAppearance == null) continue;
                object2 = PdfReader.getNormalizedRectangle(pdfDictionary2.getAsArray(PdfName.RECT));
                object = this.getOverContent(i2);
                ((PdfContentByte)object).setLiteral("Q ");
                ((PdfContentByte)object).addTemplate(pdfAppearance, ((Rectangle)object2).getLeft(), ((Rectangle)object2).getBottom());
                ((PdfContentByte)object).setLiteral("q ");
            }
            for (n2 = 0; n2 < pdfArray.size(); ++n2) {
                pdfObject = pdfArray.getAsDict(n2);
                if (pdfObject == null || !PdfName.FREETEXT.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                pdfArray.remove(n2);
                --n2;
            }
            if (!pdfArray.isEmpty()) continue;
            PdfReader.killIndirect(pdfDictionary.get(PdfName.ANNOTS));
            pdfDictionary.remove(PdfName.ANNOTS);
        }
    }

    public PdfIndirectReference getPageReference(int n2) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n2);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n2);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        if (!pdfDictionary2.contains(PdfName.DA)) {
            pdfDictionary2.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() throws IOException {
        Object object;
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        Object object2 = this.fieldTemplates.keySet().iterator();
        while (object2.hasNext()) {
            object = (PdfTemplate)object2.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)((PdfTemplate)object).getResources(), this);
        }
        object2 = pdfDictionary.getAsDict(PdfName.FONT);
        if (object2 == null) {
            object2 = new PdfDictionary();
            pdfDictionary.put(PdfName.FONT, (PdfObject)object2);
        }
        if (!((PdfDictionary)object2).contains(PdfName.HELV)) {
            object = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object).put(PdfName.BASEFONT, PdfName.HELVETICA);
            ((PdfDictionary)object).put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            ((PdfDictionary)object).put(PdfName.NAME, PdfName.HELV);
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object2).put(PdfName.HELV, this.addToBody((PdfObject)object).getIndirectReference());
        }
        if (!((PdfDictionary)object2).contains(PdfName.ZADB)) {
            object = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object).put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            ((PdfDictionary)object).put(PdfName.NAME, PdfName.ZADB);
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object2).put(PdfName.ZADB, this.addToBody((PdfObject)object).getIndirectReference());
        }
        if (pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                this.expandFields((PdfFormField)arrayList2.get(i2), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i2);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    PdfArray pdfArray = null;
                    if (object == null || !((PdfObject)object).isArray()) {
                        pdfArray = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, pdfArray);
                        this.markUsed(pdfDictionary);
                    } else {
                        pdfArray = (PdfArray)object;
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    this.markUsed(pdfArray);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n2 = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n2) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.getTop() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - pdfRectangle.left(), rectangle.getTop() - pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.right(), rectangle.getTop() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.left(), pdfRectangle.top(), rectangle.getRight() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n2) {
        pdfAnnotation.setPage(n2);
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n2));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        HashMap hashMap = this.pdf.getDocumentLevelJS();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void addFileAttachments() throws IOException {
        HashMap hashMap = this.pdf.getDocumentFileAttachment();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        HashMap hashMap2 = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.EMBEDDEDFILES)));
        Object object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            String string = (String)entry.getKey();
            int n2 = 0;
            String string2 = string;
            while (hashMap2.containsKey(string2)) {
                string2 = string2 + " " + ++n2;
            }
            hashMap2.put(string2, entry.getValue());
        }
        object = PdfNameTree.writeTree(hashMap2, this);
        pdfDictionary2.put(PdfName.EMBEDDEDFILES, this.addToBody((PdfObject)object).getIndirectReference());
    }

    void makePackage(PdfCollection pdfCollection) {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        pdfDictionary.put(PdfName.COLLECTION, pdfCollection);
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        boolean bl = pdfDictionary.get(PdfName.DESTS) != null;
        this.writeOutlines(pdfDictionary, bl);
        this.markUsed(pdfDictionary);
    }

    public void setViewerPreferences(int n2) {
        this.useVp = true;
        this.viewerPreferences.setViewerPreferences(n2);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.useVp = true;
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
    }

    public void setSigFlags(int n2) {
        this.sigFlags |= n2;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n2) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    public void setDuration(int n2) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n2, int n3) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n3);
        if (n2 < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n2));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n2) {
        if (this.append) {
            this.marked.put(n2, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.AA);
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    void setThumbnail(Image image, int n2) throws PdfException, DocumentException {
        PdfIndirectReference pdfIndirectReference = this.getImageReference(this.addDirectImageSimple(image));
        this.reader.resetReleasePage();
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        pdfDictionary.put(PdfName.THUMB, pdfIndirectReference);
        this.reader.resetReleasePage();
    }

    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    protected void readOCProperties() {
        Object object;
        PdfLayer pdfLayer;
        PdfIndirectReference pdfIndirectReference;
        if (!this.documentOCG.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.OCPROPERTIES);
        if (pdfDictionary == null) {
            return;
        }
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.OCGS);
        HashMap<String, PdfLayer> hashMap = new HashMap<String, PdfLayer>();
        Object object2 = pdfArray.listIterator();
        while (object2.hasNext()) {
            pdfIndirectReference = (PdfIndirectReference)object2.next();
            pdfLayer = new PdfLayer(null);
            pdfLayer.setRef(pdfIndirectReference);
            pdfLayer.setOnPanel(false);
            pdfLayer.merge((PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference));
            hashMap.put(pdfIndirectReference.toString(), pdfLayer);
        }
        object2 = pdfDictionary.getAsDict(PdfName.D);
        PdfArray pdfArray2 = ((PdfDictionary)object2).getAsArray(PdfName.OFF);
        if (pdfArray2 != null) {
            object = pdfArray2.listIterator();
            while (object.hasNext()) {
                pdfIndirectReference = (PdfIndirectReference)object.next();
                pdfLayer = (PdfLayer)hashMap.get(pdfIndirectReference.toString());
                pdfLayer.setOn(false);
            }
        }
        if ((object = ((PdfDictionary)object2).getAsArray(PdfName.ORDER)) != null) {
            this.addOrder(null, (PdfArray)object, hashMap);
        }
        this.documentOCG.addAll(hashMap.values());
        this.OCGRadioGroup = ((PdfDictionary)object2).getAsArray(PdfName.RBGROUPS);
        this.OCGLocked = ((PdfDictionary)object2).getAsArray(PdfName.LOCKED);
        if (this.OCGLocked == null) {
            this.OCGLocked = new PdfArray();
        }
    }

    private void addOrder(PdfLayer pdfLayer, PdfArray pdfArray, Map map) {
        for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
            PdfLayer pdfLayer2;
            PdfObject pdfObject = pdfArray.getPdfObject(i2);
            if (pdfObject.isIndirect()) {
                pdfLayer2 = (PdfLayer)map.get(pdfObject.toString());
                pdfLayer2.setOnPanel(true);
                this.registerLayer(pdfLayer2);
                if (pdfLayer != null) {
                    pdfLayer.addChild(pdfLayer2);
                }
                if (pdfArray.size() <= i2 + 1 || !pdfArray.getPdfObject(i2 + 1).isArray()) continue;
                this.addOrder(pdfLayer2, (PdfArray)pdfArray.getPdfObject(++i2), map);
                continue;
            }
            if (!pdfObject.isArray()) continue;
            PdfArray pdfArray2 = (PdfArray)pdfObject;
            if (pdfArray2.isEmpty()) {
                return;
            }
            pdfObject = pdfArray2.getPdfObject(0);
            if (pdfObject.isString()) {
                pdfLayer2 = new PdfLayer(pdfObject.toString());
                pdfLayer2.setOnPanel(true);
                this.registerLayer(pdfLayer2);
                if (pdfLayer != null) {
                    pdfLayer.addChild(pdfLayer2);
                }
                PdfArray pdfArray3 = new PdfArray();
                ListIterator listIterator = pdfArray2.listIterator();
                while (listIterator.hasNext()) {
                    pdfArray3.add((PdfObject)listIterator.next());
                }
                this.addOrder(pdfLayer2, pdfArray3, map);
                continue;
            }
            this.addOrder(pdfLayer, (PdfArray)pdfObject, map);
        }
    }

    public Map getPdfLayers() {
        if (this.documentOCG.isEmpty()) {
            this.readOCProperties();
        }
        HashMap<String, PdfLayer> hashMap = new HashMap<String, PdfLayer>();
        Iterator iterator = this.documentOCG.iterator();
        while (iterator.hasNext()) {
            PdfLayer pdfLayer = (PdfLayer)iterator.next();
            String string = pdfLayer.getTitle() == null ? pdfLayer.getAsString(PdfName.NAME).toString() : pdfLayer.getTitle();
            if (hashMap.containsKey(string)) {
                int n2 = 2;
                String string2 = string + "(" + n2 + ")";
                while (hashMap.containsKey(string2)) {
                    string2 = string + "(" + ++n2 + ")";
                }
                string = string2;
            }
            hashMap.put(string, pdfLayer);
        }
        return hashMap;
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;
        int replacePoint = 0;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

