/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.TSAClient;
import com.lowagie.text.pdf.codec.Base64;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TSAClientBouncyCastle
implements TSAClient {
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected int tokSzEstimate;

    public TSAClientBouncyCastle(String string) {
        this(string, null, null, 4096);
    }

    public TSAClientBouncyCastle(String string, String string2, String string3) {
        this(string, string2, string3, 4096);
    }

    public TSAClientBouncyCastle(String string, String string2, String string3, int n2) {
        this.tsaURL = string;
        this.tsaUsername = string2;
        this.tsaPassword = string3;
        this.tokSzEstimate = n2;
    }

    public int getTokenSizeEstimate() {
        return this.tokSzEstimate;
    }

    public byte[] getTimeStampToken(PdfPKCS7 pdfPKCS7, byte[] byArray) throws Exception {
        return this.getTimeStampToken(byArray);
    }

    protected byte[] getTimeStampToken(byte[] byArray) throws Exception {
        byte[] byArray2 = null;
        try {
            int n2;
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            timeStampRequestGenerator.setCertReq(true);
            BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
            TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(X509ObjectIdentifiers.id_SHA1.getId(), byArray, bigInteger);
            byte[] byArray3 = timeStampRequest.getEncoded();
            byArray2 = this.getTSAResponse(byArray3);
            TimeStampResponse timeStampResponse = new TimeStampResponse(byArray2);
            timeStampResponse.validate(timeStampRequest);
            PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
            int n3 = n2 = pKIFailureInfo == null ? 0 : pKIFailureInfo.intValue();
            if (n2 != 0) {
                throw new Exception("Invalid TSA '" + this.tsaURL + "' response, code " + n2);
            }
            TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
            if (timeStampToken == null) {
                throw new Exception("TSA '" + this.tsaURL + "' failed to return time stamp token: " + timeStampResponse.getStatusString());
            }
            TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
            byte[] byArray4 = timeStampToken.getEncoded();
            long l2 = System.currentTimeMillis();
            this.tokSzEstimate = byArray4.length + 32;
            return byArray4;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new Exception("Failed to get TSA response from '" + this.tsaURL + "'", throwable);
        }
    }

    protected byte[] getTSAResponse(byte[] byArray) throws Exception {
        Object object;
        URL uRL = new URL(this.tsaURL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        uRLConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !this.tsaUsername.equals("")) {
            object = this.tsaUsername + ":" + this.tsaPassword;
            uRLConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBytes(((String)object).getBytes())));
        }
        object = uRLConnection.getOutputStream();
        ((OutputStream)object).write(byArray);
        ((OutputStream)object).close();
        InputStream inputStream = uRLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray2, 0, byArray2.length)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        String string = uRLConnection.getContentEncoding();
        if (string != null && string.equalsIgnoreCase("base64")) {
            byArray3 = Base64.decode(new String(byArray3));
        }
        return byArray3;
    }
}

