/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Jpeg;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.TIFFDirectory;
import com.lowagie.text.pdf.codec.TIFFFaxDecoder;
import com.lowagie.text.pdf.codec.TIFFField;
import com.lowagie.text.pdf.codec.TIFFLZWDecoder;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class TiffImage {
    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            return TIFFDirectory.getNumDirectories(randomAccessFileOrArray);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static int getDpi(TIFFField tIFFField, int n2) {
        if (tIFFField == null) {
            return 0;
        }
        long[] lArray = tIFFField.getAsRational(0);
        float f2 = (float)lArray[0] / (float)lArray[1];
        int n3 = 0;
        switch (n2) {
            case 1: 
            case 2: {
                n3 = (int)((double)f2 + 0.5);
                break;
            }
            case 3: {
                n3 = (int)((double)f2 * 2.54 + 0.5);
            }
        }
        return n3;
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n2) {
        return TiffImage.getTiffImage(randomAccessFileOrArray, n2, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n2, boolean bl) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The page number must be >= 1.");
        }
        try {
            Object object;
            Object object2;
            long l2;
            TIFFDirectory tIFFDirectory = new TIFFDirectory(randomAccessFileOrArray, n2 - 1);
            if (tIFFDirectory.isTagPresent(322)) {
                throw new IllegalArgumentException("Tiles are not supported.");
            }
            int n3 = (int)tIFFDirectory.getFieldAsLong(259);
            switch (n3) {
                case 2: 
                case 3: 
                case 4: 
                case 32771: {
                    break;
                }
                default: {
                    return TiffImage.getTiffImageColor(tIFFDirectory, randomAccessFileOrArray);
                }
            }
            float f2 = 0.0f;
            if (tIFFDirectory.isTagPresent(274)) {
                int n4 = (int)tIFFDirectory.getFieldAsLong(274);
                if (n4 == 3 || n4 == 4) {
                    f2 = (float)Math.PI;
                } else if (n4 == 5 || n4 == 8) {
                    f2 = 1.5707964f;
                } else if (n4 == 6 || n4 == 7) {
                    f2 = -1.5707964f;
                }
            }
            Image image = null;
            long l3 = 0L;
            long l4 = 0L;
            int n5 = 1;
            int n6 = (int)tIFFDirectory.getFieldAsLong(257);
            int n7 = (int)tIFFDirectory.getFieldAsLong(256);
            int n8 = 0;
            int n9 = 0;
            float f3 = 0.0f;
            int n10 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n10 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n8 = TiffImage.getDpi(tIFFDirectory.getField(282), n10);
            n9 = TiffImage.getDpi(tIFFDirectory.getField(283), n10);
            if (n10 == 1) {
                if (n9 != 0) {
                    f3 = (float)n8 / (float)n9;
                }
                n8 = 0;
                n9 = 0;
            }
            int n11 = n6;
            if (tIFFDirectory.isTagPresent(278)) {
                n11 = (int)tIFFDirectory.getFieldAsLong(278);
            }
            if (n11 <= 0 || n11 > n6) {
                n11 = n6;
            }
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            if ((lArray2 == null || lArray2.length == 1 && (lArray2[0] == 0L || lArray2[0] + lArray[0] > (long)randomAccessFileOrArray.length())) && n6 == n11) {
                lArray2 = new long[]{randomAccessFileOrArray.length() - (int)lArray[0]};
            }
            boolean bl2 = false;
            TIFFField tIFFField = tIFFDirectory.getField(266);
            if (tIFFField != null) {
                n5 = tIFFField.getAsInt(0);
            }
            bl2 = n5 == 2;
            int n12 = 0;
            if (tIFFDirectory.isTagPresent(262) && (l2 = tIFFDirectory.getFieldAsLong(262)) == 1L) {
                n12 |= 1;
            }
            int n13 = 0;
            switch (n3) {
                case 2: 
                case 32771: {
                    n13 = 257;
                    n12 |= 0xA;
                    break;
                }
                case 3: {
                    n13 = 257;
                    n12 |= 0xC;
                    object2 = tIFFDirectory.getField(292);
                    if (object2 == null) break;
                    l3 = ((TIFFField)object2).getAsLong(0);
                    if ((l3 & 1L) != 0L) {
                        n13 = 258;
                    }
                    if ((l3 & 4L) == 0L) break;
                    n12 |= 2;
                    break;
                }
                case 4: {
                    n13 = 256;
                    object = tIFFDirectory.getField(293);
                    if (object == null) break;
                    l4 = ((TIFFField)object).getAsLong(0);
                }
            }
            if (bl && n11 == n6) {
                object2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully((byte[])object2);
                image = Image.getInstance(n7, n6, false, n13, n12, (byte[])object2);
                image.setInverted(true);
            } else {
                int n14 = n6;
                object = new CCITTG4Encoder(n7);
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    byte[] byArray = new byte[(int)lArray2[i2]];
                    randomAccessFileOrArray.seek(lArray[i2]);
                    randomAccessFileOrArray.readFully(byArray);
                    int n15 = Math.min(n11, n14);
                    TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(n5, n7, n15);
                    byte[] byArray2 = new byte[(n7 + 7) / 8 * n15];
                    switch (n3) {
                        case 2: 
                        case 32771: {
                            tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n15);
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                            break;
                        }
                        case 3: {
                            try {
                                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n15, l3);
                            }
                            catch (RuntimeException runtimeException) {
                                l3 ^= 4L;
                                try {
                                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n15, l3);
                                }
                                catch (RuntimeException runtimeException2) {
                                    throw runtimeException;
                                }
                            }
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                            break;
                        }
                        case 4: {
                            tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n15, l4);
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                        }
                    }
                    n14 -= n11;
                }
                byte[] byArray = ((CCITTG4Encoder)object).close();
                image = Image.getInstance(n7, n6, false, 256, n12 & 1, byArray);
            }
            image.setDpi(n8, n9);
            image.setXYRatio(f3);
            if (tIFFDirectory.isTagPresent(34675)) {
                try {
                    TIFFField tIFFField2 = tIFFDirectory.getField(34675);
                    object = ICC_Profile.getInstance(tIFFField2.getAsBytes());
                    if (((ICC_Profile)object).getNumComponents() == 1) {
                        image.tagICC((ICC_Profile)object);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            image.setOriginalType(5);
            if (f2 != 0.0f) {
                image.setInitialRotation(f2);
            }
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected static Image getTiffImageColor(TIFFDirectory tIFFDirectory, RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            int n2;
            byte[] byArray;
            int n3;
            int n4 = (int)tIFFDirectory.getFieldAsLong(259);
            int n5 = 1;
            TIFFLZWDecoder tIFFLZWDecoder = null;
            switch (n4) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The compression " + n4 + " is not supported.");
                }
            }
            int n6 = (int)tIFFDirectory.getFieldAsLong(262);
            switch (n6) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    if (n4 == 6 || n4 == 7) break;
                    throw new IllegalArgumentException("The photometric " + n6 + " is not supported.");
                }
            }
            float f2 = 0.0f;
            if (tIFFDirectory.isTagPresent(274)) {
                n3 = (int)tIFFDirectory.getFieldAsLong(274);
                if (n3 == 3 || n3 == 4) {
                    f2 = (float)Math.PI;
                } else if (n3 == 5 || n3 == 8) {
                    f2 = 1.5707964f;
                } else if (n3 == 6 || n3 == 7) {
                    f2 = -1.5707964f;
                }
            }
            if (tIFFDirectory.isTagPresent(284) && tIFFDirectory.getFieldAsLong(284) == 2L) {
                throw new IllegalArgumentException("Planar images are not supported.");
            }
            if (tIFFDirectory.isTagPresent(338)) {
                throw new IllegalArgumentException("Extra samples are not supported.");
            }
            n3 = 1;
            if (tIFFDirectory.isTagPresent(277)) {
                n3 = (int)tIFFDirectory.getFieldAsLong(277);
            }
            int n7 = 1;
            if (tIFFDirectory.isTagPresent(258)) {
                n7 = (int)tIFFDirectory.getFieldAsLong(258);
            }
            switch (n7) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bits per sample " + n7 + " is not supported.");
                }
            }
            Image image = null;
            int n8 = (int)tIFFDirectory.getFieldAsLong(257);
            int n9 = (int)tIFFDirectory.getFieldAsLong(256);
            int n10 = 0;
            int n11 = 0;
            int n12 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n12 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n10 = TiffImage.getDpi(tIFFDirectory.getField(282), n12);
            n11 = TiffImage.getDpi(tIFFDirectory.getField(283), n12);
            int n13 = 1;
            boolean bl = false;
            TIFFField tIFFField = tIFFDirectory.getField(266);
            if (tIFFField != null) {
                n13 = tIFFField.getAsInt(0);
            }
            bl = n13 == 2;
            int n14 = n8;
            if (tIFFDirectory.isTagPresent(278)) {
                n14 = (int)tIFFDirectory.getFieldAsLong(278);
            }
            if (n14 <= 0 || n14 > n8) {
                n14 = n8;
            }
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            if ((lArray2 == null || lArray2.length == 1 && (lArray2[0] == 0L || lArray2[0] + lArray[0] > (long)randomAccessFileOrArray.length())) && n8 == n14) {
                lArray2 = new long[]{randomAccessFileOrArray.length() - (int)lArray[0]};
            }
            if (n4 == 5) {
                TIFFField tIFFField2 = tIFFDirectory.getField(317);
                if (tIFFField2 != null) {
                    n5 = tIFFField2.getAsInt(0);
                    if (n5 != 1 && n5 != 2) {
                        throw new RuntimeException("Illegal value for Predictor in TIFF file.");
                    }
                    if (n5 == 2 && n7 != 8) {
                        throw new RuntimeException(n7 + "-bit samples are not supported for Horizontal differencing Predictor.");
                    }
                }
                tIFFLZWDecoder = new TIFFLZWDecoder(n9, n5, n3);
            }
            int n15 = n8;
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            CCITTG4Encoder cCITTG4Encoder = null;
            if (n7 == 1 && n3 == 1) {
                cCITTG4Encoder = new CCITTG4Encoder(n9);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (n4 != 6 && n4 != 7) {
                    deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                }
            }
            if (n4 == 6) {
                if (!tIFFDirectory.isTagPresent(513)) {
                    throw new IOException("Missing tag(s) for OJPEG compression.");
                }
                int n16 = (int)tIFFDirectory.getFieldAsLong(513);
                int n17 = randomAccessFileOrArray.length() - n16;
                if (tIFFDirectory.isTagPresent(514)) {
                    n17 = (int)tIFFDirectory.getFieldAsLong(514) + (int)lArray2[0];
                }
                byArray = new byte[Math.min(n17, randomAccessFileOrArray.length() - n16)];
                n2 = randomAccessFileOrArray.getFilePointer();
                randomAccessFileOrArray.seek(n2 += n16);
                randomAccessFileOrArray.readFully(byArray);
                image = new Jpeg(byArray);
            } else if (n4 == 7) {
                if (lArray2.length > 1) {
                    throw new IOException("Compression JPEG is only supported with a single strip. This image has " + lArray2.length + " strips.");
                }
                byte[] byArray2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully(byArray2);
                image = new Jpeg(byArray2);
            } else {
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    byte[] byArray3 = new byte[(int)lArray2[i2]];
                    randomAccessFileOrArray.seek(lArray[i2]);
                    randomAccessFileOrArray.readFully(byArray3);
                    int n18 = Math.min(n14, n15);
                    byte[] byArray4 = null;
                    if (n4 != 1) {
                        byArray4 = new byte[(n9 * n7 * n3 + 7) / 8 * n18];
                    }
                    if (bl) {
                        TIFFFaxDecoder.reverseBits(byArray3);
                    }
                    switch (n4) {
                        case 8: 
                        case 32946: {
                            TiffImage.inflate(byArray3, byArray4);
                            break;
                        }
                        case 1: {
                            byArray4 = byArray3;
                            break;
                        }
                        case 32773: {
                            TiffImage.decodePackbits(byArray3, byArray4);
                            break;
                        }
                        case 5: {
                            tIFFLZWDecoder.decode(byArray3, byArray4, n18);
                        }
                    }
                    if (n7 == 1 && n3 == 1) {
                        cCITTG4Encoder.fax4Encode(byArray4, n18);
                    } else {
                        deflaterOutputStream.write(byArray4);
                    }
                    n15 -= n14;
                }
                if (n7 == 1 && n3 == 1) {
                    image = Image.getInstance(n9, n8, false, 256, n6 == 1 ? 1 : 0, cCITTG4Encoder.close());
                } else {
                    deflaterOutputStream.close();
                    image = Image.getInstance(n9, n8, n3, n7, byteArrayOutputStream.toByteArray());
                    image.setDeflated(true);
                }
            }
            image.setDpi(n10, n11);
            if (n4 != 6 && n4 != 7) {
                if (tIFFDirectory.isTagPresent(34675)) {
                    try {
                        TIFFField tIFFField3 = tIFFDirectory.getField(34675);
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(tIFFField3.getAsBytes());
                        if (n3 == iCC_Profile.getNumComponents()) {
                            image.tagICC(iCC_Profile);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (tIFFDirectory.isTagPresent(320)) {
                    TIFFField tIFFField4 = tIFFDirectory.getField(320);
                    char[] cArray = tIFFField4.getAsChars();
                    byArray = new byte[cArray.length];
                    n2 = cArray.length / 3;
                    int n19 = n2 * 2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byArray[i3 * 3] = (byte)(cArray[i3] >>> 8);
                        byArray[i3 * 3 + 1] = (byte)(cArray[i3 + n2] >>> 8);
                        byArray[i3 * 3 + 2] = (byte)(cArray[i3 + n19] >>> 8);
                    }
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.INDEXED);
                    pdfArray.add(PdfName.DEVICERGB);
                    pdfArray.add(new PdfNumber(n2 - 1));
                    pdfArray.add(new PdfString(byArray));
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    pdfDictionary.put(PdfName.COLORSPACE, pdfArray);
                    image.setAdditional(pdfDictionary);
                }
                image.setOriginalType(5);
            }
            if (n6 == 0) {
                image.setInverted(true);
            }
            if (f2 != 0.0f) {
                image.setInitialRotation(f2);
            }
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static long[] getArrayLongShort(TIFFDirectory tIFFDirectory, int n2) {
        long[] lArray;
        TIFFField tIFFField = tIFFDirectory.getField(n2);
        if (tIFFField == null) {
            return null;
        }
        if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                lArray[i2] = cArray[i2];
            }
        }
        return lArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void decodePackbits(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        try {
            block2: while (n3 < byArray2.length) {
                int n4;
                byte by;
                if ((by = byArray[n2++]) >= 0 && by <= 127) {
                    n4 = 0;
                    while (true) {
                        if (n4 >= by + 1) continue block2;
                        byArray2[n3++] = byArray[n2++];
                        ++n4;
                    }
                }
                if (by <= -1 && by >= -127) {
                    byte by2 = byArray[n2++];
                    n4 = 0;
                    while (true) {
                        if (n4 >= -by + 1) continue block2;
                        byArray2[n3++] = by2;
                        ++n4;
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void inflate(byte[] byArray, byte[] byArray2) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new ExceptionConverter(dataFormatException);
        }
    }
}

