/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.Utilities;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;

public class InputMeta {
    InputStream in;
    int length;

    public InputMeta(InputStream inputStream) {
        this.in = inputStream;
    }

    public int readWord() throws IOException {
        this.length += 2;
        int n2 = this.in.read();
        if (n2 < 0) {
            return 0;
        }
        return n2 + (this.in.read() << 8) & 0xFFFF;
    }

    public int readShort() throws IOException {
        int n2 = this.readWord();
        if (n2 > Short.MAX_VALUE) {
            n2 -= 65536;
        }
        return n2;
    }

    public int readInt() throws IOException {
        this.length += 4;
        int n2 = this.in.read();
        if (n2 < 0) {
            return 0;
        }
        int n3 = this.in.read() << 8;
        int n4 = this.in.read() << 16;
        return n2 + n3 + n4 + (this.in.read() << 24);
    }

    public int readByte() throws IOException {
        ++this.length;
        return this.in.read() & 0xFF;
    }

    public void skip(int n2) throws IOException {
        this.length += n2;
        Utilities.skip(this.in, n2);
    }

    public int getLength() {
        return this.length;
    }

    public Color readColor() throws IOException {
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        this.readByte();
        return new Color(n2, n3, n4);
    }
}

