/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.parser;

import in.gov.tds.beans.Form16Bean;
import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.util.BINDateComparator;
import in.gov.tds.util.DateFieldComparator;
import in.gov.tds.util.NumAmtToWordConverter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.table.DefaultTableModel;

public class Form16Parser {
    public static Form16Bean[] parse(String body, String footer, boolean withDigitalSignature) throws PDFCreationException {
        Form16Bean[] form16Bean = null;
        form16Bean = null;
        DefaultTableModel taxDedTableModel = null;
        DefaultTableModel binDedTableModel = null;
        DefaultTableModel cinDedTableModel = null;
        ArrayList<Object[]> taxDedDataList = null;
        ArrayList<Object[]> binDedDataList = null;
        ArrayList<Object[]> cinDedDataList = null;
        Object[] taxDedColumnNames = new String[]{"Quarter", "Reciept Numbers", "Tax Deducted", "Tax Deposited", "Status of Booking", "Amount Paid"};
        Object[] binDedColumnNames = new String[]{"Tax Deposited", "Receipt Numbers", "DDO Sequence Number", "Deposit Date", "Booking Status"};
        Object[] cinDedColumnNames = new String[]{"Tax Deposited", "BSR Code", "Deposit Date", "Challan Serial Number", "Booking Status"};
        String periodicity = "";
        String deducteePAN = "";
        String assessmentYear = "";
        StringBuffer assYearRange = null;
        String newLineString = null;
        String[] dataArray = null;
        String inputLineStr = null;
        String[] rowsData = null;
        ArrayList<String> quarterList = null;
        String periodFrom = null;
        String periodTo = null;
        String fromPeriod = null;
        String toPeriod = null;
        StringBuffer addressPart1 = null;
        StringBuffer addressPart2 = null;
        StringBuffer addressCIT1 = null;
        StringBuffer addressCIT2 = null;
        StringBuffer telNumber = null;
        String formattedUpdateDate = null;
        String verificationDate = null;
        String verifFullName = null;
        String[] splitSummary = null;
        String wordsTotalAmtDeposited = null;
        String wordsTotalAmtDeducted = null;
        String referenceNo = null;
        StringBuffer dedAdd1 = null;
        StringBuffer dedAdd2 = null;
        try {
            form16Bean = new Form16Bean[1];
            assYearRange = new StringBuffer();
            newLineString = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(footer);
            stringBuilder.append(newLineString);
            stringBuilder.append(body);
            String consoFile = stringBuilder.toString();
            int bigDecimalScale = 2;
            dataArray = consoFile.split("\\n");
            int arraySize = dataArray.length;
            int count = 0;
            while (count < arraySize) {
                inputLineStr = dataArray[count];
                rowsData = inputLineStr.split("\\^", -1);
                quarterList = new ArrayList<String>();
                if (rowsData.length >= 2) {
                    if (rowsData[0].equalsIgnoreCase("FH")) {
                        assessmentYear = rowsData[15];
                        if (assessmentYear != null) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
                            Date parsedYear = dateFormat.parse(assessmentYear);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(parsedYear);
                            calendar.add(1, 1);
                            Date nextYear = calendar.getTime();
                            String nextAssYear = dateFormat.format(nextYear);
                            assYearRange.append(assessmentYear);
                            assYearRange.append("-");
                            assYearRange.append(nextAssYear.charAt(2));
                            assYearRange.append(nextAssYear.charAt(3));
                        }
                        if (form16Bean[0] == null) {
                            form16Bean[0] = new Form16Bean();
                        }
                        addressPart1 = new StringBuffer();
                        addressPart2 = new StringBuffer();
                        telNumber = new StringBuffer();
                        boolean iscommaReq = false;
                        boolean iscommaReqAdd2 = false;
                        if (Form16Parser.isValidField(rowsData[4])) {
                            addressPart1.append(rowsData[4]);
                            iscommaReq = true;
                        }
                        if (Form16Parser.isValidField(rowsData[5])) {
                            if (iscommaReq) {
                                addressPart1.append(", ");
                            }
                            addressPart1.append(rowsData[5]);
                            iscommaReq = true;
                        }
                        if (Form16Parser.isValidField(rowsData[6])) {
                            if (iscommaReq) {
                                addressPart1.append(", ");
                            }
                            addressPart1.append(rowsData[6]);
                            iscommaReq = true;
                        }
                        if (!Form16Parser.isValidField(rowsData[7]) && !Form16Parser.isValidField(rowsData[8])) {
                            if (Form16Parser.isValidField(rowsData[10])) {
                                addressPart1.append(" - ");
                                addressPart1.append(rowsData[10]);
                            }
                        } else {
                            if (Form16Parser.isValidField(rowsData[7])) {
                                if (iscommaReq) {
                                    addressPart1.append(", ");
                                }
                                addressPart2.append(rowsData[7]);
                                iscommaReqAdd2 = true;
                            }
                            if (Form16Parser.isValidField(rowsData[8])) {
                                if (iscommaReqAdd2) {
                                    addressPart2.append(", ");
                                } else {
                                    addressPart1.append(", ");
                                }
                                addressPart2.append(rowsData[8]);
                                iscommaReqAdd2 = true;
                            }
                            if (Form16Parser.isValidField(rowsData[10])) {
                                addressPart2.append(" - ");
                                addressPart2.append(rowsData[10]);
                            }
                        }
                        if (Form16Parser.isValidField(rowsData[11])) {
                            telNumber.append("+(91)");
                            telNumber.append(rowsData[11]);
                        }
                        addressCIT1 = new StringBuffer();
                        addressCIT2 = new StringBuffer();
                        iscommaReq = false;
                        iscommaReqAdd2 = false;
                        if (Form16Parser.isValidField(rowsData[19])) {
                            addressCIT1.append(rowsData[19]);
                            iscommaReq = true;
                        }
                        if (Form16Parser.isValidField(rowsData[20])) {
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[20]);
                            iscommaReq = true;
                        }
                        if (Form16Parser.isValidField(rowsData[21])) {
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[21]);
                            iscommaReq = true;
                        }
                        if (Form16Parser.isValidField(rowsData[22])) {
                            if (iscommaReq) {
                                addressCIT1.append(", ");
                            }
                            addressCIT1.append(rowsData[22]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16Parser.isValidField(rowsData[23])) {
                            if (iscommaReqAdd2) {
                                addressCIT2.append(", ");
                            } else {
                                addressCIT1.append(", ");
                            }
                            addressCIT2.append(rowsData[23]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16Parser.isValidField(rowsData[24])) {
                            if (iscommaReqAdd2) {
                                addressCIT2.append(", ");
                            }
                            addressCIT2.append(rowsData[24]);
                            iscommaReqAdd2 = true;
                        }
                        if (Form16Parser.isValidField(rowsData[25])) {
                            if (iscommaReqAdd2) {
                                addressCIT2.append(" - ");
                            }
                            addressCIT2.append(rowsData[25]);
                            iscommaReqAdd2 = true;
                        }
                        form16Bean[0] = Form16Bean.fileHeader(form16Bean[0], rowsData[3], addressPart1.toString(), addressPart2.toString(), rowsData[9], telNumber.toString(), rowsData[12], rowsData[13], rowsData[14], assYearRange.toString(), rowsData[16], rowsData[18], addressCIT1.toString(), addressCIT2.toString(), fromPeriod, toPeriod, rowsData[28]);
                    } else if (rowsData[0].equalsIgnoreCase("FT")) {
                        Date lastUpdateDate = new Date();
                        formattedUpdateDate = "";
                        verificationDate = "";
                        verifFullName = rowsData[2];
                        if (lastUpdateDate != null) {
                            SimpleDateFormat finalDate = new SimpleDateFormat("dd-MMM-yyyy");
                            formattedUpdateDate = finalDate.format(lastUpdateDate);
                        }
                        if (form16Bean[0] == null) {
                            form16Bean[0] = new Form16Bean();
                        }
                        verificationDate = formattedUpdateDate;
                        form16Bean[0] = Form16Bean.verification(form16Bean[0], rowsData[2], rowsData[3], rowsData[4], rowsData[5], verificationDate, formattedUpdateDate, verifFullName);
                    } else if (rowsData[0].equalsIgnoreCase("SP")) {
                        boolean isDeducteeDetail = false;
                        BigDecimal totalAmt = new BigDecimal("0.00");
                        splitSummary = inputLineStr.split("\\\\\\\\");
                        int num = 0;
                        while (num < splitSummary.length) {
                            String[] splittedData = splitSummary[num].split("\\^", -1);
                            periodicity = splittedData[31].equalsIgnoreCase("3") ? "Q1" : (splittedData[31].equalsIgnoreCase("4") ? "Q2" : (splittedData[31].equalsIgnoreCase("5") ? "Q3" : (splittedData[31].equalsIgnoreCase("6") ? "Q4" : " ")));
                            if (!isDeducteeDetail) {
                                deducteePAN = splittedData[1];
                                if (form16Bean[0] == null) {
                                    form16Bean[0] = new Form16Bean();
                                }
                                NumAmtToWordConverter numToWords = new NumAmtToWordConverter();
                                wordsTotalAmtDeposited = numToWords.convert(splittedData[28]);
                                wordsTotalAmtDeducted = numToWords.convert(splittedData[29]);
                                dedAdd1 = new StringBuffer();
                                dedAdd2 = new StringBuffer();
                                boolean isDedComma = false;
                                if (Form16Parser.isValidField(splittedData[3])) {
                                    dedAdd1.append(splittedData[3]);
                                    isDedComma = true;
                                }
                                if (Form16Parser.isValidField(splittedData[4])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd1.append(splittedData[4]);
                                    isDedComma = true;
                                }
                                if (Form16Parser.isValidField(splittedData[5])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd1.append(splittedData[5]);
                                    isDedComma = true;
                                }
                                boolean isDedComma2 = false;
                                if (Form16Parser.isValidField(splittedData[6])) {
                                    if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd2.append(splittedData[6]);
                                    isDedComma2 = true;
                                }
                                if (Form16Parser.isValidField(splittedData[7])) {
                                    if (isDedComma2) {
                                        dedAdd2.append(", ");
                                    } else if (isDedComma) {
                                        dedAdd1.append(", ");
                                    }
                                    dedAdd2.append(splittedData[7]);
                                    isDedComma2 = true;
                                }
                                referenceNo = splittedData[32] != null ? splittedData[32] : "";
                                periodFrom = splittedData[33];
                                periodTo = splittedData[34];
                                fromPeriod = "";
                                toPeriod = "";
                                Calendar cal = Calendar.getInstance();
                                SimpleDateFormat finalDate = new SimpleDateFormat("dd-MMM-yyyy");
                                if (periodFrom != null && !"".equalsIgnoreCase(periodFrom)) {
                                    cal.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(periodFrom));
                                    fromPeriod = finalDate.format(cal.getTime());
                                }
                                if (periodTo != null && !"".equalsIgnoreCase(periodTo)) {
                                    cal.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(periodTo));
                                    toPeriod = finalDate.format(cal.getTime());
                                }
                                if (fromPeriod != null && !fromPeriod.isEmpty()) {
                                    form16Bean[0].setPeriodFrom(fromPeriod);
                                } else {
                                    form16Bean[0].setPeriodFrom("-");
                                }
                                if (toPeriod != null && !toPeriod.isEmpty()) {
                                    form16Bean[0].setPeriodTo(toPeriod);
                                } else {
                                    form16Bean[0].setPeriodTo("-");
                                }
                                form16Bean[0] = Form16Bean.deducteeDetails(form16Bean[0], splittedData[1], splittedData[2], dedAdd1.toString(), dedAdd2.toString(), splittedData[28], splittedData[29], wordsTotalAmtDeposited, wordsTotalAmtDeducted, splittedData[30], referenceNo, fromPeriod, toPeriod);
                                isDeducteeDetail = true;
                            }
                            boolean summationDone = false;
                            if (num + 1 < splitSummary.length) {
                                String[] splittedDataNext = splitSummary[num + 1].split("\\^", -1);
                                if (!splittedDataNext[31].equals(splittedData[31])) {
                                    summationDone = true;
                                } else {
                                    totalAmt = totalAmt.add(new BigDecimal(splittedData[8]));
                                }
                            }
                            if (num == splitSummary.length - 1) {
                                summationDone = true;
                            }
                            if (!quarterList.contains(periodicity) && summationDone) {
                                totalAmt = totalAmt.add(new BigDecimal(splittedData[8]));
                                if (taxDedDataList != null) {
                                    taxDedDataList.add(new Object[]{periodicity, splittedData[15], BigDecimal.valueOf(Double.parseDouble(splittedData[12])).setScale(bigDecimalScale), BigDecimal.valueOf(Double.parseDouble(splittedData[13])).setScale(bigDecimalScale), splittedData[11], totalAmt.setScale(bigDecimalScale), splittedData[11]});
                                } else {
                                    taxDedDataList = new ArrayList<Object[]>();
                                    taxDedDataList.add(new Object[]{periodicity, splittedData[15], BigDecimal.valueOf(Double.parseDouble(splittedData[12])).setScale(bigDecimalScale), BigDecimal.valueOf(Double.parseDouble(splittedData[13])).setScale(bigDecimalScale), splittedData[11], totalAmt.setScale(bigDecimalScale)});
                                }
                                totalAmt = totalAmt.multiply(new BigDecimal("0.00"));
                                quarterList.add(periodicity);
                            }
                            if (splittedData[27].equalsIgnoreCase("Y")) {
                                if (binDedDataList != null) {
                                    String taxDepDate = "";
                                    if (Form16Parser.isValidField(splittedData[20])) {
                                        taxDepDate = Form16Parser.getPatternDate(splittedData[20]);
                                    }
                                    if (splittedData[17].equalsIgnoreCase("") || splittedData[17] == null) {
                                        splittedData[17] = "0";
                                    }
                                    binDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[17])).setScale(bigDecimalScale), splittedData[18], splittedData[19], taxDepDate, splittedData[21]});
                                } else {
                                    binDedDataList = new ArrayList<Object[]>();
                                    String taxDepDate = "";
                                    if (Form16Parser.isValidField(splittedData[20])) {
                                        taxDepDate = Form16Parser.getPatternDate(splittedData[20]);
                                    }
                                    if (splittedData[17].equalsIgnoreCase("") || splittedData[17] == null) {
                                        splittedData[17] = "0";
                                    }
                                    binDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[17])).setScale(bigDecimalScale), splittedData[18], splittedData[19], taxDepDate, splittedData[21]});
                                }
                            } else if (splittedData[27].equalsIgnoreCase("N")) {
                                if (cinDedDataList != null) {
                                    String taxDepDate = "";
                                    taxDepDate = Form16Parser.isValidField(splittedData[25]) ? Form16Parser.getPatternDate(splittedData[25]) : "-";
                                    if (splittedData[22].equalsIgnoreCase("") || splittedData[22] == null) {
                                        splittedData[22] = "0.00";
                                    }
                                    if ((double)Float.parseFloat(splittedData[22]) == 0.0) {
                                        splittedData[23] = "-";
                                        splittedData[24] = "-";
                                    }
                                    cinDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[22])).setScale(bigDecimalScale), splittedData[23], taxDepDate, splittedData[24], splittedData[26]});
                                } else {
                                    cinDedDataList = new ArrayList<Object[]>();
                                    String taxDepDate = "";
                                    taxDepDate = Form16Parser.isValidField(splittedData[25]) ? Form16Parser.getPatternDate(splittedData[25]) : "-";
                                    if (splittedData[22].equalsIgnoreCase("") || splittedData[22] == null) {
                                        splittedData[22] = "0.00";
                                    }
                                    if ((double)Float.parseFloat(splittedData[22]) == 0.0) {
                                        splittedData[23] = "-";
                                        splittedData[24] = "-";
                                    }
                                    cinDedDataList.add(new Object[]{BigDecimal.valueOf(Double.parseDouble(splittedData[22])).setScale(bigDecimalScale), splittedData[23], taxDepDate, splittedData[24], splittedData[26]});
                                }
                            }
                            if (binDedDataList != null) {
                                Collections.sort(binDedDataList, new BINDateComparator());
                            }
                            if (cinDedDataList != null) {
                                Collections.sort(cinDedDataList, new DateFieldComparator());
                            }
                            if (taxDedDataList != null) {
                                Object[][] taxDedData = new Object[taxDedDataList.size()][];
                                int l2 = 0;
                                while (l2 < taxDedDataList.size()) {
                                    taxDedData[l2] = (Object[])taxDedDataList.get(l2);
                                    ++l2;
                                }
                                taxDedTableModel = new DefaultTableModel(taxDedData, taxDedColumnNames);
                                if (form16Bean[0] == null) {
                                    form16Bean[0] = new Form16Bean();
                                }
                                form16Bean[0] = Form16Bean.deductedTax(form16Bean[0], taxDedTableModel);
                            }
                            if (binDedDataList != null) {
                                Object[][] binDedData = new Object[binDedDataList.size()][];
                                int j2 = 0;
                                while (j2 < binDedDataList.size()) {
                                    binDedData[j2] = (Object[])binDedDataList.get(j2);
                                    ++j2;
                                }
                                binDedTableModel = new DefaultTableModel(binDedData, binDedColumnNames);
                                if (form16Bean[0] == null) {
                                    form16Bean[0] = new Form16Bean();
                                }
                                form16Bean[0] = Form16Bean.deductedTax_BIN(form16Bean[0], binDedTableModel);
                            }
                            if (cinDedDataList != null) {
                                Object[][] cinDedData = new Object[cinDedDataList.size()][];
                                int k2 = 0;
                                while (k2 < cinDedDataList.size()) {
                                    cinDedData[k2] = (Object[])cinDedDataList.get(k2);
                                    ++k2;
                                }
                                cinDedTableModel = new DefaultTableModel(cinDedData, cinDedColumnNames);
                                if (form16Bean[0] == null) {
                                    form16Bean[0] = new Form16Bean();
                                }
                                form16Bean[0] = Form16Bean.deductedTax_CIN(form16Bean[0], cinDedTableModel);
                            }
                            ++num;
                        }
                    }
                }
                ++count;
            }
            Form16Bean[] form16BeanArray = form16Bean;
            return form16BeanArray;
        }
        catch (ParseException pe) {
            throw new PDFCreationException("Error while converting date into other format");
        }
        finally {
            form16Bean = null;
            form16Bean = null;
            taxDedTableModel = null;
            binDedTableModel = null;
            cinDedTableModel = null;
            taxDedDataList = null;
            binDedDataList = null;
            cinDedDataList = null;
            taxDedColumnNames = null;
            binDedColumnNames = null;
            cinDedColumnNames = null;
            periodicity = null;
            deducteePAN = null;
            assessmentYear = null;
            assYearRange = null;
            newLineString = null;
            dataArray = null;
            inputLineStr = null;
            rowsData = null;
            quarterList = null;
            periodFrom = null;
            periodTo = null;
            fromPeriod = null;
            toPeriod = null;
            addressPart1 = null;
            addressPart2 = null;
            addressCIT1 = null;
            addressCIT2 = null;
            formattedUpdateDate = null;
            verificationDate = null;
            verifFullName = null;
            splitSummary = null;
            wordsTotalAmtDeposited = null;
            wordsTotalAmtDeducted = null;
            dedAdd1 = null;
            dedAdd2 = null;
            referenceNo = null;
        }
    }

    private static String getPatternDate(String orginalFormatDate) {
        String convertedDate = "";
        String[] splitDate = orginalFormatDate.split("-");
        int days = Integer.parseInt(splitDate[2]);
        int month = Integer.parseInt(splitDate[1]) - 1;
        int year = Integer.parseInt(splitDate[0]);
        GregorianCalendar dateConverted = new GregorianCalendar(year, month, days);
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
        fmt.setCalendar(dateConverted);
        convertedDate = fmt.format(dateConverted.getTime());
        return convertedDate;
    }

    private static boolean isValidField(String field) {
        boolean isValidField = false;
        if (field != null && !field.trim().isEmpty() && !field.trim().equals("-")) {
            isValidField = true;
        }
        return isValidField;
    }
}

