/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ByteArrayValues;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.IntArrayValues;
import net.sf.jasperreports.data.cache.LongArrayValues;
import net.sf.jasperreports.data.cache.ShortArrayValues;
import net.sf.jasperreports.data.cache.ValueLength;

public class NumberValuesUtils {
    private static final NumberValuesUtils INSTANCE = new NumberValuesUtils();

    public static NumberValuesUtils instance() {
        return INSTANCE;
    }

    protected NumberValuesUtils() {
    }

    public ColumnValues toValues(int count, long[] values, ValueLength valueLength, long linearFactor, long linearOffset) {
        ColumnValues colValues;
        switch (valueLength) {
            case BYTE: {
                colValues = this.toByteValues(count, values, linearFactor, linearOffset);
                break;
            }
            case SHORT: {
                colValues = this.toShortValues(count, values, linearFactor, linearOffset);
                break;
            }
            case INT: {
                colValues = this.toIntValues(count, values, linearFactor, linearOffset);
                break;
            }
            default: {
                colValues = this.toLongValues(count, values, linearFactor, linearOffset);
            }
        }
        return colValues;
    }

    protected ColumnValues toByteValues(int count, long[] values, long linearFactor, long linearOffset) {
        byte[] byteValues = new byte[count];
        for (int i2 = 0; i2 < count; ++i2) {
            byteValues[i2] = (byte)(values[i2] & 0xFFL);
        }
        return new ByteArrayValues(byteValues, linearFactor, linearOffset);
    }

    protected ColumnValues toShortValues(int count, long[] values, long linearFactor, long linearOffset) {
        short[] shortValues = new short[count];
        for (int i2 = 0; i2 < count; ++i2) {
            shortValues[i2] = (short)(values[i2] & 0xFFFFL);
        }
        return new ShortArrayValues(shortValues, linearFactor, linearOffset);
    }

    protected ColumnValues toIntValues(int count, long[] values, long linearFactor, long linearOffset) {
        int[] intValues = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            intValues[i2] = (int)(values[i2] & 0xFFFFFFFFL);
        }
        return new IntArrayValues(intValues, linearFactor, linearOffset);
    }

    protected ColumnValues toLongValues(int count, long[] values, long linearFactor, long linearOffset) {
        long[] longValues = new long[count];
        System.arraycopy(values, 0, longValues, 0, count);
        return new LongArrayValues(longValues, linearFactor, linearOffset);
    }
}

