/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.IndexColumnValueIterator;

public class ShortArrayValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private short[] values;
    private long linearFactor;
    private long linearOffset;

    public ShortArrayValues(short[] values, long linearFactor, long linearOffset) {
        this.values = values;
        this.linearFactor = linearFactor;
        this.linearOffset = linearOffset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.linearFactor);
        out.writeLong(this.linearOffset);
        out.writeInt(this.values.length);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            out.writeShort(this.values[i2]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.linearFactor = in.readLong();
        this.linearOffset = in.readLong();
        int size = in.readInt();
        this.values = new short[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.values[i2] = in.readShort();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    extends IndexColumnValueIterator {
        public ValuesIterator() {
            super(ShortArrayValues.this.values.length);
        }

        @Override
        public Object get() {
            return (long)(ShortArrayValues.this.values[this.currentIndex] & 0xFFFF) * ShortArrayValues.this.linearFactor + ShortArrayValues.this.linearOffset;
        }
    }
}

