/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xls;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsDataSource;

public class XlsDataAdapterService
extends AbstractDataAdapterService {
    public XlsDataAdapterService(JasperReportsContext jasperReportsContext, XlsDataAdapter xlsDataAdapter) {
        super(jasperReportsContext, xlsDataAdapter);
    }

    public XlsDataAdapterService(XlsDataAdapter xlsDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), xlsDataAdapter);
    }

    public XlsDataAdapter getXlsDataAdapter() {
        return (XlsDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsDataAdapter xlsDataAdapter = this.getXlsDataAdapter();
        if (xlsDataAdapter != null) {
            try {
                String datePattern = xlsDataAdapter.getDatePattern();
                String numberPattern = xlsDataAdapter.getNumberPattern();
                if (xlsDataAdapter.isQueryExecuterMode()) {
                    parameters.put("net.sf.jasperreports.xls.source", xlsDataAdapter.getFileName());
                    if (datePattern != null && datePattern.length() > 0) {
                        parameters.put("XLS_DATE_FORMAT", new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        parameters.put("XLS_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                    }
                    parameters.put("XLS_USE_FIRST_ROW_AS_HEADER", new Boolean(xlsDataAdapter.isUseFirstRowAsHeader()));
                    if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsDataAdapter, names, indexes);
                        parameters.put("XLS_COLUMN_NAMES_ARRAY", names);
                        parameters.put("XLS_COLUMN_INDEXES_ARRAY", indexes);
                    }
                } else {
                    JRXlsDataSource ds = new JRXlsDataSource(this.getJasperReportsContext(), xlsDataAdapter.getFileName());
                    if (datePattern != null && datePattern.length() > 0) {
                        ds.setDateFormat(new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        ds.setNumberFormat(new DecimalFormat(numberPattern));
                    }
                    ds.setUseFirstRowAsHeader(xlsDataAdapter.isUseFirstRowAsHeader());
                    if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsDataAdapter, names, indexes);
                        ds.setColumnNames(names, indexes);
                    }
                    parameters.put("REPORT_DATA_SOURCE", ds);
                }
            }
            catch (IOException e2) {
                throw new JRException(e2);
            }
        }
    }

    private void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, int[] indexes) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = "" + xlsDataAdapter.getColumnNames().get(i2);
            indexes[i2] = xlsDataAdapter.getColumnIndexes().size() > i2 ? xlsDataAdapter.getColumnIndexes().get(i2) : i2;
        }
    }
}

