/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    public static final String CURRENT_BEAN_MAPPING = "_THIS";
    protected PropertyNameProvider propertyNameProvider;
    protected static final PropertyNameProvider FIELD_NAME_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        @Override
        public String getPropertyName(JRField field) {
            return field.getName();
        }
    };
    protected static final PropertyNameProvider FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        @Override
        public String getPropertyName(JRField field) {
            if (field.getDescription() == null) {
                return field.getName();
            }
            return field.getDescription();
        }
    };

    public JRAbstractBeanDataSource(boolean isUseFieldDescription) {
        this.propertyNameProvider = isUseFieldDescription ? FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER : FIELD_NAME_PROPERTY_NAME_PROVIDER;
    }

    protected Object getFieldValue(Object bean, JRField field) throws JRException {
        return JRAbstractBeanDataSource.getBeanProperty(bean, this.getPropertyName(field));
    }

    protected static Object getBeanProperty(Object bean, String propertyName) throws JRException {
        Object value;
        block8: {
            value = null;
            if (JRAbstractBeanDataSource.isCurrentBeanMapping(propertyName)) {
                value = bean;
            } else if (bean != null) {
                try {
                    value = PropertyUtils.getProperty(bean, propertyName);
                }
                catch (IllegalAccessException e2) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e2);
                }
                catch (InvocationTargetException e3) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e3);
                }
                catch (NoSuchMethodException e4) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e4);
                }
                catch (IllegalArgumentException e5) {
                    if (e5.getMessage().startsWith("Null property value for ")) break block8;
                    throw e5;
                }
            }
        }
        return value;
    }

    protected static boolean isCurrentBeanMapping(String propertyName) {
        return CURRENT_BEAN_MAPPING.equals(propertyName);
    }

    protected String getPropertyName(JRField field) {
        return this.propertyNameProvider.getPropertyName(field);
    }

    static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

