/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

final class JRLongVarianceIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongVarianceIncrementer mainInstance = new JRLongVarianceIncrementer();

    private JRLongVarianceIncrementer() {
    }

    public static JRLongVarianceIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRLongIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)0));
        Number sumValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)1));
        return new Long((countValue.longValue() - 1L) * value.longValue() / countValue.longValue() + (sumValue.longValue() / countValue.longValue() - newValue.longValue()) * (sumValue.longValue() / countValue.longValue() - newValue.longValue()) / (countValue.longValue() - 1L));
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        if (calculableValue.getValue() == null) {
            if (calculable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            return new Long(((Number)calculableValue.getIncrementedValue()).longValue());
        }
        double v1 = value.doubleValue();
        double c1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)0))).doubleValue();
        double s1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)1))).doubleValue();
        double v2 = ((Number)calculableValue.getIncrementedValue()).doubleValue();
        double c2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)0))).doubleValue();
        double s2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)1))).doubleValue();
        double c3 = (c1 -= c2) + c2;
        return new Long((long)(c1 / c3 * v1 + c2 / c3 * v2 + c2 / c1 * (s1 -= s2) / c3 * s1 / c3 + c1 / c2 * s2 / c3 * s2 / c3 - 2.0 * s1 / c3 * s2 / c3));
    }

    @Override
    public Object initialValue() {
        return JRLongIncrementerFactory.ZERO;
    }
}

