/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Font;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.SimpleTextLine;
import net.sf.jasperreports.engine.fill.TextLine;
import net.sf.jasperreports.engine.fill.TextLineWrapper;
import net.sf.jasperreports.engine.fill.TextMeasureContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTextLineWrapper
implements TextLineWrapper {
    public static final String PROPERTY_MEASURE_EXACT = "net.sf.jasperreports.measure.simple.text.exact";
    public static final String PROPERTY_ELEMENT_CACHE_SIZE = "net.sf.jasperreports.measure.simple.text.element.cache.size";
    public static final String MEASURE_EXACT_ALWAYS = "always";
    public static final String MEASURE_EXACT_MULTILINE = "multiline";
    private static final Log log = LogFactory.getLog(SimpleTextLineWrapper.class);
    protected static final int FONT_MIN_COUNT = 10;
    protected static final double FONT_SIZE_MIN_FACTOR = 0.1;
    protected static final double FONT_WIDTH_CHECK_FACTOR = 1.2;
    protected static final int NEXT_BREAK_INDEX_THRESHOLD = 3;
    protected static final int COMPEX_LAYOUT_START_CHAR = 768;
    protected static final int COMPEX_LAYOUT_END_CHAR = 8303;
    protected static final String FILL_CACHE_KEY_ELEMENT_FONT_INFOS = SimpleTextLineWrapper.class.getName() + "#elementFontInfos";
    protected static final String FILL_CACHE_KEY_GENERAL_FONT_INFOS = SimpleTextLineWrapper.class.getName() + "#generalFontInfos";
    protected static final Set<Character.UnicodeBlock> simpleLayoutBlocks = new HashSet<Character.UnicodeBlock>();
    private TextMeasureContext context;
    private boolean measureSimpleTexts;
    private boolean measureExact;
    private boolean measureExactMultiline;
    private Map<FontKey, ElementFontInfo> fontInfos;
    private String wholeText;
    private FontKey fontKey;
    private ElementFontInfo fontInfo;
    private String paragraphText;
    private boolean paragraphTruncateAtChar;
    private boolean paragraphLeftToRight;
    private boolean paragraphMeasureExact;
    private int paragraphOffset;
    private int paragraphPosition;
    private BreakIterator paragraphBreakIterator;

    public SimpleTextLineWrapper() {
    }

    public SimpleTextLineWrapper(SimpleTextLineWrapper parent) {
        this.context = parent.context;
        this.measureSimpleTexts = parent.measureSimpleTexts;
        this.measureExact = parent.measureExact;
        this.measureExactMultiline = parent.measureExactMultiline;
        this.fontInfos = parent.fontInfos;
        this.wholeText = parent.wholeText;
        this.fontKey = parent.fontKey;
        this.fontInfo = parent.fontInfo;
    }

    @Override
    public void init(TextMeasureContext context) {
        this.context = context;
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(context.getJasperReportsContext());
        this.measureSimpleTexts = properties.getBooleanProperty(context.getPropertiesHolder(), "net.sf.jasperreports.measure.simple.text", true);
        if (this.measureSimpleTexts) {
            String exactProp = properties.getProperty(context.getPropertiesHolder(), PROPERTY_MEASURE_EXACT);
            if (exactProp != null) {
                if (MEASURE_EXACT_ALWAYS.equals(exactProp)) {
                    this.measureExact = true;
                } else if (MEASURE_EXACT_MULTILINE.equals(exactProp)) {
                    this.measureExactMultiline = true;
                }
            }
            this.fontInfos = new HashMap<FontKey, ElementFontInfo>();
        }
    }

    @Override
    public boolean start(JRStyledText styledText) {
        Number weight;
        if (!this.measureSimpleTexts) {
            return false;
        }
        List<JRStyledText.Run> runs = styledText.getRuns();
        if (runs.size() != 1) {
            return false;
        }
        this.wholeText = styledText.getText();
        if (this.wholeText.indexOf(9) >= 0) {
            return false;
        }
        JRStyledText.Run run = styledText.getRuns().get(0);
        if (run.attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            return false;
        }
        String family = (String)run.attributes.get(TextAttribute.FAMILY);
        Number size = (Number)run.attributes.get(TextAttribute.SIZE);
        if (family == null || size == null) {
            return false;
        }
        int style = 0;
        Number posture = (Number)run.attributes.get(TextAttribute.POSTURE);
        if (posture != null && !TextAttribute.POSTURE_REGULAR.equals(posture)) {
            if (TextAttribute.POSTURE_OBLIQUE.equals(posture)) {
                style |= 2;
            } else {
                return false;
            }
        }
        if ((weight = (Number)run.attributes.get(TextAttribute.WEIGHT)) != null && !TextAttribute.WEIGHT_REGULAR.equals(weight)) {
            if (TextAttribute.WEIGHT_BOLD.equals(weight)) {
                style |= 1;
            } else {
                return false;
            }
        }
        this.fontKey = new FontKey(family, size.intValue(), style, styledText.getLocale());
        this.createFontInfo(run.attributes);
        return true;
    }

    protected void createFontInfo(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        this.fontInfo = this.fontInfos.get(this.fontKey);
        if (this.fontInfo != null) {
            return;
        }
        HashMap<Pair<UUID, FontKey>, ElementFontInfo> elementFontInfos = null;
        Pair<UUID, FontKey> elementFontKey = null;
        if (this.context.getElement() instanceof JRFillElement) {
            JRFillElement fillElement = (JRFillElement)((Object)this.context.getElement());
            JRFillContext fillContext = fillElement.getFiller().getFillContext();
            elementFontKey = new Pair<UUID, FontKey>(fillElement.getUUID(), this.fontKey);
            elementFontInfos = (HashMap<Pair<UUID, FontKey>, ElementFontInfo>)fillContext.getFillCache(FILL_CACHE_KEY_ELEMENT_FONT_INFOS);
            if (elementFontInfos == null) {
                elementFontInfos = this.createElementFontInfosFillCache();
                fillContext.setFillCache(FILL_CACHE_KEY_ELEMENT_FONT_INFOS, elementFontInfos);
            }
            this.fontInfo = (ElementFontInfo)elementFontInfos.get(elementFontKey);
        }
        if (this.fontInfo == null) {
            FontInfo generalFontInfo = this.getGeneralFontInfo(textAttributes);
            if (log.isTraceEnabled()) {
                log.trace("creating element font info for " + this.fontKey + (elementFontKey == null ? "" : " and element " + elementFontKey.first()));
            }
            this.fontInfo = new ElementFontInfo(generalFontInfo);
            this.fontInfos.put(this.fontKey, this.fontInfo);
            if (elementFontInfos != null && elementFontKey.first() != null) {
                elementFontInfos.put(elementFontKey, this.fontInfo);
            }
        }
    }

    protected HashMap<Pair<UUID, FontKey>, ElementFontInfo> createElementFontInfosFillCache() {
        final int cacheSize = JRPropertiesUtil.getInstance(this.context.getJasperReportsContext()).getIntegerProperty(PROPERTY_ELEMENT_CACHE_SIZE, 2000);
        if (log.isDebugEnabled()) {
            log.debug("creating element font infos cache of size " + cacheSize);
        }
        return new LinkedHashMap<Pair<UUID, FontKey>, ElementFontInfo>(64, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Pair<UUID, FontKey>, ElementFontInfo> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    protected FontInfo getGeneralFontInfo(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        HashMap<FontKey, FontInfo> generalFontInfos = null;
        FontInfo generalFontInfo = null;
        if (this.context.getElement() instanceof JRFillElement) {
            JRFillElement fillElement = (JRFillElement)((Object)this.context.getElement());
            JRFillContext fillContext = fillElement.getFiller().getFillContext();
            generalFontInfos = (HashMap<FontKey, FontInfo>)fillContext.getFillCache(FILL_CACHE_KEY_GENERAL_FONT_INFOS);
            if (generalFontInfos == null) {
                generalFontInfos = new HashMap<FontKey, FontInfo>();
                fillContext.setFillCache(FILL_CACHE_KEY_GENERAL_FONT_INFOS, generalFontInfos);
            }
            generalFontInfo = (FontInfo)generalFontInfos.get(this.fontKey);
        }
        if (generalFontInfo == null) {
            Font font = this.loadFont(textAttributes);
            boolean complexLayout = this.determineComplexLayout(font);
            float leading = this.determineLeading(font);
            if (log.isTraceEnabled()) {
                log.trace("font " + font + " has complex layout " + complexLayout + ", leading " + leading);
            }
            generalFontInfo = new FontInfo(font, complexLayout, leading);
            if (generalFontInfos != null) {
                generalFontInfos.put(this.fontKey, generalFontInfo);
            }
        }
        return generalFontInfo;
    }

    protected Font loadFont(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        FontUtil fontUtil = FontUtil.getInstance(this.context.getJasperReportsContext());
        Font font = fontUtil.getAwtFontFromBundles(this.fontKey.family, this.fontKey.style, this.fontKey.size, this.fontKey.locale, false);
        if (font == null) {
            fontUtil.checkAwtFont(this.fontKey.family, this.context.isIgnoreMissingFont());
            font = Font.getFont(textAttributes);
        }
        return font;
    }

    protected boolean determineComplexLayout(Font font) {
        Map<TextAttribute, ?> fontAttributes = font.getAttributes();
        Object kerning = fontAttributes.get(TextAttribute.KERNING);
        Object ligatures = fontAttributes.get(TextAttribute.LIGATURES);
        return kerning != null && TextAttribute.KERNING_ON.equals(kerning) || ligatures != null && TextAttribute.LIGATURES_ON.equals(ligatures) || font.isTransformed();
    }

    protected float determineLeading(Font font) {
        LineMetrics lineMetrics = font.getLineMetrics(" ", this.context.getFontRenderContext());
        return lineMetrics.getLeading();
    }

    @Override
    public void startParagraph(int paragraphStart, int paragraphEnd, boolean truncateAtChar) {
        String text = this.wholeText.substring(paragraphStart, paragraphEnd);
        this.startParagraph(text, paragraphStart, truncateAtChar);
    }

    @Override
    public void startEmptyParagraph(int paragraphStart) {
        this.startParagraph(" ", paragraphStart, false);
    }

    protected void startParagraph(String text, int start, boolean truncateAtChar) {
        this.paragraphText = text;
        this.paragraphTruncateAtChar = truncateAtChar;
        char[] textChars = text.toCharArray();
        this.paragraphLeftToRight = this.isLeftToRight(textChars);
        this.paragraphMeasureExact = this.isParagraphMeasureExact(textChars);
        if (log.isTraceEnabled()) {
            log.trace("paragraph start at " + start + ", truncate at char " + truncateAtChar + ", LTR " + this.paragraphLeftToRight + ", exact measure " + this.paragraphMeasureExact);
        }
        this.paragraphOffset = start;
        this.paragraphPosition = 0;
        this.paragraphBreakIterator = truncateAtChar ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
        this.paragraphBreakIterator.setText(this.paragraphText);
    }

    protected boolean isLeftToRight(char[] chars) {
        boolean leftToRight = true;
        if (Bidi.requiresBidi(chars, 0, chars.length)) {
            Bidi bidi = new Bidi(chars, 0, null, 0, chars.length, -2);
            leftToRight = bidi.baseIsLeftToRight();
        }
        return leftToRight;
    }

    protected boolean isParagraphMeasureExact(char[] chars) {
        if (this.measureExact || this.fontInfo.fontInfo.complexLayout || this.paragraphTruncateAtChar) {
            return true;
        }
        return this.hasComplexLayout(chars);
    }

    protected boolean hasComplexLayout(char[] chars) {
        Character.UnicodeBlock prevBlock = null;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char ch = chars[i2];
            if (ch < '\u0300' || ch > '\u206f') continue;
            Character.UnicodeBlock chBlock = Character.UnicodeBlock.of(ch);
            if (chBlock == null) {
                return true;
            }
            if (prevBlock == chBlock) continue;
            prevBlock = chBlock;
            if (simpleLayoutBlocks.contains(chBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int paragraphPosition() {
        return this.paragraphPosition;
    }

    @Override
    public int paragraphEnd() {
        return this.paragraphText.length();
    }

    @Override
    public TextLine nextLine(float width, int endLimit, boolean requireWord) {
        if (log.isTraceEnabled()) {
            log.trace("simple line measurement at " + (this.paragraphOffset + this.paragraphPosition) + " to " + (this.paragraphOffset + endLimit) + " in width " + width + " with font " + this.fontInfo);
        }
        TextLine textLine = this.useExactLineMeasurement() ? this.measureExactLine(width, endLimit, requireWord) : this.measureLine(width, requireWord, endLimit);
        return textLine;
    }

    protected boolean useExactLineMeasurement() {
        return this.paragraphMeasureExact || !this.fontInfo.hasCharWidthEstimate();
    }

    protected TextLine measureExactLine(float width, int endLimit, boolean requireWord) {
        int breakIndex = this.measureExactLineBreakIndex(width, endLimit, requireWord);
        if (breakIndex <= this.paragraphPosition) {
            return null;
        }
        Rectangle2D lineBounds = this.measureParagraphFragment(breakIndex);
        return this.toTextLine(breakIndex, lineBounds);
    }

    protected int measureExactLineBreakIndex(float width, int endLimit, boolean requireWord) {
        HashMap<TextAttribute, Font> attributes = new HashMap<TextAttribute, Font>();
        attributes.put(TextAttribute.FONT, this.fontInfo.fontInfo.font);
        String textLine = this.paragraphText.substring(this.paragraphPosition, endLimit);
        AttributedString attributedLine = new AttributedString(textLine, attributes);
        BreakIterator breakIterator = this.paragraphTruncateAtChar ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
        LineBreakMeasurer breakMeasurer = new LineBreakMeasurer(attributedLine.getIterator(), breakIterator, this.context.getFontRenderContext());
        int breakIndex = breakMeasurer.nextOffset(width, endLimit - this.paragraphPosition, requireWord) + this.paragraphPosition;
        if (log.isTraceEnabled()) {
            log.trace("exact line break index measured at " + (this.paragraphOffset + breakIndex));
        }
        return breakIndex;
    }

    protected TextLine measureLine(float width, boolean requireWord, int endLimit) {
        Rectangle2D bounds;
        int measureIndex = this.estimateBreakIndex(width, endLimit);
        if (measureIndex < endLimit && this.measureExactMultiline) {
            return this.measureExactLine(width, endLimit, requireWord);
        }
        Rectangle2D measuredBounds = bounds = this.measureParagraphFragment(measureIndex);
        if (bounds.getWidth() <= (double)width) {
            boolean done = false;
            do {
                int nextBreakIndex;
                int n2 = nextBreakIndex = measureIndex < endLimit ? this.paragraphBreakIterator.following(measureIndex) : -1;
                if (nextBreakIndex == -1 || nextBreakIndex > endLimit) {
                    done = true;
                    continue;
                }
                Rectangle2D nextBounds = this.measureParagraphFragment(nextBreakIndex);
                if (nextBounds.getWidth() <= (double)width) {
                    measuredBounds = nextBounds;
                    measureIndex = nextBreakIndex;
                    continue;
                }
                done = true;
            } while (!done);
        } else {
            boolean done = false;
            do {
                int previousBreakIndex;
                int n3 = previousBreakIndex = measureIndex > this.paragraphPosition ? this.paragraphBreakIterator.preceding(measureIndex) : -1;
                if (previousBreakIndex == -1 || previousBreakIndex <= this.paragraphPosition) {
                    if (requireWord) {
                        measureIndex = this.paragraphPosition;
                    } else {
                        measureIndex = this.measureExactLineBreakIndex(width, endLimit, requireWord);
                        measuredBounds = this.measureParagraphFragment(measureIndex);
                    }
                    done = true;
                    continue;
                }
                measureIndex = previousBreakIndex;
                Rectangle2D prevBounds = this.measureParagraphFragment(measureIndex);
                if (!(prevBounds.getWidth() <= (double)width)) continue;
                measuredBounds = prevBounds;
                done = true;
            } while (!done);
        }
        if (measureIndex <= this.paragraphPosition) {
            return null;
        }
        return this.toTextLine(measureIndex, measuredBounds);
    }

    protected int estimateBreakIndex(float width, int endLimit) {
        int breakBeforeEstimatePosition;
        double avgCharWidth = this.fontInfo.charWidthEstimate();
        if ((double)(endLimit - this.paragraphPosition) * avgCharWidth <= (double)width * 1.2) {
            return endLimit;
        }
        int charCountEstimate = (int)Math.ceil((double)width / avgCharWidth);
        int estimateFitPosition = this.paragraphPosition + charCountEstimate;
        if (estimateFitPosition > endLimit) {
            return endLimit;
        }
        int breakAfterEstimatePosition = this.paragraphBreakIterator.following(estimateFitPosition);
        if (breakAfterEstimatePosition == -1 || breakAfterEstimatePosition > endLimit) {
            breakAfterEstimatePosition = endLimit;
        }
        int estimateIndex = breakAfterEstimatePosition;
        if (breakAfterEstimatePosition > estimateFitPosition + 3 && (breakBeforeEstimatePosition = this.paragraphBreakIterator.previous()) == -1 && breakBeforeEstimatePosition > this.paragraphPosition && estimateFitPosition - breakBeforeEstimatePosition < breakAfterEstimatePosition - estimateFitPosition) {
            estimateIndex = breakBeforeEstimatePosition;
        }
        return estimateIndex;
    }

    protected Rectangle2D measureParagraphFragment(int measureIndex) {
        char lastMeasureChar;
        int endIndex = measureIndex;
        if (endIndex > this.paragraphPosition + 1 && Character.isWhitespace(lastMeasureChar = this.paragraphText.charAt(endIndex - 1))) {
            int preceding = this.paragraphBreakIterator.preceding(endIndex);
            if (preceding == -1 || preceding <= this.paragraphPosition) {
                preceding = this.paragraphPosition + 1;
            }
            do {
                lastMeasureChar = this.paragraphText.charAt(--endIndex - 1);
            } while (endIndex > preceding && Character.isWhitespace(lastMeasureChar));
        }
        Rectangle2D bounds = this.fontInfo.fontInfo.font.getStringBounds(this.paragraphText, this.paragraphPosition, endIndex, this.context.getFontRenderContext());
        this.fontInfo.recordMeasurement(bounds.getWidth() / (double)(endIndex - this.paragraphPosition));
        if (log.isTraceEnabled()) {
            log.trace("measured to index " + (endIndex + this.paragraphOffset) + " at width " + bounds.getWidth());
        }
        return bounds;
    }

    protected TextLine toTextLine(int measureIndex, Rectangle2D measuredBounds) {
        SimpleTextLine textLine = new SimpleTextLine();
        textLine.setAscent((float)(-measuredBounds.getY()));
        textLine.setDescent((float)(measuredBounds.getMaxY() - (double)this.fontInfo.fontInfo.leading));
        textLine.setLeading(this.fontInfo.fontInfo.leading);
        textLine.setCharacterCount(measureIndex - this.paragraphPosition);
        textLine.setAdvance((float)measuredBounds.getWidth());
        textLine.setLeftToRight(this.paragraphLeftToRight);
        this.paragraphPosition = measureIndex;
        return textLine;
    }

    @Override
    public TextLine baseTextLine(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int maxFontSize(int start, int end) {
        return this.fontKey.size;
    }

    @Override
    public String getLineText(int start, int end) {
        int newLineIdx = this.wholeText.indexOf(10, start);
        int endIdx = newLineIdx >= 0 && newLineIdx < end ? newLineIdx : end;
        return this.wholeText.substring(start, endIdx);
    }

    @Override
    public char charAt(int index) {
        return this.wholeText.charAt(index);
    }

    @Override
    public TextLineWrapper lastLineWrapper(String lineText, int start, int textLength, boolean truncateAtChar) {
        if (log.isTraceEnabled()) {
            log.trace("last line wrapper at " + start + ", textLength " + textLength);
        }
        SimpleTextLineWrapper lastLineWrapper = new SimpleTextLineWrapper(this);
        lastLineWrapper.startParagraph(lineText, start, truncateAtChar);
        return lastLineWrapper;
    }

    static {
        simpleLayoutBlocks.add(Character.UnicodeBlock.GREEK);
        simpleLayoutBlocks.add(Character.UnicodeBlock.CYRILLIC);
        simpleLayoutBlocks.add(Character.UnicodeBlock.CYRILLIC_SUPPLEMENTARY);
        simpleLayoutBlocks.add(Character.UnicodeBlock.ARMENIAN);
        simpleLayoutBlocks.add(Character.UnicodeBlock.SYRIAC);
        simpleLayoutBlocks.add(Character.UnicodeBlock.THAANA);
        simpleLayoutBlocks.add(Character.UnicodeBlock.MYANMAR);
        simpleLayoutBlocks.add(Character.UnicodeBlock.GEORGIAN);
        simpleLayoutBlocks.add(Character.UnicodeBlock.ETHIOPIC);
        simpleLayoutBlocks.add(Character.UnicodeBlock.TAGALOG);
        simpleLayoutBlocks.add(Character.UnicodeBlock.MONGOLIAN);
        simpleLayoutBlocks.add(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL);
        simpleLayoutBlocks.add(Character.UnicodeBlock.GREEK_EXTENDED);
    }

    protected static class ElementFontInfo {
        final FontInfo fontInfo;
        final FontStatistics fontStatistics;

        public ElementFontInfo(FontInfo fontInfo) {
            this.fontInfo = fontInfo;
            this.fontStatistics = new FontStatistics();
        }

        public boolean hasCharWidthEstimate() {
            return this.fontStatistics.measurementsCount > 0 || this.fontInfo.fontStatistics.measurementsCount > 0;
        }

        public double charWidthEstimate() {
            double avgCharWidth;
            if (this.fontStatistics.measurementsCount > 0) {
                avgCharWidth = this.fontStatistics.characterWidthSum / (double)this.fontStatistics.measurementsCount;
            } else if (this.fontInfo.fontStatistics.measurementsCount > 0) {
                avgCharWidth = this.fontInfo.fontStatistics.characterWidthSum / (double)this.fontInfo.fontStatistics.measurementsCount;
            } else {
                throw new IllegalStateException("No measurement available for char width estimate");
            }
            return avgCharWidth;
        }

        public void recordMeasurement(double avgWidth) {
            this.fontStatistics.recordMeasurement(avgWidth);
            this.fontInfo.fontStatistics.recordMeasurement(avgWidth);
        }

        public String toString() {
            return this.fontInfo.font.toString();
        }
    }

    protected static class FontStatistics {
        int measurementsCount;
        double characterWidthSum;

        protected FontStatistics() {
        }

        public void recordMeasurement(double avgWidth) {
            ++this.measurementsCount;
            this.characterWidthSum += avgWidth;
        }
    }

    protected static class FontInfo {
        final Font font;
        final boolean complexLayout;
        final float leading;
        final FontStatistics fontStatistics;

        public FontInfo(Font font, boolean complexLayout, float leading) {
            this.font = font;
            this.complexLayout = complexLayout;
            this.leading = leading;
            this.fontStatistics = new FontStatistics();
        }

        public String toString() {
            return this.font.toString();
        }
    }

    protected static class FontKey {
        String family;
        int size;
        int style;
        Locale locale;

        public FontKey(String family, int size, int style, Locale locale) {
            this.family = family;
            this.size = size;
            this.style = style;
            this.locale = locale;
        }

        public int hashCode() {
            int hash = 43;
            hash = hash * 29 + this.family.hashCode();
            hash = hash * 29 + this.size;
            hash = hash * 29 + this.style;
            hash = hash * 29 + (this.locale == null ? 0 : this.locale.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            FontKey info = (FontKey)obj;
            return this.family.equals(info.family) && this.size == info.size && this.style == info.style && (this.locale == null ? info.locale == null : info.locale != null && this.locale.equals(info.locale));
        }

        public String toString() {
            return "{family: " + this.family + ", size: " + this.size + ", style: " + this.style + "}";
        }
    }
}

