/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.VirtualizerStore;

public class StoreVirtualizer
extends JRAbstractLRUVirtualizer {
    private final VirtualizerStore store;

    public StoreVirtualizer(int maxSize, VirtualizerStore store) {
        super(maxSize);
        this.store = store;
    }

    @Override
    protected void pageOut(JRVirtualizable o2) throws IOException {
        boolean stored = this.store.store(o2, this.serializer);
        if (!stored && !this.isReadOnly(o2)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o2.getUID() + "\" already exists.");
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o2) throws IOException {
        this.store.retrieve(o2, !this.isReadOnly(o2), this.serializer);
    }

    @Override
    protected void dispose(String id) {
        this.store.remove(id);
    }

    @Override
    public void cleanup() {
        this.store.dispose();
    }
}

