/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.repo.RepositoryUtil;

public class SimpleFontFace
implements FontFace {
    private String file;
    private Font font;

    public static SimpleFontFace getInstance(JasperReportsContext jasperReportsContext, String fontName) {
        SimpleFontFace fontFace = null;
        if (fontName != null) {
            if (fontName.trim().toUpperCase().endsWith(".TTF")) {
                fontFace = new SimpleFontFace(fontName);
            } else {
                FontUtil.getInstance(jasperReportsContext).checkAwtFont(fontName, JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
                fontFace = new SimpleFontFace(new Font(fontName, 0, JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.default.font.size")));
            }
        }
        return fontFace;
    }

    public SimpleFontFace(JasperReportsContext jasperReportsContext, String file) {
        this.file = file;
        InputStream is = null;
        try {
            is = RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(file);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        try {
            this.font = Font.createFont(0, is);
        }
        catch (FontFormatException e3) {
            throw new JRRuntimeException(e3);
        }
        catch (IOException e4) {
            throw new JRRuntimeException(e4);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e5) {}
        }
    }

    public SimpleFontFace(String file) {
        this(DefaultJasperReportsContext.getInstance(), file);
    }

    public SimpleFontFace(Font font) {
        this.font = font;
    }

    @Override
    public String getName() {
        return this.font.getName();
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

