/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public class JRSingletonCache<T> {
    private static final Object CONTEXT_KEY_NULL = new Object();
    private final ReferenceMap cache = new ReferenceMap(2, 1);
    private final Class<T> itf;

    public JRSingletonCache(Class<T> itf) {
        this.itf = itf;
    }

    public synchronized T getCachedInstance(String className) throws JRException {
        Map<String, T> contextCache = this.getContextInstanceCache();
        T instance = contextCache.get(className);
        if (instance == null) {
            instance = this.createInstance(className);
            contextCache.put(className, instance);
        }
        return instance;
    }

    protected T createInstance(String className) throws JRException {
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(className);
            if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                throw new JRException("Class \"" + className + "\" should be compatible with \"" + this.itf.getName() + "\"");
            }
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new JRException("Class " + className + " not found.", e2);
        }
        catch (InstantiationException e3) {
            throw new JRException("Error instantiating class " + className + ".", e3);
        }
        catch (IllegalAccessException e4) {
            throw new JRException("Error instantiating class " + className + ".", e4);
        }
    }

    protected Map<String, T> getContextInstanceCache() {
        Object contextKey = this.getContextKey();
        Map contextCache = (Map)this.cache.get(contextKey);
        if (contextCache == null) {
            contextCache = new ReferenceMap();
            this.cache.put(contextKey, contextCache);
        }
        return contextCache;
    }

    protected Object getContextKey() {
        Object key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            key = CONTEXT_KEY_NULL;
        }
        return key;
    }
}

