/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class BatikRenderer
extends JRAbstractSvgRenderer
implements ImageMapRenderable {
    private static final long serialVersionUID = 10200L;
    private String svgText;
    private byte[] svgData;
    private String svgDataLocation;
    private List<JRPrintImageAreaHyperlink> areaHyperlinks;
    private int minDPI;
    private boolean antiAlias;
    private transient GraphicsNode rootNode;
    private transient Dimension2D documentSize;

    protected BatikRenderer(List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.areaHyperlinks = areaHyperlinks;
    }

    public BatikRenderer(String svgText, List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.svgText = svgText;
        this.areaHyperlinks = areaHyperlinks;
    }

    public BatikRenderer(byte[] svgData, List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.svgData = svgData;
        this.areaHyperlinks = areaHyperlinks;
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.ensureSvg();
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform((float[])new float[]{0.0f, 0.0f, (float)this.documentSize.getWidth(), (float)this.documentSize.getHeight()}, (short)1, (boolean)true, (float)((float)rectangle.getWidth()), (float)((float)rectangle.getHeight()));
        Graphics2D graphics = (Graphics2D)grx.create();
        graphics.translate(rectangle.getX(), rectangle.getY());
        graphics.transform(transform);
        GraphicsNode graphicsNode = this.rootNode;
        synchronized (graphicsNode) {
            this.rootNode.paint(graphics);
        }
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        try {
            this.ensureSvg();
            return this.documentSize;
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    @Override
    public Dimension2D getDimension() {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    protected synchronized void ensureData(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.svgText == null && this.svgData == null && this.svgDataLocation != null) {
            this.svgData = RepositoryUtil.getInstance(jasperReportsContext).getBytesFromLocation(this.svgDataLocation);
        }
    }

    protected synchronized void ensureData() throws JRException {
        this.ensureData(DefaultJasperReportsContext.getInstance());
    }

    protected synchronized void ensureSvg(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.rootNode != null) {
            return;
        }
        this.ensureData();
        try {
            JRUserAgent userAgent = new JRUserAgent();
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
            documentFactory.setValidating(userAgent.isXMLParserValidating());
            SVGDocument document = this.svgText != null ? documentFactory.createSVGDocument(null, (Reader)new StringReader(this.svgText)) : documentFactory.createSVGDocument(null, (InputStream)new ByteArrayInputStream(this.svgData));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            this.rootNode = builder.build(ctx, (Document)document);
            this.documentSize = ctx.getDocumentSize();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    protected synchronized void ensureSvg() throws JRException {
        this.ensureSvg(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public List<JRPrintImageAreaHyperlink> renderWithHyperlinks(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(grx, rectangle);
        return this.areaHyperlinks;
    }

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinks != null && !this.areaHyperlinks.isEmpty();
    }

    @Override
    protected Graphics2D createGraphics(BufferedImage bi) {
        Graphics2D graphics = GraphicsUtil.createGraphics((BufferedImage)bi);
        if (this.antiAlias) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics;
    }

    protected void setSvgDataLocation(String svgDataLocation) {
        this.svgDataLocation = svgDataLocation;
    }

    public static BatikRenderer getInstance(byte[] svgData) {
        return new BatikRenderer(svgData, null);
    }

    public static BatikRenderer getInstance(InputStream svgDataStream) throws JRException {
        byte[] data = JRLoader.loadBytes(svgDataStream);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstance(File svgFile) throws JRException {
        byte[] data = JRLoader.loadBytes(svgFile);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstance(URL svgURL) throws JRException {
        byte[] data = JRLoader.loadBytes(svgURL);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstanceFromText(String svgText) throws JRException {
        return new BatikRenderer(svgText, null);
    }

    public static BatikRenderer getInstanceFromLocation(String location) throws JRException {
        return BatikRenderer.getInstanceFromLocation(DefaultJasperReportsContext.getInstance(), location);
    }

    public static BatikRenderer getInstanceFromLocation(JasperReportsContext jasperReportsContext, String location) throws JRException {
        byte[] data = RepositoryUtil.getInstance(jasperReportsContext).getBytesFromLocation(location);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstanceFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        byte[] data = JRLoader.loadBytesFromLocation(location, classLoader, urlHandlerFactory, fileResolver);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getLocationInstance(String location) throws JRException {
        BatikRenderer renderer = new BatikRenderer(null);
        renderer.setSvgDataLocation(location);
        return renderer;
    }

    @Override
    protected int getImageDataDPI(JasperReportsContext jasperReportsContext) {
        int dpi = super.getImageDataDPI(jasperReportsContext);
        if (this.minDPI > 0 && dpi < this.minDPI) {
            dpi = this.minDPI;
        }
        return dpi;
    }

    public int getMinDPI() {
        return this.minDPI;
    }

    public void setMinDPI(int minDPI) {
        this.minDPI = minDPI;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    protected static class JRUserAgent
    extends UserAgentAdapter {
        protected JRUserAgent() {
        }

        public float getPixelUnitToMillimeter() {
            return 0.35277778f;
        }
    }
}

