/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DefiniteLengthInputStream;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private static final DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };
    boolean eofFound = false;
    int limit = Integer.MAX_VALUE;

    public ASN1InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(InputStream inputStream, int n2) {
        super(inputStream);
        this.limit = n2;
    }

    protected int readLength() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.read();
                if (n4 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
            if (n2 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n2 >= this.limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n2;
    }

    protected void readFully(byte[] byArray) throws IOException {
        int n2;
        int n3 = byArray.length;
        if (n3 == 0) {
            return;
        }
        while ((n2 = this.read(byArray, byArray.length - n3, n3)) > 0) {
            if ((n3 -= n2) != 0) continue;
            return;
        }
        if (n3 != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int n2, int n3, int n4) throws IOException {
        boolean bl;
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(n3, this.readDefiniteLengthFully(n4));
        }
        boolean bl2 = bl = (n2 & 0x20) != 0;
        if (bl) {
            switch (n2) {
                case 48: {
                    return new DERSequence(this.buildDerEncodableVector(n4));
                }
                case 49: {
                    return new DERSet(this.buildDerEncodableVector(n4), false);
                }
                case 36: {
                    return this.buildDerConstructedOctetString(n4);
                }
            }
            if ((n2 & 0x80) != 0) {
                if (n4 == 0) {
                    return new DERTaggedObject(false, n3, new DERSequence());
                }
                ASN1EncodableVector aSN1EncodableVector = this.buildDerEncodableVector(n4);
                if (aSN1EncodableVector.size() == 1) {
                    return new DERTaggedObject(n3, aSN1EncodableVector.get(0));
                }
                return new DERTaggedObject(false, n3, new DERSequence(aSN1EncodableVector));
            }
            return new DERUnknownTag(n2, this.readDefiniteLengthFully(n4));
        }
        byte[] byArray = this.readDefiniteLengthFully(n4);
        switch (n2) {
            case 5: {
                return DERNull.INSTANCE;
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 18: {
                return new DERNumericString(byArray);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n2 & 0x80) != 0) {
            if (byArray.length == 0) {
                return new DERTaggedObject(false, n3, DERNull.INSTANCE);
            }
            return new DERTaggedObject(false, n3, new DEROctetString(byArray));
        }
        return new DERUnknownTag(n2, byArray);
    }

    private byte[] readDefiniteLengthFully(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return byArray;
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = this.read();
        while ((n2 = this.read()) >= 0 && (n3 != 0 || n2 != 0)) {
            byteArrayOutputStream.write(n3);
            n3 = n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString(DERObject dERObject) throws IOException {
        DERObject dERObject2;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject2 = this.readObject()) != dERObject) {
            vector.addElement(dERObject2);
        }
        return new BERConstructedOctetString(vector);
    }

    private BERConstructedOctetString buildDerConstructedOctetString(int n2) throws IOException {
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(definiteLengthInputStream, n2);
        return aSN1InputStream.buildConstructedOctetString(null);
    }

    private ASN1EncodableVector buildEncodableVector(DERObject dERObject) throws IOException {
        DERObject dERObject2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dERObject2 = this.readObject()) != dERObject) {
            aSN1EncodableVector.add(dERObject2);
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector buildDerEncodableVector(int n2) throws IOException {
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(definiteLengthInputStream, n2);
        return aSN1InputStream.buildEncodableVector(null);
    }

    public DERObject readObject() throws IOException {
        int n2;
        int n3 = this.read();
        if (n3 == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int n4 = 0;
        if ((n3 & 0x80) != 0 || (n3 & 0x40) != 0) {
            n4 = this.readTagNumber(n3);
        }
        if ((n2 = this.readLength()) < 0) {
            switch (n3) {
                case 5: {
                    return BERNull.INSTANCE;
                }
                case 48: {
                    return new BERSequence(this.buildEncodableVector(END_OF_STREAM));
                }
                case 49: {
                    return new BERSet(this.buildEncodableVector(END_OF_STREAM), false);
                }
                case 36: {
                    return this.buildConstructedOctetString(END_OF_STREAM);
                }
            }
            if ((n3 & 0x80) != 0) {
                if ((n3 & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n4, new DEROctetString(byArray));
                }
                ASN1EncodableVector aSN1EncodableVector = this.buildEncodableVector(END_OF_STREAM);
                if (aSN1EncodableVector.size() == 0) {
                    return new DERTaggedObject(n4);
                }
                if (aSN1EncodableVector.size() == 1) {
                    return new BERTaggedObject(n4, aSN1EncodableVector.get(0));
                }
                return new BERTaggedObject(false, n4, new BERSequence(aSN1EncodableVector));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n3 == 0 && n2 == 0) {
            return END_OF_STREAM;
        }
        return this.buildObject(n3, n4, n2);
    }

    private int readTagNumber(int n2) throws IOException {
        int n3 = n2 & 0x1F;
        if (n3 == 31) {
            int n4 = this.read();
            n3 = 0;
            while (n4 >= 0 && (n4 & 0x80) != 0) {
                n3 |= n4 & 0x7F;
                n3 <<= 7;
                n4 = this.read();
            }
            if (n4 < 0) {
                this.eofFound = true;
                throw new EOFException("EOF found inside tag value.");
            }
            n3 |= n4 & 0x7F;
        }
        return n3;
    }
}

