/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.Strings;

public class GeneralName
extends ASN1Encodable
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;

    public GeneralName(X509Name x509Name) {
        this.obj = x509Name;
        this.tag = 4;
    }

    public GeneralName(DERObject dERObject, int n2) {
        this.obj = dERObject;
        this.tag = n2;
    }

    public GeneralName(int n2, ASN1Encodable aSN1Encodable) {
        this.obj = aSN1Encodable;
        this.tag = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralName(int n2, String string) {
        this.tag = n2;
        if (n2 == 1 || n2 == 2 || n2 == 6) {
            this.obj = new DERIA5String(string);
            return;
        } else if (n2 == 8) {
            this.obj = new DERObjectIdentifier(string);
            return;
        } else if (n2 == 4) {
            this.obj = new X509Name(string);
            return;
        } else {
            if (n2 != 7) throw new IllegalArgumentException("can't process String for tag: " + n2);
            if (!IPAddress.isValid(string)) throw new IllegalArgumentException("IP Address is invalid");
            this.obj = new DEROctetString(Strings.toUTF8ByteArray(string));
        }
    }

    public static GeneralName getInstance(Object object) {
        if (object == null || object instanceof GeneralName) {
            return (GeneralName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            int n2 = aSN1TaggedObject.getTagNo();
            switch (n2) {
                case 0: {
                    return new GeneralName(n2, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 1: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 2: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + n2);
                }
                case 4: {
                    return new GeneralName(n2, ASN1Sequence.getInstance(aSN1TaggedObject, true));
                }
                case 5: {
                    return new GeneralName(n2, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 6: {
                    return new GeneralName(n2, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 7: {
                    return new GeneralName(n2, ASN1OctetString.getInstance(aSN1TaggedObject, false));
                }
                case 8: {
                    return new GeneralName(n2, DERObjectIdentifier.getInstance(aSN1TaggedObject, false));
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag);
        stringBuffer.append(": ");
        switch (this.tag) {
            case 1: 
            case 2: 
            case 6: {
                stringBuffer.append(DERIA5String.getInstance(this.obj).getString());
                break;
            }
            case 4: {
                stringBuffer.append(X509Name.getInstance(this.obj).toString());
                break;
            }
            default: {
                stringBuffer.append(this.obj.toString());
            }
        }
        return stringBuffer.toString();
    }

    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

