/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.Config;
import sun.security.pkcs11.KeyCache;
import sun.security.pkcs11.P11DHKeyFactory;
import sun.security.pkcs11.P11DSAKeyFactory;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11KeyStore;
import sun.security.pkcs11.P11RSAKeyFactory;
import sun.security.pkcs11.P11SecureRandom;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionManager;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.TemplateManager;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class Token
implements Serializable {
    private static final long serialVersionUID = 2541527649100571747L;
    private static final long CHECK_INTERVAL = 50L;
    final SunPKCS11 provider;
    final PKCS11 p11;
    final Config config;
    final CK_TOKEN_INFO tokenInfo;
    final SessionManager sessionManager;
    private final TemplateManager templateManager;
    final boolean explicitCancel;
    final KeyCache secretCache;
    final KeyCache privateCache;
    private volatile P11KeyFactory rsaFactory;
    private volatile P11KeyFactory dsaFactory;
    private volatile P11KeyFactory dhFactory;
    private volatile P11KeyFactory ecFactory;
    private final Map<Long, CK_MECHANISM_INFO> mechInfoMap;
    private volatile P11SecureRandom secureRandom;
    private volatile P11KeyStore keyStore;
    private final boolean removable;
    private volatile boolean valid;
    private long lastPresentCheck;
    private byte[] tokenId;
    private boolean writeProtected;
    private volatile boolean loggedIn;
    private long lastLoginCheck;
    private static final Object CHECK_LOCK = new Object();
    private static final CK_MECHANISM_INFO INVALID_MECH = new CK_MECHANISM_INFO(0L, 0L, 0L);
    private static final List<Reference<Token>> serializedTokens = new ArrayList<Reference<Token>>();

    Token(SunPKCS11 sunPKCS11) throws PKCS11Exception {
        SessionManager sessionManager;
        this.provider = sunPKCS11;
        this.removable = sunPKCS11.removable;
        this.valid = true;
        this.p11 = sunPKCS11.p11;
        this.config = sunPKCS11.config;
        this.tokenInfo = this.p11.C_GetTokenInfo(sunPKCS11.slotID);
        this.writeProtected = (this.tokenInfo.flags & 2L) != 0L;
        try {
            sessionManager = new SessionManager(this);
            Session session = sessionManager.getOpSession();
            sessionManager.releaseSession(session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.writeProtected) {
                throw pKCS11Exception;
            }
            this.writeProtected = true;
            sessionManager = new SessionManager(this);
            Session session = sessionManager.getOpSession();
            sessionManager.releaseSession(session);
        }
        this.sessionManager = sessionManager;
        this.secretCache = new KeyCache();
        this.privateCache = new KeyCache();
        this.templateManager = this.config.getTemplateManager();
        this.explicitCancel = this.config.getExplicitCancel();
        this.mechInfoMap = Collections.synchronizedMap(new HashMap(10));
    }

    boolean isWriteProtected() {
        return this.writeProtected;
    }

    boolean isLoggedIn(Session session) throws PKCS11Exception {
        boolean bl = this.loggedIn;
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastLoginCheck > 50L) {
            bl = this.isLoggedInNow(session);
            this.lastLoginCheck = l2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggedInNow(Session session) throws PKCS11Exception {
        boolean bl = session == null;
        try {
            boolean bl2;
            if (bl) {
                session = this.getOpSession();
            }
            CK_SESSION_INFO cK_SESSION_INFO = this.p11.C_GetSessionInfo(session.id());
            this.loggedIn = bl2 = cK_SESSION_INFO.state == 1L || cK_SESSION_INFO.state == 3L;
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (bl) {
                this.releaseSession(session);
            }
        }
    }

    void ensureLoggedIn(Session session) throws PKCS11Exception, LoginException {
        if (!this.isLoggedIn(session)) {
            this.provider.login(null, null);
        }
    }

    boolean isValid() {
        if (!this.removable) {
            return true;
        }
        return this.valid;
    }

    void ensureValid() {
        if (!this.isValid()) {
            throw new ProviderException("Token has been removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPresent(long l2) {
        if (!this.removable) {
            return true;
        }
        if (!this.valid) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        if (l3 - this.lastPresentCheck >= 50L) {
            Object object = CHECK_LOCK;
            synchronized (object) {
                if (l3 - this.lastPresentCheck >= 50L) {
                    boolean bl = false;
                    try {
                        CK_SLOT_INFO cK_SLOT_INFO = this.provider.p11.C_GetSlotInfo(this.provider.slotID);
                        if ((cK_SLOT_INFO.flags & 1L) != 0L) {
                            CK_SESSION_INFO cK_SESSION_INFO = this.provider.p11.C_GetSessionInfo(l2);
                            bl = true;
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                    this.valid = bl;
                    this.lastPresentCheck = System.currentTimeMillis();
                    if (!bl) {
                        this.destroy();
                    }
                }
            }
        }
        return this.valid;
    }

    void destroy() {
        this.valid = false;
        this.provider.uninitToken(this);
    }

    Session getObjSession() throws PKCS11Exception {
        return this.sessionManager.getObjSession();
    }

    Session getOpSession() throws PKCS11Exception {
        return this.sessionManager.getOpSession();
    }

    Session releaseSession(Session session) {
        return this.sessionManager.releaseSession(session);
    }

    Session killSession(Session session) {
        return this.sessionManager.killSession(session);
    }

    CK_ATTRIBUTE[] getAttributes(String string, long l2, long l3, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2;
        for (CK_ATTRIBUTE cK_ATTRIBUTE : cK_ATTRIBUTEArray2 = this.templateManager.getAttributes(string, l2, l3, cK_ATTRIBUTEArray)) {
            if (cK_ATTRIBUTE.type != 1L) continue;
            if (!cK_ATTRIBUTE.getBoolean()) break;
            try {
                this.ensureLoggedIn(null);
                break;
            }
            catch (LoginException loginException) {
                throw new ProviderException("Login failed", loginException);
            }
        }
        return cK_ATTRIBUTEArray2;
    }

    P11KeyFactory getKeyFactory(String string) {
        P11KeyFactory p11KeyFactory;
        if (string.equals("RSA")) {
            p11KeyFactory = this.rsaFactory;
            if (p11KeyFactory == null) {
                this.rsaFactory = p11KeyFactory = new P11RSAKeyFactory(this, string);
            }
        } else if (string.equals("DSA")) {
            p11KeyFactory = this.dsaFactory;
            if (p11KeyFactory == null) {
                this.dsaFactory = p11KeyFactory = new P11DSAKeyFactory(this, string);
            }
        } else if (string.equals("DH")) {
            p11KeyFactory = this.dhFactory;
            if (p11KeyFactory == null) {
                this.dhFactory = p11KeyFactory = new P11DHKeyFactory(this, string);
            }
        } else if (string.equals("EC")) {
            p11KeyFactory = this.ecFactory;
            if (p11KeyFactory == null) {
                this.ecFactory = p11KeyFactory = new P11ECKeyFactory(this, string);
            }
        } else {
            throw new ProviderException("Unknown algorithm " + string);
        }
        return p11KeyFactory;
    }

    P11SecureRandom getRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new P11SecureRandom(this);
        }
        return this.secureRandom;
    }

    P11KeyStore getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = new P11KeyStore(this);
        }
        return this.keyStore;
    }

    CK_MECHANISM_INFO getMechanismInfo(long l2) throws PKCS11Exception {
        CK_MECHANISM_INFO cK_MECHANISM_INFO = this.mechInfoMap.get(l2);
        if (cK_MECHANISM_INFO == null) {
            try {
                cK_MECHANISM_INFO = this.p11.C_GetMechanismInfo(this.provider.slotID, l2);
                this.mechInfoMap.put(l2, cK_MECHANISM_INFO);
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Exception.getErrorCode() != 112L) {
                    throw pKCS11Exception;
                }
                this.mechInfoMap.put(l2, INVALID_MECH);
            }
        } else if (cK_MECHANISM_INFO == INVALID_MECH) {
            cK_MECHANISM_INFO = null;
        }
        return cK_MECHANISM_INFO;
    }

    private synchronized byte[] getTokenId() {
        if (this.tokenId == null) {
            SecureRandom secureRandom = JCAUtil.getSecureRandom();
            this.tokenId = new byte[20];
            secureRandom.nextBytes(this.tokenId);
            serializedTokens.add(new WeakReference<Token>(this));
        }
        return this.tokenId;
    }

    private Object writeReplace() throws ObjectStreamException {
        if (!this.isValid()) {
            throw new NotSerializableException("Token has been removed");
        }
        return new TokenRep(this);
    }

    private static class TokenRep
    implements Serializable {
        private static final long serialVersionUID = 3503721168218219807L;
        private final byte[] tokenId;

        TokenRep(Token token) {
            this.tokenId = token.getTokenId();
        }

        private Object readResolve() throws ObjectStreamException {
            for (Reference reference : serializedTokens) {
                Token token = (Token)reference.get();
                if (token == null || !token.isValid() || !Arrays.equals(token.getTokenId(), this.tokenId)) continue;
                return token;
            }
            throw new NotSerializableException("Could not find token");
        }
    }
}

