/*
 * Decompiled with CFR 0.152.
 */
package in.gov.tds.pdfgenerator;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import in.gov.tds.exception.PDFCreationException;
import in.gov.tds.pdfcreator.impl.Form16SPdfGenerator;
import in.gov.tds.pdfgenerator.PDFSigner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import sun.security.x509.X500Name;
import util.DialogBox;
import util.KeyStoreEntry;
import util.KeyStoreUtils;
import util.PdfSigner;

public class CreatePDFTask
extends SwingWorker<List<String>, Integer> {
    private String destinationFilePath = "";
    private boolean withDigitalSignature = false;
    private File outputTargetDirectory = null;
    private PrivateKey privateKey;
    private Certificate[] certificateChain;
    private PDFSigner frame;

    CreatePDFTask(String destinationFilePath, boolean withDigitalSignature, File outputTargetDirectory, PrivateKey privateKey, Certificate[] certificateChain, PDFSigner frame) {
        this.destinationFilePath = destinationFilePath;
        this.withDigitalSignature = withDigitalSignature;
        this.outputTargetDirectory = outputTargetDirectory;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.frame = frame;
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        Form16SPdfGenerator pdfcreator = new Form16SPdfGenerator();
        ArrayList<String> filesCreated = new ArrayList<String>();
        String previousPAN = null;
        String currentPAN = null;
        String contentRow = null;
        BufferedReader br = null;
        String FHRow = null;
        String FTRow = null;
        String[] FHRowSplitArray = null;
        String formType = null;
        String headerFooter = null;
        String outputTargetPath = null;
        String[] contentSplit = null;
        String outputFileName = null;
        String bodyPb = null;
        int count = 0;
        try {
            br = new BufferedReader(new FileReader(this.destinationFilePath));
            FHRow = br.readLine().trim();
            FTRow = br.readLine().trim();
            FHRowSplitArray = FHRow.split("\\^");
            formType = FHRowSplitArray[2];
            headerFooter = String.valueOf(FHRow) + "\n" + FTRow;
            bodyPb = "";
            outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
            if (this.withDigitalSignature) {
                this.getCertificateForSignature();
                outputTargetPath = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
                File f1 = new File(outputTargetPath);
                if (!f1.exists()) {
                    f1.mkdirs();
                }
            }
            while ((contentRow = br.readLine()) != null) {
                contentSplit = contentRow.split("\\^");
                if (contentSplit.length <= 1) continue;
                currentPAN = contentSplit[1];
                bodyPb = "";
                count = previousPAN != null && previousPAN.equals(currentPAN) ? ++count : 0;
                if (("PB".equalsIgnoreCase(contentSplit[0]) || "PD".equalsIgnoreCase(contentSplit[0])) && bodyPb.equals("")) {
                    bodyPb = contentRow;
                }
                if (formType.equalsIgnoreCase("16")) {
                    outputFileName = pdfcreator.createForm16PDF(headerFooter, outputTargetPath, this.withDigitalSignature, bodyPb, count);
                    this.signPDF(outputFileName);
                    if (outputFileName != null && !outputFileName.equalsIgnoreCase("") && outputFileName.length() != 0) {
                        filesCreated.add(outputFileName);
                    }
                } else {
                    return null;
                }
                if (formType.equalsIgnoreCase("16") && ("PB".equalsIgnoreCase(contentSplit[0]) || "PD".equalsIgnoreCase(contentSplit[0]))) {
                    bodyPb = contentRow;
                }
                previousPAN = currentPAN;
            }
            br.close();
            ArrayList<String> arrayList = filesCreated;
            return arrayList;
        }
        catch (FileNotFoundException e2) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (IOException e2) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (PDFCreationException ex) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        catch (Exception e3) {
            File tempdir = this.GetTempDirectory();
            if (tempdir != null) {
                CreatePDFTask.removeFiles(tempdir);
            }
            return null;
        }
        finally {
            pdfcreator = new Form16SPdfGenerator();
            filesCreated = new ArrayList();
            previousPAN = null;
            currentPAN = null;
            contentRow = null;
            br = null;
            FHRow = null;
            FTRow = null;
            FHRowSplitArray = null;
            formType = null;
            headerFooter = null;
            outputTargetPath = null;
            contentSplit = null;
            outputFileName = null;
        }
    }

    public File GetTempDirectory() {
        File tempDir = null;
        if (this.outputTargetDirectory != null && this.outputTargetDirectory.exists()) {
            String outputTargetPath = this.outputTargetDirectory.getAbsolutePath();
            outputTargetPath = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp";
            tempDir = new File(outputTargetPath);
        }
        return tempDir;
    }

    public static boolean removeFiles(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        String[] list = directory.list();
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                File entry = new File(directory, list[i2]);
                if (entry.isDirectory()) {
                    if (!CreatePDFTask.removeFiles(entry)) {
                        return false;
                    }
                    if (!entry.delete()) {
                        return false;
                    }
                } else if (!entry.delete()) {
                    return false;
                }
                ++i2;
            }
        }
        list = null;
        return true;
    }

    private void getCertificateForSignature() {
        String selectedCertificate = "";
        KeyStoreEntry kse = null;
        String alias = null;
        KeyStore ks = null;
        String certSelected = null;
        if (this.frame.getSoftTokenstoreTable() != null && this.frame.getSoftTokenstoreTable().getRowCount() == 1) {
            kse = this.frame.getSoftTokenstoreTable().getSelectedEntry();
            selectedCertificate = "From Soft Token";
        } else {
            selectedCertificate = "Windows Store";
        }
        if (this.privateKey == null && this.certificateChain == null) {
            if (!selectedCertificate.equals("Windows Store")) {
                boolean firstAsk = true;
                char[] pass = DialogBox.askPassword(this.frame, "Enter the token Password.", firstAsk);
                File certFile = new File(selectedCertificate);
                if (pass == null) {
                    return;
                }
                firstAsk = false;
                try {
                    try {
                        ks = KeyStoreUtils.getPKCS12Store(certFile, pass);
                        while (ks == null) {
                            pass = DialogBox.askPassword(this.frame, "Enter the correct token password.", true);
                            ks = KeyStoreUtils.getPKCS12Store(certFile, pass);
                            if (ks != null) continue;
                        }
                        alias = ks.aliases().nextElement();
                        this.privateKey = (PrivateKey)ks.getKey(alias, pass);
                        this.certificateChain = ks.getCertificateChain(alias);
                    }
                    catch (UnrecoverableKeyException e2) {
                        certFile = null;
                        pass = null;
                        return;
                    }
                    catch (KeyStoreException keyStoreException) {
                        certFile = null;
                        pass = null;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        certFile = null;
                        pass = null;
                    }
                }
                finally {
                    certFile = null;
                    pass = null;
                }
            } else if (selectedCertificate != null && selectedCertificate.equals("Windows Store")) {
                try {
                    ks = KeyStore.getInstance("WINDOWS-MY", "SunMSCAPI");
                    ks.load(null, null);
                }
                catch (KeyStoreException keyStoreException) {
                }
                catch (NoSuchProviderException noSuchProviderException) {
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (CertificateException certificateException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.frame.getStoreTable() != null && this.frame.getStoreTable().getRowCount() != 0) {
                    if (this.frame.getStoreTable().getSelectedEntry() == null) {
                        return;
                    }
                    kse = this.frame.getStoreTable().getSelectedEntry();
                    alias = kse.getAlias().trim();
                    try {
                        this.privateKey = (PrivateKey)ks.getKey(alias, null);
                        this.certificateChain = ks.getCertificateChain(alias);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                    }
                    catch (KeyStoreException keyStoreException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (ks == null) {
                    ks = kse.getLoadedKeyStore();
                }
                try {
                    certSelected = kse.getAlias();
                    this.frame.setCertificateName(kse.getSubjectCN().trim(), kse.getAlias().trim());
                    this.frame.setValidity(((X509Certificate)ks.getCertificate(certSelected)).getNotAfter().toString());
                    this.frame.setIssuerName(new X500Name(((X509Certificate)ks.getCertificate(certSelected)).getIssuerDN().getName()).getCommonName());
                }
                catch (IOException iOException) {
                }
                catch (KeyStoreException keyStoreException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void signPDF(String fileCreated) {
        boolean showSignature = true;
        Rectangle signRectangle = null;
        int[] signatureOnPage = null;
        PdfSigner pdfSigner = new PdfSigner();
        String reason = "";
        String location = "";
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        String status = "";
        ArrayList rList = new ArrayList();
        try {
            try {
                StringBuilder sbInvalidPageNos;
                block23: {
                    signRectangle = new Rectangle(425.0f, 30.0f, 525.0f, 80.0f);
                    File signPdfFile = new File(String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp" + File.separator + fileCreated);
                    String errorMessage = null;
                    sbInvalidPageNos = new StringBuilder();
                    if (signPdfFile.isFile() && signPdfFile.getName().toLowerCase().endsWith("pdf")) {
                        String fileName = String.valueOf(this.outputTargetDirectory.getAbsolutePath()) + File.separator + "temp" + File.separator + fileCreated;
                        PdfReader reader = null;
                        try {
                            reader = new PdfReader(fileName);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        int totalPages = reader.getNumberOfPages();
                        signatureOnPage = new int[]{totalPages};
                        if (signatureOnPage != null) {
                            byte[] pdfBytes = null;
                            try {
                                FileInputStream fis = new FileInputStream(fileName);
                                pdfBytes = new byte[fis.available()];
                                fis.read(pdfBytes);
                                fis.close();
                            }
                            catch (Exception ex) {
                                signRectangle = null;
                                signatureOnPage = null;
                                pdfSigner = null;
                                reason = null;
                                location = null;
                                bais = null;
                                baos = null;
                                rList = null;
                                status = null;
                                return;
                            }
                            bais = new ByteArrayInputStream(pdfBytes);
                            baos = new ByteArrayOutputStream();
                            status = pdfSigner.sign(bais, baos, this.privateKey, this.certificateChain, "", false, showSignature, signRectangle, signatureOnPage, reason, location, this.frame.getImagePath(), rList, this.frame.getSignerType());
                            if (status.equals("failure")) {
                                signRectangle = null;
                                signatureOnPage = null;
                                pdfSigner = null;
                                reason = null;
                                location = null;
                                bais = null;
                                baos = null;
                                rList = null;
                                status = null;
                                return;
                            }
                            if (status.equals("e1002")) {
                                signRectangle = null;
                                signatureOnPage = null;
                                pdfSigner = null;
                                reason = null;
                                location = null;
                                bais = null;
                                baos = null;
                                rList = null;
                                status = null;
                                return;
                            }
                            byte[] signedBytes = baos.toByteArray();
                            try {
                                bais.close();
                                baos.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            FileOutputStream fos = null;
                            File signedPDFfile = null;
                            try {
                                try {
                                    signedPDFfile = new File(this.outputTargetDirectory.getAbsolutePath());
                                    if (!signedPDFfile.exists()) {
                                        signedPDFfile.mkdirs();
                                    }
                                    fos = new FileOutputStream(String.valueOf(signedPDFfile.getAbsolutePath()) + "/" + signPdfFile.getName());
                                    fos.write(signedBytes);
                                    fos.close();
                                }
                                catch (FileNotFoundException fe) {
                                    errorMessage = fe.getMessage().substring(fe.getMessage().indexOf("(") + 1, fe.getMessage().lastIndexOf(")"));
                                    if (errorMessage != null) {
                                        errorMessage.equals("The process cannot access the file because it is being used by another process");
                                    }
                                    signedBytes = null;
                                    fos = null;
                                    signedPDFfile = null;
                                    break block23;
                                }
                                catch (Exception ex) {
                                    signedBytes = null;
                                    fos = null;
                                    signedPDFfile = null;
                                    signRectangle = null;
                                    signatureOnPage = null;
                                    pdfSigner = null;
                                    reason = null;
                                    location = null;
                                    bais = null;
                                    baos = null;
                                    rList = null;
                                    status = null;
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                signedBytes = null;
                                fos = null;
                                signedPDFfile = null;
                                throw throwable;
                            }
                            signedBytes = null;
                            fos = null;
                            signedPDFfile = null;
                        }
                    }
                }
                sbInvalidPageNos.toString().equals("");
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                signRectangle = null;
                signatureOnPage = null;
                pdfSigner = null;
                reason = null;
                location = null;
                bais = null;
                baos = null;
                rList = null;
                status = null;
                return;
            }
        }
        finally {
            signRectangle = null;
            signatureOnPage = null;
            pdfSigner = null;
            reason = null;
            location = null;
            bais = null;
            baos = null;
            rList = null;
            status = null;
        }
    }
}

