/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.NameSpace;
import java.util.Vector;

public class CallStack {
    private Vector stack = new Vector(2);

    public CallStack() {
    }

    public CallStack(NameSpace nameSpace) {
        this.push(nameSpace);
    }

    public void clear() {
        this.stack.removeAllElements();
    }

    public void push(NameSpace nameSpace) {
        this.stack.insertElementAt(nameSpace, 0);
    }

    public NameSpace top() {
        return this.get(0);
    }

    public NameSpace get(int n2) {
        if (n2 >= this.depth()) {
            return NameSpace.JAVACODE;
        }
        return (NameSpace)this.stack.elementAt(n2);
    }

    public void set(int n2, NameSpace nameSpace) {
        this.stack.setElementAt(nameSpace, n2);
    }

    public NameSpace pop() {
        if (this.depth() < 1) {
            throw new InterpreterError("pop on empty CallStack");
        }
        NameSpace nameSpace = this.top();
        this.stack.removeElementAt(0);
        return nameSpace;
    }

    public NameSpace swap(NameSpace nameSpace) {
        NameSpace nameSpace2 = (NameSpace)this.stack.elementAt(0);
        this.stack.setElementAt(nameSpace, 0);
        return nameSpace2;
    }

    public int depth() {
        return this.stack.size();
    }

    public NameSpace[] toArray() {
        Object[] objectArray = new NameSpace[this.depth()];
        this.stack.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CallStack:\n");
        NameSpace[] nameSpaceArray = this.toArray();
        int n2 = 0;
        while (n2 < nameSpaceArray.length) {
            stringBuffer.append("\t" + nameSpaceArray[n2] + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public CallStack copy() {
        CallStack callStack = new CallStack();
        callStack.stack = (Vector)this.stack.clone();
        return callStack;
    }
}

