/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntHashtable
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable() {
        this(150, 0.75f);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.capacity.1", initialCapacity));
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.load.1", String.valueOf(loadFactor)));
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(int value) {
        Entry[] tab = this.table;
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (e2.value == value) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    public boolean containsValue(int value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    public int get(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return 0;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newMap[index];
                newMap[index] = e2;
            }
        }
    }

    public int put(int key, int value) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                int old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e2 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return 0;
    }

    public int remove(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        Entry prev = null;
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                if (prev != null) {
                    prev.next = e2.next;
                } else {
                    tab[index] = e2.next;
                }
                --this.count;
                int oldValue = e2.value;
                e2.value = 0;
                return oldValue;
            }
            prev = e2;
            e2 = e2.next;
        }
        return 0;
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Iterator<Entry> getEntryIterator() {
        return new IntHashtableIterator(this.table);
    }

    public int[] toOrderedKeys() {
        int[] res = this.getKeys();
        Arrays.sort(res);
        return res;
    }

    public int[] getKeys() {
        int[] res = new int[this.count];
        int ptr = 0;
        int index = this.table.length;
        Entry entry = null;
        while (true) {
            if (entry == null) {
                while (index-- > 0 && (entry = this.table[index]) == null) {
                }
            }
            if (entry == null) break;
            Entry e2 = entry;
            entry = e2.next;
            res[ptr++] = e2.key;
        }
        return res;
    }

    public int getOneKey() {
        if (this.count == 0) {
            return 0;
        }
        int index = this.table.length;
        Entry entry = null;
        while (index-- > 0 && (entry = this.table[index]) == null) {
        }
        if (entry == null) {
            return 0;
        }
        return entry.key;
    }

    public Object clone() {
        try {
            IntHashtable t2 = (IntHashtable)super.clone();
            t2.table = new Entry[this.table.length];
            int i2 = this.table.length;
            while (i2-- > 0) {
                Entry entry = t2.table[i2] = this.table[i2] != null ? (Entry)this.table[i2].clone() : null;
            }
            return t2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    static class Entry {
        int hash;
        int key;
        int value;
        Entry next;

        protected Entry(int hash, int key, int value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        protected Object clone() {
            Entry entry = new Entry(this.hash, this.key, this.value, this.next != null ? (Entry)this.next.clone() : null);
            return entry;
        }
    }

    static class IntHashtableIterator
    implements Iterator<Entry> {
        int index;
        Entry[] table;
        Entry entry;

        IntHashtableIterator(Entry[] table) {
            this.table = table;
            this.index = table.length;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        @Override
        public Entry next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e2 = this.entry;
                this.entry = e2.next;
                return e2;
            }
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("inthashtableiterator"));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("remove.not.supported"));
        }
    }
}

