/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Table;
import java.util.ArrayList;

public class Row
implements Element {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected Object[] cells;
    protected int horizontalAlignment;

    protected Row(int n2) {
        this.columns = n2;
        this.reserved = new boolean[n2];
        this.cells = new Object[n2];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    void deleteColumn(int n2) {
        int n3;
        if (n2 >= this.columns || n2 < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + n2);
        }
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        for (n3 = 0; n3 < n2; ++n3) {
            blArray[n3] = this.reserved[n3];
            cellArray[n3] = this.cells[n3];
            if (cellArray[n3] == null || n3 + cellArray[n3].getColspan() <= n2) continue;
            cellArray[n3].setColspan(((Cell)this.cells[n3]).getColspan() - 1);
        }
        for (n3 = n2; n3 < this.columns; ++n3) {
            blArray[n3] = this.reserved[n3 + 1];
            cellArray[n3] = this.cells[n3 + 1];
        }
        if (this.cells[n2] != null && ((Cell)this.cells[n2]).getColspan() > 1) {
            cellArray[n2] = this.cells[n2];
            cellArray[n2].setColspan(cellArray[n2].getColspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    int addElement(Object object) {
        return this.addElement(object, this.currentColumn);
    }

    int addElement(Object object, int n2) {
        int n3;
        if (object == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(object) != 1 && this.getObjectID(object) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n4 = n3 = Cell.class.isInstance(object) ? ((Cell)object).getColspan() : 1;
        if (!this.reserve(n2, n3)) {
            return -1;
        }
        this.cells[n2] = object;
        this.currentColumn += n3 - 1;
        return n2;
    }

    void setElement(Object object, int n2) {
        if (this.reserved[n2]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[n2] = object;
        if (object != null) {
            this.reserved[n2] = true;
        }
    }

    boolean reserve(int n2) {
        return this.reserve(n2, 1);
    }

    boolean reserve(int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.reserved[i2]) {
                for (int i3 = i2; i3 >= n2; --i3) {
                    this.reserved[i3] = false;
                }
                return false;
            }
            this.reserved[i2] = true;
        }
        return true;
    }

    boolean isReserved(int n2) {
        return this.reserved[n2];
    }

    int getElementID(int n2) {
        if (this.cells[n2] == null) {
            return 0;
        }
        if (Cell.class.isInstance(this.cells[n2])) {
            return 1;
        }
        if (Table.class.isInstance(this.cells[n2])) {
            return 2;
        }
        return -1;
    }

    int getObjectID(Object object) {
        if (object == null) {
            return 0;
        }
        if (Cell.class.isInstance(object)) {
            return 1;
        }
        if (Table.class.isInstance(object)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int n2) {
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + n2 + " max is " + this.columns);
        }
        return this.cells[n2];
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.columns; ++i2) {
            if (this.cells[i2] == null) continue;
            return false;
        }
        return true;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

