/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public final class HtmlEncoder {
    private static final String[] htmlCode;

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0100') {
                stringBuffer.append(htmlCode[c2]);
                continue;
            }
            stringBuffer.append("&#").append((int)c2).append(';');
        }
        return stringBuffer.toString();
    }

    public static String encode(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        if (color.getRed() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getBlue(), 16));
        return stringBuffer.toString();
    }

    public static String getAlignment(int n2) {
        switch (n2) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: 
            case 8: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "";
    }

    static {
        int n2;
        htmlCode = new String[256];
        for (n2 = 0; n2 < 10; ++n2) {
            HtmlEncoder.htmlCode[n2] = "&#00" + n2 + ";";
        }
        for (n2 = 10; n2 < 32; ++n2) {
            HtmlEncoder.htmlCode[n2] = "&#0" + n2 + ";";
        }
        for (n2 = 32; n2 < 128; ++n2) {
            HtmlEncoder.htmlCode[n2] = String.valueOf((char)n2);
        }
        HtmlEncoder.htmlCode[9] = "\t";
        HtmlEncoder.htmlCode[10] = "<br />\n";
        HtmlEncoder.htmlCode[34] = "&quot;";
        HtmlEncoder.htmlCode[38] = "&amp;";
        HtmlEncoder.htmlCode[60] = "&lt;";
        HtmlEncoder.htmlCode[62] = "&gt;";
        for (n2 = 128; n2 < 256; ++n2) {
            HtmlEncoder.htmlCode[n2] = "&#" + n2 + ";";
        }
    }
}

