/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Identity;
import javax.ejb.deployment.SerializableMethod;

public class AccessControlEntry
implements Serializable {
    private transient Method method;
    private Identity[] allowedIdentities;
    private SerializableMethod serializableMethod;

    public AccessControlEntry() {
    }

    public AccessControlEntry(Method method) {
        this.method = method;
    }

    public AccessControlEntry(Method method, Identity[] identityArray) {
        this.method = method;
        this.allowedIdentities = identityArray;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Identity[] getAllowedIdentities() {
        return this.allowedIdentities;
    }

    public void setAllowedIdentities(Identity[] identityArray) {
        this.allowedIdentities = identityArray;
    }

    public Identity getAllowedIdentities(int n2) {
        return this.allowedIdentities[n2];
    }

    public void setAllowedIdentities(int n2, Identity identity) {
        if (this.allowedIdentities == null || n2 >= this.allowedIdentities.length) {
            Identity[] identityArray = new Identity[n2 + 1];
            if (this.allowedIdentities != null) {
                int n3 = 0;
                while (n3 < this.allowedIdentities.length) {
                    identityArray[n3] = this.allowedIdentities[n3];
                    ++n3;
                }
            }
            this.allowedIdentities = identityArray;
        }
        this.allowedIdentities[n2] = identity;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.serializableMethod = new SerializableMethod(this.method);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NoSuchMethodException {
        objectInputStream.defaultReadObject();
        this.method = this.serializableMethod.getMethod();
    }
}

