/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.BinTools;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;

class PBKDF2HexFormatter {
    PBKDF2HexFormatter() {
    }

    public boolean fromString(PBKDF2Parameters p2, String s2) {
        if (p2 == null || s2 == null) {
            return true;
        }
        String[] p123 = s2.split(":");
        if (p123 == null || p123.length != 3) {
            return true;
        }
        byte[] salt = BinTools.hex2bin(p123[0]);
        int iterationCount = Integer.parseInt(p123[1]);
        byte[] bDK = BinTools.hex2bin(p123[2]);
        p2.setSalt(salt);
        p2.setIterationCount(iterationCount);
        p2.setDerivedKey(bDK);
        return false;
    }

    public String toString(PBKDF2Parameters p2) {
        String s2 = String.valueOf(BinTools.bin2hex(p2.getSalt())) + ":" + String.valueOf(p2.getIterationCount()) + ":" + BinTools.bin2hex(p2.getDerivedKey());
        return s2;
    }
}

