/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ArrayStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ConstantColumnValue;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.NumberValuesUtils;
import net.sf.jasperreports.data.cache.RunLengthColumnValues;
import net.sf.jasperreports.data.cache.RunLengthStore;
import net.sf.jasperreports.data.cache.TransformedColumnValues;
import net.sf.jasperreports.data.cache.ValueLength;
import net.sf.jasperreports.data.cache.ValueTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LongArrayStore
implements BufferColumnStore,
ArrayStore {
    private static final Log log = LogFactory.getLog(LongArrayStore.class);
    private final boolean useGCD;
    private final ValueTransformer valueTransformer;
    private final long[] values;
    private int count;
    private long min;
    private long max;
    private RunLengthStore runLengthStore;

    public LongArrayStore(int size) {
        this(size, null, false);
    }

    public LongArrayStore(int size, ValueTransformer valueTransformer) {
        this(size, valueTransformer, false);
    }

    public LongArrayStore(int size, boolean useGCD) {
        this(size, null, useGCD);
    }

    @Override
    public Class<?> getBaseValuesType() {
        return this.valueTransformer == null ? Number.class : this.valueTransformer.getResultType();
    }

    public LongArrayStore(int size, ValueTransformer valueTransformer, boolean useGCD) {
        this.useGCD = useGCD;
        this.valueTransformer = valueTransformer;
        this.values = new long[size];
        this.runLengthStore = new RunLengthStore(this);
        this.reset();
    }

    private void reset() {
        this.count = 0;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.runLengthStore.reset();
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public boolean valuesEqual(int idx1, int idx2) {
        return this.values[idx1] == this.values[idx2];
    }

    @Override
    public void copyValue(int destIdx, int sourceIdx) {
        this.values[destIdx] = this.values[sourceIdx];
    }

    @Override
    public void updateCount(int count) {
        this.count = count;
    }

    public void add(long value) {
        this.values[this.count] = value;
        ++this.count;
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.runLengthStore.valueAdded();
    }

    @Override
    public void addValue(Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Short) {
            this.add(((Number)value).longValue());
        } else if (value instanceof Character) {
            this.add(((Character)value).charValue());
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean full() {
        return this.count >= this.values.length;
    }

    @Override
    public void resetValues() {
        this.reset();
    }

    @Override
    public ColumnValues createValues() {
        long gcd;
        if (this.count == 0) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": no values");
            }
            return EmptyColumnValues.instance();
        }
        if (this.min == this.max) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": constant value of size " + this.count);
            }
            Long value = this.valueTransformer == null ? Long.valueOf(this.min) : this.valueTransformer.get(this.min);
            return new ConstantColumnValue(this.count, value);
        }
        long linearOffset = 0L;
        long linearFactor = 1L;
        if (this.min != 0L) {
            linearOffset = this.min;
            if (log.isDebugEnabled()) {
                log.debug(this + ": using offset " + linearOffset);
            }
            int i2 = 0;
            while (i2 < this.count) {
                int n2 = i2++;
                this.values[n2] = this.values[n2] - linearOffset;
            }
            this.min = 0L;
            this.max -= linearOffset;
        }
        if (this.useGCD && (gcd = this.computeGCD()) > 1L) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": using factor " + gcd);
            }
            int i3 = 0;
            while (i3 < this.count) {
                int n3 = i3++;
                this.values[n3] = this.values[n3] / gcd;
            }
            this.max /= gcd;
            linearFactor = gcd;
        }
        int originalCount = this.count;
        ValueLength valueLength = ValueLength.getNumberLength(this.max);
        ColumnValues runLengthValues = this.runLengthStore.applyRunLengths(valueLength);
        if (log.isDebugEnabled()) {
            log.debug(this + ": creating values of count " + this.count + ", value length " + (Object)((Object)valueLength));
        }
        ColumnValues colValues = NumberValuesUtils.instance().toValues(this.count, this.values, valueLength, linearFactor, linearOffset);
        if (this.valueTransformer != null) {
            colValues = new TransformedColumnValues(colValues, this.valueTransformer);
        }
        ColumnValues finalValues = runLengthValues == null ? colValues : new RunLengthColumnValues(originalCount, colValues, runLengthValues);
        return finalValues;
    }

    protected long computeGCD() {
        long gcd = this.values[0] - this.min;
        for (int i2 = 1; i2 < this.count; ++i2) {
            if ((gcd = LongArrayStore.gcd(gcd, this.values[i2] - this.min)) != 1L) continue;
            return gcd;
        }
        return gcd;
    }

    private static long gcd(long a2, long b2) {
        if (b2 == 0L) {
            return a2;
        }
        while (a2 > 0L) {
            long t2 = a2;
            a2 = b2 % a2;
            b2 = t2;
        }
        return b2;
    }

    public String toString() {
        return "LongArrayStore@" + this.hashCode();
    }
}

