/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRPrintImageArea
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final byte SHAPE_DEFAULT = 0;
    public static final byte SHAPE_RECTANGLE = 1;
    public static final byte SHAPE_CIRCLE = 2;
    public static final byte SHAPE_POLYGON = 3;
    public static final String SHAPE_HTML_DEFAULT = "default";
    public static final String SHAPE_HTML_RECTANGLE = "rect";
    public static final String SHAPE_HTML_CIRCLE = "circle";
    public static final String SHAPE_HTML_POLYGON = "poly";
    private static final Map<String, Byte> htmlShapes = new HashMap<String, Byte>();
    private byte shape = 0;
    private int[] coordinates;
    private transient Shape cachedAWTShape;

    public static byte getShape(String htmlShape) {
        Byte shape = htmlShapes.get(htmlShape.toLowerCase());
        if (shape == null) {
            throw new JRRuntimeException("Unknown HTML image area shape \"" + htmlShape + "\"");
        }
        return shape;
    }

    public static String getHtmlShape(byte shape) {
        String htmlShape;
        switch (shape) {
            case 0: {
                htmlShape = SHAPE_HTML_DEFAULT;
                break;
            }
            case 1: {
                htmlShape = SHAPE_HTML_RECTANGLE;
                break;
            }
            case 2: {
                htmlShape = SHAPE_HTML_CIRCLE;
                break;
            }
            case 3: {
                htmlShape = SHAPE_HTML_POLYGON;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown image area shape " + shape + "");
            }
        }
        return htmlShape;
    }

    public byte getShape() {
        return this.shape;
    }

    public void setShape(byte shape) {
        this.shape = shape;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(int[] coordinates) {
        this.coordinates = coordinates;
    }

    public boolean containsPoint(int x, int y) {
        boolean contains;
        if (this.hasAWTShape()) {
            this.ensureAWTShape();
            contains = this.cachedAWTShape.contains(x, y);
        } else {
            contains = true;
        }
        return contains;
    }

    protected void ensureAWTShape() {
        if (this.cachedAWTShape == null) {
            this.cachedAWTShape = this.createAWTShape();
        }
    }

    protected boolean hasAWTShape() {
        return this.shape != 0;
    }

    protected Shape createAWTShape() {
        Shape awtShape;
        switch (this.shape) {
            case 1: {
                awtShape = this.createAWTRectangle();
                break;
            }
            case 2: {
                awtShape = this.createAWTCircle();
                break;
            }
            case 3: {
                awtShape = this.createAWTPolygon();
                break;
            }
            default: {
                awtShape = null;
            }
        }
        return awtShape;
    }

    protected Shape createAWTRectangle() {
        if (this.coordinates == null || this.coordinates.length != 4) {
            throw new JRRuntimeException("A rectangle must have exactly 4 coordinates");
        }
        return new Rectangle(this.coordinates[0], this.coordinates[1], this.coordinates[2] - this.coordinates[0], this.coordinates[3] - this.coordinates[1]);
    }

    private Shape createAWTCircle() {
        if (this.coordinates == null || this.coordinates.length != 3) {
            throw new JRRuntimeException("A circle must have exactly 4 coordinates");
        }
        return new Ellipse2D.Float(this.coordinates[0], this.coordinates[1], this.coordinates[2], this.coordinates[2]);
    }

    private Shape createAWTPolygon() {
        int i2;
        if (this.coordinates == null || this.coordinates.length == 0 || this.coordinates.length % 2 != 0) {
            throw new JRRuntimeException("A polygon must have an even number of coordinates");
        }
        Polygon polygon = new Polygon();
        for (i2 = 0; i2 < this.coordinates.length - 2; i2 += 2) {
            polygon.addPoint(this.coordinates[i2], this.coordinates[i2 + 1]);
        }
        if (this.coordinates[i2] != this.coordinates[0] || this.coordinates[i2 + 1] != this.coordinates[1]) {
            polygon.addPoint(this.coordinates[i2], this.coordinates[i2 + 1]);
        }
        return polygon;
    }

    static {
        htmlShapes.put(SHAPE_HTML_DEFAULT, new Byte(0));
        htmlShapes.put(SHAPE_HTML_RECTANGLE, new Byte(1));
        htmlShapes.put(SHAPE_HTML_CIRCLE, new Byte(2));
        htmlShapes.put(SHAPE_HTML_POLYGON, new Byte(3));
    }
}

