/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Locale;
import java.util.MissingResourceException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageUtil;

public class JRRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 10200L;
    public static final String ERROR_MESSAGES_BUNDLE = "jasperreports_messages";
    private Object[] args;
    private String messageKey;
    private String localizedMessage;
    private boolean hasLocalizedMessage;

    public JRRuntimeException(String message) {
        super(message);
    }

    public JRRuntimeException(Throwable t2) {
        super(t2);
    }

    public JRRuntimeException(String message, Throwable t2) {
        super(message, t2);
    }

    public JRRuntimeException(String messageKey, Object[] args, JasperReportsContext jasperReportsContext, Locale locale) {
        super(messageKey);
        this.messageKey = messageKey;
        this.args = args;
        this.localizedMessage = this.resolveMessage(messageKey, args, jasperReportsContext, locale);
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean hasLocalizedMessage() {
        return this.hasLocalizedMessage;
    }

    @Override
    public String getMessage() {
        if (this.hasLocalizedMessage) {
            return this.localizedMessage;
        }
        return super.getMessage();
    }

    protected String resolveMessage(String messageKey, Object[] args, JasperReportsContext jasperReportsContext, Locale locale) {
        if (messageKey != null) {
            try {
                this.hasLocalizedMessage = true;
                return MessageUtil.getInstance(jasperReportsContext).getMessageProvider(ERROR_MESSAGES_BUNDLE).getMessage(messageKey, args, locale);
            }
            catch (MissingResourceException e2) {
                // empty catch block
            }
        }
        this.hasLocalizedMessage = false;
        return messageKey;
    }
}

