/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;

public final class ParagraphUtil {
    public static TabStop[] getTabStops(JRParagraph paragraph, float endX) {
        ArrayList<TabStop> tabStopList = new ArrayList<TabStop>();
        TabStop lastTabStop = new TabStop();
        TabStop[] tabStops = paragraph.getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            for (int i2 = 0; i2 < tabStops.length; ++i2) {
                lastTabStop = tabStops[i2];
                if (!((float)lastTabStop.getPosition() <= endX)) continue;
                tabStopList.add(lastTabStop);
            }
        }
        while ((float)(lastTabStop.getPosition() + paragraph.getTabStopWidth()) <= endX) {
            lastTabStop = new TabStop((lastTabStop.getPosition() / paragraph.getTabStopWidth() + 1) * paragraph.getTabStopWidth(), TabStopAlignEnum.LEFT);
            tabStopList.add(lastTabStop);
        }
        return tabStopList.toArray(new TabStop[tabStopList.size()]);
    }

    public static float getRightX(TabStop tabStop, float advance) {
        float rightX = advance;
        if (tabStop != null) {
            switch (tabStop.getAlignment()) {
                case RIGHT: {
                    rightX = tabStop.getPosition();
                    break;
                }
                case CENTER: {
                    rightX = (float)tabStop.getPosition() + advance / 2.0f;
                    break;
                }
                default: {
                    rightX = (float)tabStop.getPosition() + advance;
                }
            }
        }
        return rightX;
    }

    public static float getLeftX(TabStop tabStop, float advance) {
        float leftX = 0.0f;
        if (tabStop != null) {
            switch (tabStop.getAlignment()) {
                case RIGHT: {
                    leftX = (float)tabStop.getPosition() - advance;
                    break;
                }
                case CENTER: {
                    leftX = (float)tabStop.getPosition() - advance / 2.0f;
                    break;
                }
                default: {
                    leftX = tabStop.getPosition();
                }
            }
        }
        return leftX;
    }

    public static float getSegmentOffset(TabStop tabStop, float rightX) {
        float segmentOffset = rightX;
        if (tabStop != null) {
            switch (tabStop.getAlignment()) {
                case RIGHT: {
                    segmentOffset = rightX;
                    break;
                }
                case CENTER: {
                    segmentOffset = rightX;
                    break;
                }
                default: {
                    segmentOffset = tabStop.getPosition();
                }
            }
        }
        return segmentOffset;
    }

    public static TabStop getNextTabStop(JRParagraph paragraph, float endX, float rightX) {
        int i2;
        TabStop nextTabStop = null;
        TabStop[] tabStops = ParagraphUtil.getTabStops(paragraph, endX);
        for (i2 = 0; i2 < tabStops.length; ++i2) {
            TabStop tabStop = tabStops[i2];
            if (!((float)tabStop.getPosition() > rightX)) continue;
            nextTabStop = tabStop;
            break;
        }
        if (i2 == tabStops.length) {
            nextTabStop = new TabStop();
            nextTabStop.setPosition((int)((rightX / (float)paragraph.getTabStopWidth().intValue() + 1.0f) * (float)paragraph.getTabStopWidth().intValue()));
        }
        return nextTabStop;
    }

    public static TabStop getFirstTabStop(JRParagraph paragraph, float endX) {
        TabStop firstTabStop = new TabStop();
        TabStop[] tabStops = ParagraphUtil.getTabStops(paragraph, endX);
        firstTabStop = tabStops[0];
        return firstTabStop;
    }

    public static TabStop getLastTabStop(JRParagraph paragraph, float endX) {
        int i2;
        TabStop lastTabStop = new TabStop();
        TabStop[] tabStops = ParagraphUtil.getTabStops(paragraph, endX);
        for (i2 = tabStops.length - 1; i2 >= 0; --i2) {
            TabStop tabStop = tabStops[i2];
            if (!((float)tabStop.getPosition() < endX)) continue;
            lastTabStop = tabStop;
            break;
        }
        if (i2 < 0) {
            lastTabStop.setPosition((int)endX);
        }
        return lastTabStop;
    }

    private ParagraphUtil() {
    }
}

