/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERBMPString
extends ASN1Object
implements DERString {
    String string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBMPString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            cArray[i2] = (char)(byArray[2 * i2] << 8 | byArray[2 * i2 + 1] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERBMPString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    protected boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)dERObject;
        return this.getString().equals(dERBMPString.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            byArray[2 * i2] = (byte)(cArray[i2] >> 8);
            byArray[2 * i2 + 1] = (byte)cArray[i2];
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

