/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509LDAPCertStoreParameters;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertStatus;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.x509.ExtendedPKIXParameters;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;

public class CertPathValidatorUtilities {
    protected static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    protected static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    protected static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    protected static final String FRESHEST_CRL = X509Extensions.FreshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = X509Extensions.CRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = X509Extensions.AuthorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    protected static final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, CertPath certPath, int n2, Set set) throws CertPathValidatorException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate);
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", exception, certPath, n2);
        }
        return trustAnchor;
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object object) {
        if (object instanceof X509Certificate) {
            return ((X509Certificate)object).getIssuerX500Principal();
        }
        return (X500Principal)((X509AttributeCertificate)object).getIssuer().getPrincipals()[0];
    }

    protected static Date getValidDate(PKIXParameters pKIXParameters) {
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    protected static DERObject getExtensionValue(X509Extension x509Extension, String string) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(string, byArray);
    }

    private static DERObject getObject(String string, byte[] byArray) throws AnnotatedException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AnnotatedException("exception processing extension " + string, iOException);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    protected static final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws AnnotatedException {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("cannot extract crl: " + certStoreException, certStoreException);
            }
        }
        return hashSet;
    }

    protected static final Collection findCRLs(X509CRLStoreSelector x509CRLStoreSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        AnnotatedException annotatedException = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            X509Store x509Store = (X509Store)iterator.next();
            try {
                hashSet.addAll(x509Store.getMatches(x509CRLStoreSelector));
                bl = true;
            }
            catch (StoreException storeException) {
                annotatedException = new AnnotatedException("Exception searching in X.509 CRL store.", storeException);
            }
        }
        if (!bl && annotatedException != null) {
            throw annotatedException;
        }
        return hashSet;
    }

    protected static final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    protected static PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i2 = 0; i2 < listArray.length; ++i2) {
                listArray[i2] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private static void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    protected static boolean processCertD1i(int n2, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(dERObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n2, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n2].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    protected static void processCertD1ii(int n2, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n2 - 1];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n2, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n2].add(pKIXPolicyNode2);
            return;
        }
    }

    protected static void prepareNextCertB1(int n2, List[] listArray, String string, Map map, X509Certificate x509Certificate) throws AnnotatedException, CertPathValidatorException {
        PKIXPolicyNode pKIXPolicyNode;
        boolean bl = false;
        Iterator iterator = listArray[n2].iterator();
        while (iterator.hasNext()) {
            pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode.getValidPolicy().equals(string)) continue;
            bl = true;
            pKIXPolicyNode.expectedPolicies = (Set)map.get(string);
            break;
        }
        if (!bl) {
            iterator = listArray[n2].iterator();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2;
                pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
                if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
                Set set = null;
                ASN1Sequence aSN1Sequence = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    PolicyInformation policyInformation = PolicyInformation.getInstance(enumeration.nextElement());
                    if (!ANY_POLICY.equals(policyInformation.getPolicyIdentifier().getId())) continue;
                    set = CertPathValidatorUtilities.getQualifierSet(policyInformation.getPolicyQualifiers());
                    break;
                }
                boolean bl2 = false;
                if (x509Certificate.getCriticalExtensionOIDs() != null) {
                    bl2 = x509Certificate.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!ANY_POLICY.equals((pKIXPolicyNode2 = (PKIXPolicyNode)pKIXPolicyNode.getParent()).getValidPolicy())) break;
                PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n2, (Set)map.get(string), pKIXPolicyNode2, set, string, bl2);
                pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                listArray[n2].add(pKIXPolicyNode3);
                break;
            }
        }
    }

    protected static PKIXPolicyNode prepareNextCertB2(int n2, List[] listArray, String string, PKIXPolicyNode pKIXPolicyNode) {
        Iterator iterator = listArray[n2].iterator();
        while (iterator.hasNext()) {
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode2.getValidPolicy().equals(string)) continue;
            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
            pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
            iterator.remove();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                PKIXPolicyNode pKIXPolicyNode4;
                List list = listArray[i2];
                for (int i3 = 0; i3 < list.size() && ((pKIXPolicyNode4 = (PKIXPolicyNode)list.get(i3)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode4)) != null); ++i3) {
                }
            }
        }
        return pKIXPolicyNode;
    }

    protected static boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    protected static void addAdditionalStoreFromLocation(String string, ExtendedPKIXParameters extendedPKIXParameters) {
        if (extendedPKIXParameters.isAdditionalLocationsEnabled()) {
            try {
                if (string.startsWith("ldap://")) {
                    string = string.substring(7);
                    String string2 = null;
                    String string3 = null;
                    if (string.indexOf("/") != -1) {
                        string2 = string.substring(string.indexOf("/"));
                        string3 = "ldap://" + string.substring(0, string.indexOf("/"));
                    } else {
                        string3 = "ldap://" + string;
                    }
                    X509LDAPCertStoreParameters x509LDAPCertStoreParameters = new X509LDAPCertStoreParameters.Builder(string3, string2).build();
                    extendedPKIXParameters.addAddionalStore(X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)x509LDAPCertStoreParameters, "BC"));
                    extendedPKIXParameters.addAddionalStore(X509Store.getInstance("CRL/LDAP", (X509StoreParameters)x509LDAPCertStoreParameters, "BC"));
                    extendedPKIXParameters.addAddionalStore(X509Store.getInstance("ATTRIBUTECERTIFICATE/LDAP", (X509StoreParameters)x509LDAPCertStoreParameters, "BC"));
                    extendedPKIXParameters.addAddionalStore(X509Store.getInstance("CERTIFICATEPAIR/LDAP", (X509StoreParameters)x509LDAPCertStoreParameters, "BC"));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Exception adding X.509 stores.");
            }
        }
    }

    protected static Collection findCertificates(CertSelector certSelector, List list) throws AnnotatedException {
        HashSet<? extends Certificate> hashSet = new HashSet<Certificate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCertificates(certSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return hashSet;
    }

    protected static Collection findCertificates(Selector selector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Store x509Store = (X509Store)iterator.next();
            try {
                hashSet.addAll(x509Store.getMatches(selector));
            }
            catch (StoreException storeException) {
                throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
            }
        }
        return hashSet;
    }

    protected static void addAdditionalStoresFromCRLDistributionPoint(CRLDistPoint cRLDistPoint, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = null;
            try {
                distributionPointArray = cRLDistPoint.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            for (int i2 = 0; i2 < distributionPointArray.length; ++i2) {
                DistributionPointName distributionPointName = distributionPointArray[i2].getDistributionPoint();
                if (distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    if (generalNameArray[i3].getTagNo() != 6) continue;
                    String string = DERIA5String.getInstance(generalNameArray[i3].getName()).getString();
                    CertPathValidatorUtilities.addAdditionalStoreFromLocation(string, extendedPKIXParameters);
                }
            }
        }
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint distributionPoint, Collection collection, X509CRLStoreSelector x509CRLStoreSelector, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        Object object;
        ArrayList<X500Principal> arrayList = new ArrayList<X500Principal>();
        if (distributionPoint.getCRLIssuer() != null) {
            object = distributionPoint.getCRLIssuer().getNames();
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                if (((GeneralName)object[i2]).getTagNo() != 4) continue;
                try {
                    arrayList.add(new X500Principal(((GeneralName)object[i2]).getName().getDERObject().getEncoded()));
                    continue;
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
        } else {
            if (distributionPoint.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            object = collection.iterator();
            while (object.hasNext()) {
                arrayList.add((X500Principal)object.next());
            }
        }
        if (distributionPoint.getDistributionPoint() != null && distributionPoint.getDistributionPoint().getType() == 1) {
            if (arrayList.size() != 1) {
                throw new AnnotatedException("nameRelativeToCRLIssuer field is given but more than one CRL issuer is given.");
            }
            object = distributionPoint.getDistributionPoint().getName();
            Iterator iterator = arrayList.iterator();
            ArrayList<X500Principal> arrayList2 = new ArrayList<X500Principal>(arrayList.size());
            while (iterator.hasNext()) {
                Enumeration enumeration = null;
                try {
                    enumeration = ASN1Sequence.getInstance(new ASN1InputStream(((X500Principal)iterator.next()).getEncoded()).readObject()).getObjects();
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("Cannot decode CRL issuer information.", iOException);
                }
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while (enumeration.hasMoreElements()) {
                    aSN1EncodableVector.add((DEREncodable)enumeration.nextElement());
                }
                aSN1EncodableVector.add((DEREncodable)object);
                arrayList2.add(new X500Principal(new DERSequence(aSN1EncodableVector).getDEREncoded()));
            }
            arrayList.clear();
            arrayList.addAll(arrayList2);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                x509CRLStoreSelector.addIssuerName(((X500Principal)object.next()).getEncoded());
            }
            catch (IOException iOException) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", iOException);
            }
        }
    }

    protected static void getCertStatus(Date date, X509CRL x509CRL, BigInteger bigInteger, CertStatus certStatus) throws AnnotatedException {
        X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(bigInteger);
        if (x509CRLEntry != null) {
            DEREnumerated dEREnumerated = null;
            if (x509CRLEntry.hasExtensions()) {
                try {
                    dEREnumerated = DEREnumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRLEntry, X509Extensions.ReasonCode.getId()));
                }
                catch (Exception exception) {
                    new AnnotatedException("Reason code CRL entry extension could not be decoded.", exception);
                }
            }
            if (date.getTime() >= x509CRLEntry.getRevocationDate().getTime() || dEREnumerated == null || dEREnumerated.getValue().intValue() == 0 || dEREnumerated.getValue().intValue() == 1 || dEREnumerated.getValue().intValue() == 2 || dEREnumerated.getValue().intValue() == 8) {
                if (dEREnumerated != null) {
                    certStatus.setCertStatus(dEREnumerated.getValue().intValue());
                } else {
                    certStatus.setCertStatus(0);
                }
                certStatus.setRevocationDate(x509CRLEntry.getRevocationDate());
            }
        }
    }

    protected static Set getDeltaCRLs(Date date, ExtendedPKIXParameters extendedPKIXParameters, X509CRL x509CRL) throws AnnotatedException {
        BigInteger bigInteger;
        HashSet hashSet = new HashSet();
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        x509CRLStoreSelector.setDateAndTime(date);
        try {
            x509CRLStoreSelector.addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded());
        }
        catch (IOException iOException) {
            new AnnotatedException("Cannot extract issuer from CRL.", iOException);
        }
        try {
            bigInteger = CRLNumber.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, CRL_NUMBER)).getPositiveValue();
        }
        catch (Exception exception) {
            throw new AnnotatedException("CRL number extension could not be extracted from CRL.", exception);
        }
        byte[] byArray = null;
        try {
            byArray = x509CRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension value could not be read.", exception);
        }
        x509CRLStoreSelector.setIssuingDistributionPoint(byArray);
        x509CRLStoreSelector.setIssuingDistributionPointEnabled(true);
        x509CRLStoreSelector.setMaxBaseCRLNumber(bigInteger);
        x509CRLStoreSelector.setMinCRLNumber(bigInteger.add(BigInteger.valueOf(1L)));
        HashSet hashSet2 = new HashSet();
        try {
            hashSet2.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getAddionalStores()));
            hashSet2.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Could not search for delta CRLs.", annotatedException);
        }
        if (hashSet.isEmpty()) {
            throw new AnnotatedException("No delta CRLs found.");
        }
        return hashSet;
    }

    protected static Set getCompleteCRLs(DistributionPoint distributionPoint, Object object, Date date, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        HashSet<Principal> hashSet;
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        try {
            hashSet = new HashSet<Principal>();
            if (object instanceof X509AttributeCertificate) {
                hashSet.add(((X509AttributeCertificate)object).getIssuer().getPrincipals()[0]);
            } else {
                hashSet.add(((X509Certificate)object).getSubjectX500Principal());
            }
            CertPathValidatorUtilities.getCRLIssuersFromDistributionPoint(distributionPoint, hashSet, x509CRLStoreSelector, extendedPKIXParameters);
        }
        catch (AnnotatedException annotatedException) {
            new AnnotatedException("Could not get issuer information from distribution point.", annotatedException);
        }
        if (object instanceof X509Certificate) {
            x509CRLStoreSelector.setCertificateChecking((X509Certificate)object);
        } else {
            x509CRLStoreSelector.setAttrCertificateChecking((X509AttributeCertificate)object);
        }
        x509CRLStoreSelector.setDateAndTime(date);
        x509CRLStoreSelector.setCompleteCRLEnabled(true);
        hashSet = new HashSet();
        try {
            hashSet.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getStores()));
            hashSet.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getAddionalStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Could not search for CRLs.", annotatedException);
        }
        if (hashSet.isEmpty()) {
            throw new AnnotatedException("No CRLs found.");
        }
        return hashSet;
    }

    protected static Date getValidCertDateFromValidityModel(ExtendedPKIXParameters extendedPKIXParameters, CertPath certPath, int n2) throws AnnotatedException {
        if (extendedPKIXParameters.getValidityModel() == 1) {
            if (n2 <= 0) {
                return CertPathValidatorUtilities.getValidDate(extendedPKIXParameters);
            }
            if (n2 - 1 == 0) {
                DERGeneralizedTime dERGeneralizedTime = null;
                try {
                    dERGeneralizedTime = DERGeneralizedTime.getInstance(((X509Certificate)certPath.getCertificates().get(n2 - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (dERGeneralizedTime != null) {
                    try {
                        return dERGeneralizedTime.getDate();
                    }
                    catch (ParseException parseException) {
                        throw new AnnotatedException("Date from dat of cert gen extension could not be parsed.", parseException);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(n2 - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(n2 - 1)).getNotBefore();
        }
        return CertPathValidatorUtilities.getValidDate(extendedPKIXParameters);
    }

    protected static PublicKey getNextWorkingKey(X509Certificate x509Certificate, List list, int n2) throws CertPathValidatorException {
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            return publicKey;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        if (dSAPublicKey.getParams() != null) {
            return dSAPublicKey;
        }
        for (int i2 = n2 + 1; i2 < list.size(); ++i2) {
            X509Certificate x509Certificate2 = (X509Certificate)list.get(i2);
            publicKey = x509Certificate2.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey;
            if (dSAPublicKey2.getParams() == null) continue;
            DSAParams dSAParams = dSAPublicKey2.getParams();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", "BC");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }
}

